/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.storage.blob;

import org.apache.camel.spi.Metadata;

public final class BlobConstants {
    public static final Long PAGE_BLOB_DEFAULT_SIZE = 512L;
    private static final String HEADER_PREFIX = "CamelAzureStorageBlob";
    @Metadata(label="producer", description="(All) Specify the producer operation to execute, please see the doc on this page related to producer operation.", javaType="org.apache.camel.component.azure.storage.blob.BlobOperationsDefinition")
    public static final String BLOB_OPERATION = "CamelAzureStorageBlobOperation";
    @Metadata(label="producer", description="(uploadBlockBlob, commitBlobBlockList, createAppendBlob, createPageBlob) Additional parameters for a set of operations.", javaType="BlobHttpHeaders")
    public static final String BLOB_HTTP_HEADERS = "CamelAzureStorageBlobHttpHeaders";
    @Metadata(label="consumer", description="The E Tag of the blob", javaType="String")
    public static final String E_TAG = "CamelAzureStorageBlobETag";
    @Metadata(label="consumer", description="Creation time of the blob.", javaType="OffsetDateTime")
    public static final String CREATION_TIME = "CamelAzureStorageBlobCreationTime";
    @Metadata(label="consumer", description="Datetime when the blob was last modified.", javaType="OffsetDateTime")
    public static final String LAST_MODIFIED = "CamelAzureStorageBlobLastModified";
    @Metadata(label="consumer", description="Content type specified for the blob.", javaType="String")
    public static final String CONTENT_TYPE = "CamelAzureStorageBlobContentType";
    @Metadata(description="(producer) (Most operations related to upload blob) Most operations related to upload blob|An MD5 hash of the block content. This hash is used to verify the integrity of the block during transport. When this header is specified, the storage service compares the hash of the content that has arrived with this header value. Note that this MD5 hash is not stored with the blob. If the two hashes do not match, the operation will fail.\n(consumer) Content MD5 specified for the blob.", javaType="byte[]")
    public static final String CONTENT_MD5 = "CamelAzureStorageBlobContentMD5";
    @Metadata(label="consumer", description="Content encoding specified for the blob.", javaType="String")
    public static final String CONTENT_ENCODING = "CamelAzureStorageBlobContentEncoding";
    @Metadata(label="consumer", description="Content disposition specified for the blob.", javaType="String")
    public static final String CONTENT_DISPOSITION = "CamelAzureStorageBlobContentDisposition";
    @Metadata(label="consumer", description="Content language specified for the blob.", javaType="String")
    public static final String CONTENT_LANGUAGE = "CamelAzureStorageBlobContentLanguage";
    @Metadata(label="consumer", description="Cache control specified for the blob.", javaType="String")
    public static final String CACHE_CONTROL = "CamelAzureStorageBlobCacheControl";
    @Metadata(label="consumer", description="The size of the blob.", javaType="long")
    public static final String BLOB_SIZE = "CamelAzureStorageBlobBlobSize";
    @Metadata(label="producer", description="When uploading a blob with the uploadBlockBlob-operation this can be used to tell the client what the length of an InputStream is.", javaType="long")
    public static final String BLOB_UPLOAD_SIZE = "CamelAzureStorageBlobBlobUploadSize";
    @Metadata(description="(producer) (createPageBlob) A user-controlled value that you can use to track requests. The value of the sequence number must be between 0 and 2^63 - 1. The default value is 0.\n(consumer) The current sequence number for a page blob.", javaType="Long")
    public static final String BLOB_SEQUENCE_NUMBER = "CamelAzureStorageBlobSequenceNumber";
    @Metadata(label="consumer", description="The type of the blob.", javaType="org.apache.camel.component.azure.storage.blob.BlobType")
    public static final String BLOB_TYPE = "CamelAzureStorageBlobBlobType";
    @Metadata(label="consumer", description="Status of the lease on the blob.", javaType="com.azure.storage.blob.models.LeaseStatusType")
    public static final String LEASE_STATUS = "CamelAzureStorageBlobLeaseStatus";
    @Metadata(label="consumer", description="State of the lease on the blob.", javaType="com.azure.storage.blob.models.LeaseStateType")
    public static final String LEASE_STATE = "CamelAzureStorageBlobLeaseState";
    @Metadata(label="consumer", description="Type of lease on the blob.", javaType="com.azure.storage.blob.models.LeaseDurationType")
    public static final String LEASE_DURATION = "CamelAzureStorageBlobLeaseDuration";
    @Metadata(label="consumer", description="Identifier of the last copy operation performed on the blob.", javaType="String")
    public static final String COPY_ID = "CamelAzureStorageBlobCopyId";
    @Metadata(label="consumer", description="Status of the last copy operation performed on the blob.", javaType="com.azure.storage.blob.models.CopyStatusType")
    public static final String COPY_STATUS = "CamelAzureStorageBlobCopyStatus";
    @Metadata(label="consumer", description="Source of the last copy operation performed on the blob.", javaType="String")
    public static final String COPY_SOURCE = "CamelAzureStorageBlobCopySource";
    @Metadata(label="consumer", description="Progress of the last copy operation performed on the blob.", javaType="String")
    public static final String COPY_PROGRESS = "CamelAzureStorageBlobCopyProgress";
    @Metadata(label="consumer", description="Datetime when the last copy operation on the blob completed.", javaType="OffsetDateTime")
    public static final String COPY_COMPILATION_TIME = "CamelAzureStorageBlobCopyCompletionTime";
    @Metadata(label="consumer", description="Description of the last copy operation on the blob.", javaType="String")
    public static final String COPY_STATUS_DESCRIPTION = "CamelAzureStorageBlobCopyStatusDescription";
    @Metadata(label="consumer", description="Snapshot identifier of the last incremental copy snapshot for the blob.", javaType="String")
    public static final String COPY_DESTINATION_SNAPSHOT = "CamelAzureStorageBlobCopyDestinationSnapshot";
    @Metadata(label="consumer", description="Flag indicating if the blob's content is encrypted on the server.", javaType="boolean")
    public static final String IS_SERVER_ENCRYPTED = "CamelAzureStorageBlobIsServerEncrypted";
    @Metadata(label="consumer", description="Flag indicating if the blob was incrementally copied.", javaType="boolean")
    public static final String IS_INCREMENTAL_COPY = "CamelAzureStorageBlobIsIncrementalCopy";
    @Metadata(description="(producer) (uploadBlockBlob, commitBlobBlockList) Defines values for AccessTier.\n(consumer) Access tier of the blob.", javaType="AccessTier")
    public static final String ACCESS_TIER = "CamelAzureStorageBlobAccessTier";
    @Metadata(label="consumer", description="Flag indicating if the access tier of the blob was inferred from properties of the blob.", javaType="boolean")
    public static final String IS_ACCESS_TIER_INFRRRED = "CamelAzureStorageBlobIsAccessTierInferred";
    @Metadata(label="consumer", description="Archive status of the blob.", javaType="ArchiveStatus")
    public static final String ARCHIVE_STATUS = "CamelAzureStorageBlobArchiveStatus";
    public static final String ENCRYPTION_KEY_SHA_256 = "CamelAzureStorageBlobEncryptionKeySha256";
    public static final String ENCRYPTION_SCOPE = "CamelAzureStorageBlobEncryptionScope";
    @Metadata(label="consumer", description="Datetime when the access tier of the blob last changed.", javaType="OffsetDateTime")
    public static final String ACCESS_TIER_CHANGE_TIME = "CamelAzureStorageBlobaccessTierChangeTime";
    @Metadata(description="(producer) (Operations related to container and blob) Operations related to container and blob| Metadata to associate with the container or blob.\n(consumer) Additional metadata associated with the blob.", javaType="Map<String,String>")
    public static final String METADATA = "CamelAzureStorageBlobMetadata";
    @Metadata(label="consumer", description="Number of blocks committed to an append blob", javaType="Integer")
    public static final String COMMITTED_BLOCK_COUNT = "CamelAzureStorageBlobCommittedBlockCount";
    @Metadata(label="consumer", description="The offset at which the block was committed to the block blob.", javaType="String")
    public static final String APPEND_OFFSET = "CamelAzureStorageBlobAppendOffset";
    @Metadata(label="consumer", description="Returns non-parsed httpHeaders that can be used by the user.", javaType="HttpHeaders")
    public static final String RAW_HTTP_HEADERS = "CamelAzureStorageBlobRawHttpHeaders";
    @Metadata(label="consumer", description="The downloaded filename from the operation `downloadBlobToFile`.", javaType="String")
    public static final String FILE_NAME = "CamelAzureStorageBlobFileName";
    @Metadata(label="consumer", description="The download link generated by `downloadLink` operation.", javaType="String")
    public static final String DOWNLOAD_LINK = "CamelAzureStorageBlobDownloadLink";
    @Metadata(label="producer", description="(listBlobs) Defines options available to configure the behavior of a call to listBlobsFlatSegment on a `BlobContainerClient` object.", javaType="ListBlobsOptions")
    public static final String LIST_BLOB_OPTIONS = "CamelAzureStorageBlobListBlobOptions";
    @Metadata(label="producer", description="(listBlobs) The details for listing specific blobs", javaType="BlobListDetails")
    public static final String BLOB_LIST_DETAILS = "CamelAzureStorageBlobListDetails";
    @Metadata(label="producer", description="(listBlobs,getBlob) Filters the results to return only blobs whose names begin with the specified prefix. May be null to return all blobs.", javaType="String")
    public static final String PREFIX = "CamelAzureStorageBlobPrefix";
    @Metadata(label="producer", description="(listBlobs,getBlob) Filters the results to return only blobs whose names match the specified regular expression. May be null to return all. If both prefix and regex are set, regex takes the priority and prefix is ignored.", javaType="String")
    public static final String REGEX = "CamelAzureStorageBlobRegex";
    @Metadata(label="producer", description="(listBlobs) Specifies the maximum number of blobs to return, including all BlobPrefix elements. If the request does not specify maxResultsPerPage or specifies a value greater than 5,000, the server will return up to 5,000 items.", javaType="Integer")
    public static final String MAX_RESULTS_PER_PAGE = "CamelAzureStorageBlobMaxResultsPerPage";
    @Metadata(label="producer", description="(All) An optional timeout value beyond which a `RuntimeException` will be raised.", javaType="Duration")
    public static final String TIMEOUT = "CamelAzureStorageBlobTimeout";
    @Metadata(label="producer", description="(createContainer) Specifies how the data in this container is available to the public. Pass `null` for no public access.", javaType="PublicAccessType")
    public static final String PUBLIC_ACCESS_TYPE = "CamelAzureStorageBlobPublicAccessType";
    @Metadata(label="producer", description="(Operations related to container and blob) This contains values which will restrict the successful operation of a variety of requests to the conditions present. These conditions are entirely optional.", javaType="BlobRequestConditions")
    public static final String BLOB_REQUEST_CONDITION = "CamelAzureStorageBlobRequestCondition";
    @Metadata(label="producer", description="(Operations related to container and blob) Override/set the container name on the exchange headers.", javaType="String")
    public static final String BLOB_CONTAINER_NAME = "CamelAzureStorageBlobBlobContainerName";
    @Metadata(label="producer", description="(Operations related to blob) Override/set the blob name on the exchange headers.", javaType="String")
    public static final String BLOB_NAME = "CamelAzureStorageBlobBlobName";
    @Metadata(label="producer", description="(downloadBlobToFile) The file directory where the downloaded blobs will be saved to.", javaType="String")
    public static final String FILE_DIR = "CamelAzureStorageBlobFileDir";
    @Metadata(label="producer", description="(Operations related to page blob) A `PageRange` object. Given that pages must be aligned with 512-byte boundaries, the start offset must be a modulus of 512 and the end offset must be a modulus of 512 - 1. Examples of valid byte ranges are 0-511, 512-1023, etc.", javaType="PageRange")
    public static final String PAGE_BLOB_RANGE = "CamelAzureStorageBlobPageBlobRange";
    @Metadata(label="producer", description="(createPageBlob, resizePageBlob) Specifies the maximum size for the page blob, up to 8 TB. The page blob size must be aligned to a 512-byte boundary.", javaType="Long")
    public static final String PAGE_BLOB_SIZE = "CamelAzureStorageBlobPageBlobSize";
    @Metadata(label="producer", description="(stageBlockBlobList) When is set to `true`, the staged blocks will not be committed directly.", javaType="boolean")
    public static final String COMMIT_BLOCK_LIST_LATER = "CamelAzureStorageBlobCommitBlobBlockListLater";
    @Metadata(label="producer", description="(getBlobBlockList) Specifies which type of blocks to return.", javaType="com.azure.storage.blob.models.BlockListType")
    public static final String BLOCK_LIST_TYPE = "CamelAzureStorageBlobBlockListType";
    @Metadata(label="producer", description="(commitAppendBlob) When is set to `true`, the append blocks will be created when committing append blocks.", javaType="boolean")
    public static final String CREATE_APPEND_BLOB = "CamelAzureStorageBlobCreateAppendBlob";
    @Metadata(label="producer", description="(uploadPageBlob) When is set to `true`, the page blob will be created when uploading page blob.", javaType="boolean")
    public static final String CREATE_PAGE_BLOB = "CamelAzureStorageBlobCreatePageBlob";
    @Metadata(label="producer", description="(deleteBlob) Specifies the behavior for deleting the snapshots on this blob. `Include` will delete the base blob and all snapshots. `Only` will delete only the snapshots. If a snapshot is being deleted, you must pass null.", javaType="com.azure.storage.blob.models.DeleteSnapshotsOptionType")
    public static final String DELETE_SNAPSHOT_OPTION_TYPE = "CamelAzureStorageBlobDeleteSnapshotsOptionType";
    @Metadata(label="producer", description="(listBlobContainers) A `ListBlobContainersOptions` which specifies what data should be returned by the service.", javaType="ListBlobContainersOptions")
    public static final String LIST_BLOB_CONTAINERS_OPTIONS = "CamelAzureStorageBlobListBlobContainersOptions";
    @Metadata(label="producer", description="(downloadBlobToFile) `ParallelTransferOptions` to use to download to file. Number of parallel transfers parameter is ignored.", javaType="ParallelTransferOptions")
    public static final String PARALLEL_TRANSFER_OPTIONS = "CamelAzureStorageBlobParallelTransferOptions";
    @Metadata(label="producer", description="(downloadLink) Override the default expiration (millis) of URL download link.", javaType="Long")
    public static final String DOWNLOAD_LINK_EXPIRATION = "CamelAzureStorageBlobDownloadLinkExpiration";
    @Metadata(label="producer", description="(copyBlob) The source blob account name to be used as source account name in a copy blob operation", javaType="String")
    public static final String SOURCE_BLOB_ACCOUNT_NAME = "CamelAzureStorageBlobSourceBlobAccountName";
    @Metadata(label="producer", description="(copyBlob) The source blob container name to be used as source container name in a copy blob operation", javaType="String")
    public static final String SOURCE_BLOB_CONTAINER_NAME = "CamelAzureStorageBlobSourceBlobContainerName";
    public static final String DESTINATION_BLOB_NAME = "CamelAzureStorageBlobDestinationBlobContainerName";
    @Metadata(label="producer", description="(getChangeFeed) It filters the results to return events approximately after the start time. Note: A few events belonging to the previous hour can also be returned. A few events belonging to this hour can be missing; to ensure all events from the hour are returned, round the start time down by an hour.", javaType="OffsetDateTime")
    public static final String CHANGE_FEED_START_TIME = "CamelAzureStorageBlobChangeFeedStartTime";
    @Metadata(label="producer", description="(getChangeFeed) It filters  the results to return events approximately before the end time. Note: A few events belonging to the next hour can also be returned. A few events belonging to this hour can be missing; to ensure all events from the hour are returned, round the end time up by an hour.", javaType="OffsetDateTime")
    public static final String CHANGE_FEED_END_TIME = "CamelAzureStorageBlobChangeFeedEndTime";
    @Metadata(label="producer", description="(getChangeFeed) This gives additional context that is passed through the Http pipeline during the service call.", javaType="Context")
    public static final String CHANGE_FEED_CONTEXT = "CamelAzureStorageBlobContext";

    private BlobConstants() {
    }
}

