/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.storage.blob.client;

import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.models.BlobContainerItem;
import com.azure.storage.blob.models.ListBlobContainersOptions;
import java.time.Duration;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.camel.component.azure.storage.blob.client.BlobContainerClientWrapper;
import org.apache.camel.util.ObjectHelper;

public class BlobServiceClientWrapper {
    private final BlobServiceClient client;

    public BlobServiceClientWrapper(BlobServiceClient client) {
        ObjectHelper.notNull((Object)client, (String)"client cannot be null");
        this.client = client;
    }

    public List<BlobContainerItem> listBlobContainers(ListBlobContainersOptions options, Duration timeout) {
        return this.client.listBlobContainers(options, timeout).stream().collect(Collectors.toList());
    }

    public BlobContainerClientWrapper getBlobContainerClientWrapper(String containerName) {
        if (!ObjectHelper.isEmpty((Object)containerName)) {
            return new BlobContainerClientWrapper(this.client.getBlobContainerClient(containerName));
        }
        throw new IllegalArgumentException("Cannot initialize a blob container since no container name was provided.");
    }
}

