/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.storage.blob.client;

import com.azure.core.http.HttpHeaders;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.util.Context;
import com.azure.storage.blob.BlobClient;
import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.BlobServiceClientBuilder;
import com.azure.storage.blob.models.AccessTier;
import com.azure.storage.blob.models.AppendBlobItem;
import com.azure.storage.blob.models.AppendBlobRequestConditions;
import com.azure.storage.blob.models.BlobDownloadHeaders;
import com.azure.storage.blob.models.BlobHttpHeaders;
import com.azure.storage.blob.models.BlobProperties;
import com.azure.storage.blob.models.BlobRange;
import com.azure.storage.blob.models.BlobRequestConditions;
import com.azure.storage.blob.models.BlockBlobItem;
import com.azure.storage.blob.models.BlockList;
import com.azure.storage.blob.models.BlockListType;
import com.azure.storage.blob.models.DeleteSnapshotsOptionType;
import com.azure.storage.blob.models.DownloadRetryOptions;
import com.azure.storage.blob.models.PageBlobItem;
import com.azure.storage.blob.models.PageBlobRequestConditions;
import com.azure.storage.blob.models.PageRange;
import com.azure.storage.blob.models.PageRangeItem;
import com.azure.storage.blob.models.ParallelTransferOptions;
import com.azure.storage.blob.options.ListPageRangesOptions;
import com.azure.storage.blob.sas.BlobSasPermission;
import com.azure.storage.blob.sas.BlobServiceSasSignatureValues;
import com.azure.storage.blob.specialized.AppendBlobClient;
import com.azure.storage.blob.specialized.BlobInputStream;
import com.azure.storage.blob.specialized.BlockBlobClient;
import com.azure.storage.blob.specialized.PageBlobClient;
import com.azure.storage.common.StorageSharedKeyCredential;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.camel.util.ObjectHelper;

public class BlobClientWrapper {
    private static final String SERVICE_URI_SEGMENT = ".blob.core.windows.net";
    private final BlobClient client;

    public BlobClientWrapper(BlobClient client) {
        ObjectHelper.notNull((Object)client, (String)"client can not be null");
        this.client = client;
    }

    public String getBlobName() {
        return this.client.getBlobName();
    }

    public String getBlobUrl() {
        return this.client.getBlobUrl();
    }

    public Response<Void> delete(DeleteSnapshotsOptionType deleteBlobSnapshotOptions, BlobRequestConditions requestConditions, Duration timeout) {
        return this.client.deleteWithResponse(deleteBlobSnapshotOptions, requestConditions, timeout, Context.NONE);
    }

    public Map<String, Object> openInputStream(BlobRange blobRange, BlobRequestConditions blobRequestConditions) {
        BlobInputStream blobInputStream = this.client.openInputStream(blobRange, blobRequestConditions);
        HashMap<String, Object> results = new HashMap<String, Object>();
        results.put("inputStream", blobInputStream);
        results.put("properties", blobInputStream.getProperties());
        return results;
    }

    public ResponseBase<BlobDownloadHeaders, Void> downloadWithResponse(OutputStream stream, BlobRange range, DownloadRetryOptions options, BlobRequestConditions requestConditions, boolean getRangeContentMd5, Duration timeout) {
        return this.client.downloadStreamWithResponse(stream, range, options, requestConditions, getRangeContentMd5, timeout, Context.NONE);
    }

    public Response<BlobProperties> downloadToFileWithResponse(String filePath, BlobRange range, ParallelTransferOptions parallelTransferOptions, DownloadRetryOptions downloadRetryOptions, BlobRequestConditions requestConditions, boolean rangeGetContentMd5, Duration timeout) {
        return this.client.downloadToFileWithResponse(filePath, range, parallelTransferOptions, downloadRetryOptions, requestConditions, rangeGetContentMd5, timeout, Context.NONE);
    }

    public Response<BlockBlobItem> uploadBlockBlob(InputStream data, long length, BlobHttpHeaders headers, Map<String, String> metadata, AccessTier tier, byte[] contentMd5, BlobRequestConditions requestConditions, Duration timeout) {
        return this.getBlockBlobClient().uploadWithResponse(data, length, headers, metadata, tier, contentMd5, requestConditions, timeout, Context.NONE);
    }

    public HttpHeaders stageBlockBlob(String base64BlockId, InputStream data, long length, byte[] contentMd5, String leaseId, Duration timeout) {
        return this.client.getBlockBlobClient().stageBlockWithResponse(base64BlockId, data, length, contentMd5, leaseId, timeout, Context.NONE).getHeaders();
    }

    public Response<BlockBlobItem> commitBlockBlob(List<String> base64BlockIds, BlobHttpHeaders headers, Map<String, String> metadata, AccessTier tier, BlobRequestConditions requestConditions, Duration timeout) {
        return this.getBlockBlobClient().commitBlockListWithResponse(base64BlockIds, headers, metadata, tier, requestConditions, timeout, Context.NONE);
    }

    public Response<BlockList> listBlobBlocks(BlockListType listType, String leaseId, Duration timeout) {
        return this.getBlockBlobClient().listBlocksWithResponse(listType, leaseId, timeout, Context.NONE);
    }

    public Response<AppendBlobItem> createAppendBlob(BlobHttpHeaders headers, Map<String, String> metadata, BlobRequestConditions requestConditions, Duration timeout) {
        return this.getAppendBlobClient().createWithResponse(headers, metadata, requestConditions, timeout, Context.NONE);
    }

    public Response<AppendBlobItem> appendBlobBlock(InputStream data, long length, byte[] contentMd5, AppendBlobRequestConditions appendBlobRequestConditions, Duration timeout) {
        return this.getAppendBlobClient().appendBlockWithResponse(data, length, contentMd5, appendBlobRequestConditions, timeout, Context.NONE);
    }

    public String copyBlob(String sourceBlobName, String accountName, String containerName, String accessKey) {
        BlobServiceClient blobServiceClient = new BlobServiceClientBuilder().endpoint(String.format(Locale.ROOT, "https://%s.blob.core.windows.net", accountName)).credential(new StorageSharedKeyCredential(accountName, accessKey)).buildClient();
        BlobContainerClient sourceContainerClient = blobServiceClient.getBlobContainerClient(containerName);
        BlobClient sourceBlob = sourceContainerClient.getBlobClient(sourceBlobName);
        OffsetDateTime expiryTime = OffsetDateTime.now().plusSeconds(5L);
        BlobSasPermission permission = new BlobSasPermission().setReadPermission(true);
        BlobServiceSasSignatureValues values = new BlobServiceSasSignatureValues(expiryTime, permission).setStartTime(OffsetDateTime.now());
        String sasToken = sourceBlob.generateSas(values);
        return this.client.copyFromUrl(sourceBlob.getBlobUrl() + "?" + sasToken);
    }

    public boolean appendBlobExists() {
        return this.getAppendBlobClient().exists();
    }

    public Response<PageBlobItem> createPageBlob(long size, Long sequenceNumber, BlobHttpHeaders headers, Map<String, String> metadata, BlobRequestConditions requestConditions, Duration timeout) {
        return this.getPageBlobClient().createWithResponse(size, sequenceNumber, headers, metadata, requestConditions, timeout, Context.NONE);
    }

    public Response<PageBlobItem> uploadPageBlob(PageRange pageRange, InputStream body, byte[] contentMd5, PageBlobRequestConditions pageBlobRequestConditions, Duration timeout) {
        return this.getPageBlobClient().uploadPagesWithResponse(pageRange, body, contentMd5, pageBlobRequestConditions, timeout, Context.NONE);
    }

    public Response<PageBlobItem> resizePageBlob(long size, BlobRequestConditions requestConditions, Duration timeout) {
        return this.getPageBlobClient().resizeWithResponse(size, requestConditions, timeout, Context.NONE);
    }

    public Response<PageBlobItem> clearPagesBlob(PageRange pageRange, PageBlobRequestConditions pageBlobRequestConditions, Duration timeout) {
        return this.getPageBlobClient().clearPagesWithResponse(pageRange, pageBlobRequestConditions, timeout, Context.NONE);
    }

    public PagedIterable<PageRangeItem> getPageBlobRanges(BlobRange blobRange, BlobRequestConditions requestConditions, Duration timeout) {
        ListPageRangesOptions listPageRangesOptions = new ListPageRangesOptions(blobRange);
        listPageRangesOptions.setRequestConditions(requestConditions);
        return this.getPageBlobClient().listPageRanges(listPageRangesOptions, timeout, Context.NONE);
    }

    public boolean pageBlobExists() {
        return this.getPageBlobClient().exists();
    }

    public String generateSas(BlobServiceSasSignatureValues blobServiceSasSignatureValues) {
        return this.client.generateSas(blobServiceSasSignatureValues);
    }

    private BlockBlobClient getBlockBlobClient() {
        return this.client.getBlockBlobClient();
    }

    private AppendBlobClient getAppendBlobClient() {
        return this.client.getAppendBlobClient();
    }

    private PageBlobClient getPageBlobClient() {
        return this.client.getPageBlobClient();
    }
}

