/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.storage.blob.client;

import com.azure.core.credential.TokenCredential;
import com.azure.identity.DefaultAzureCredentialBuilder;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.BlobServiceClientBuilder;
import com.azure.storage.common.StorageSharedKeyCredential;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import org.apache.camel.component.azure.storage.blob.BlobConfiguration;
import org.apache.camel.component.azure.storage.blob.CredentialType;
import org.apache.camel.util.ObjectHelper;

public final class BlobClientFactory {
    private static final String SERVICE_URI_SEGMENT = ".blob.core.windows.net";

    private BlobClientFactory() {
    }

    public static BlobServiceClient createBlobServiceClient(BlobConfiguration configuration) {
        BlobServiceClientBuilder blobServiceClientBuilder = new BlobServiceClientBuilder().endpoint(BlobClientFactory.buildAzureEndpointUri(configuration));
        if (Set.of(CredentialType.SHARED_KEY_CREDENTIAL, CredentialType.SHARED_ACCOUNT_KEY).contains((Object)configuration.getCredentialType())) {
            blobServiceClientBuilder.credential(BlobClientFactory.getSharedKeyCredential(configuration));
        } else {
            blobServiceClientBuilder.credential((TokenCredential)new DefaultAzureCredentialBuilder().build());
        }
        return blobServiceClientBuilder.buildClient();
    }

    private static String buildAzureEndpointUri(BlobConfiguration configuration) {
        return String.format(Locale.ROOT, "https://%s.blob.core.windows.net", BlobClientFactory.getAccountName(configuration));
    }

    private static StorageSharedKeyCredential getSharedKeyCredential(BlobConfiguration configuration) {
        return Optional.ofNullable(configuration.getCredentials()).orElseGet(() -> new StorageSharedKeyCredential(configuration.getAccountName(), configuration.getAccessKey()));
    }

    private static String getAccountName(BlobConfiguration configuration) {
        return !ObjectHelper.isEmpty((Object)configuration.getCredentials()) ? configuration.getCredentials().getAccountName() : configuration.getAccountName();
    }
}

