/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.storage.blob;

import com.azure.core.util.Context;
import com.azure.storage.blob.models.AccessTier;
import com.azure.storage.blob.models.BlobHttpHeaders;
import com.azure.storage.blob.models.BlobListDetails;
import com.azure.storage.blob.models.BlobRange;
import com.azure.storage.blob.models.BlobRequestConditions;
import com.azure.storage.blob.models.BlockListType;
import com.azure.storage.blob.models.DeleteSnapshotsOptionType;
import com.azure.storage.blob.models.ListBlobContainersOptions;
import com.azure.storage.blob.models.ListBlobsOptions;
import com.azure.storage.blob.models.PageRange;
import com.azure.storage.blob.models.ParallelTransferOptions;
import com.azure.storage.blob.models.PublicAccessType;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.camel.Exchange;
import org.apache.camel.component.azure.storage.blob.BlobConfiguration;
import org.apache.camel.component.azure.storage.blob.BlobExchangeHeaders;
import org.apache.camel.component.azure.storage.blob.BlobOperationsDefinition;
import org.apache.camel.component.azure.storage.blob.BlobType;
import org.apache.camel.util.ObjectHelper;

public class BlobConfigurationOptionsProxy {
    private final BlobConfiguration configuration;

    public BlobConfigurationOptionsProxy(BlobConfiguration configuration) {
        this.configuration = configuration;
    }

    public ListBlobContainersOptions getListBlobContainersOptions(Exchange exchange) {
        return this.getOption(BlobExchangeHeaders::getListBlobContainersOptionsFromHeaders, () -> null, exchange);
    }

    public Duration getTimeout(Exchange exchange) {
        return this.getOption(BlobExchangeHeaders::getTimeoutFromHeaders, this.configuration::getTimeout, exchange);
    }

    public ListBlobsOptions getListBlobsOptions(Exchange exchange) {
        return this.getOption(BlobExchangeHeaders::getListBlobsOptionsFromHeaders, () -> null, exchange);
    }

    public BlobListDetails getBlobListDetails(Exchange exchange) {
        return this.getOption(BlobExchangeHeaders::getBlobListDetailsFromHeaders, () -> null, exchange);
    }

    public String getPrefix(Exchange exchange) {
        if (ObjectHelper.isNotEmpty((String)this.getRegex(exchange))) {
            return null;
        }
        return this.getOption(BlobExchangeHeaders::getPrefixFromHeaders, this.configuration::getPrefix, exchange);
    }

    public String getRegex(Exchange exchange) {
        return this.getOption(BlobExchangeHeaders::getRegexFromHeaders, this.configuration::getRegex, exchange);
    }

    public Integer getMaxResultsPerPage(Exchange exchange) {
        return this.getOption(BlobExchangeHeaders::getMaxResultsPerPageFromHeaders, this.configuration::getMaxResultsPerPage, exchange);
    }

    public ListBlobsOptions getListBlobOptions(Exchange exchange) {
        ListBlobsOptions blobsOptions = this.getListBlobsOptions(exchange);
        if (blobsOptions == null) {
            blobsOptions = new ListBlobsOptions();
        }
        if (!ObjectHelper.isEmpty((Object)blobsOptions)) {
            return blobsOptions;
        }
        blobsOptions = new ListBlobsOptions();
        BlobListDetails blobListDetails = this.getBlobListDetails(exchange);
        String prefix = this.getPrefix(exchange);
        Integer maxResultsPerPage = this.getMaxResultsPerPage(exchange);
        blobsOptions.setDetails(blobListDetails);
        blobsOptions.setMaxResultsPerPage(maxResultsPerPage);
        blobsOptions.setPrefix(prefix);
        return blobsOptions;
    }

    public Map<String, String> getMetadata(Exchange exchange) {
        return BlobExchangeHeaders.getMetadataFromHeaders(exchange);
    }

    public PublicAccessType getPublicAccessType(Exchange exchange) {
        return BlobExchangeHeaders.getPublicAccessTypeFromHeaders(exchange);
    }

    public BlobRequestConditions getBlobRequestConditions(Exchange exchange) {
        return BlobExchangeHeaders.getBlobRequestConditionsFromHeaders(exchange);
    }

    public PageRange getPageRange(Exchange exchange) {
        return BlobExchangeHeaders.getPageRangeFromHeaders(exchange);
    }

    public BlobRange getBlobRange(Exchange exchange) {
        PageRange pageRange;
        if (this.configuration.getBlobType() == BlobType.pageblob && (pageRange = this.getPageRange(exchange)) != null) {
            long blobOffset = pageRange.getStart();
            long dataCount = pageRange.getEnd() - pageRange.getStart();
            return new BlobRange(blobOffset, Long.valueOf(dataCount));
        }
        return new BlobRange(this.configuration.getBlobOffset(), this.configuration.getDataCount());
    }

    public BlobHttpHeaders getBlobHttpHeaders(Exchange exchange) {
        return BlobExchangeHeaders.getBlobHttpHeadersFromHeaders(exchange);
    }

    public AccessTier getAccessTier(Exchange exchange) {
        return BlobExchangeHeaders.getAccessTierFromHeaders(exchange);
    }

    public byte[] getContentMd5(Exchange exchange) {
        return BlobExchangeHeaders.getContentMd5FromHeaders(exchange);
    }

    public String getFileDir(Exchange exchange) {
        return this.getOption(BlobExchangeHeaders::getFileDirFromHeaders, this.configuration::getFileDir, exchange);
    }

    public ParallelTransferOptions getParallelTransferOptions(Exchange exchange) {
        return BlobExchangeHeaders.getParallelTransferOptionsFromHeaders(exchange);
    }

    public DeleteSnapshotsOptionType getDeleteSnapshotsOptionType(Exchange exchange) {
        return BlobExchangeHeaders.getDeleteSnapshotsOptionTypeFromHeaders(exchange);
    }

    public Long getDownloadLinkExpiration(Exchange exchange) {
        return this.getOption(BlobExchangeHeaders::getDownloadLinkExpirationFromHeaders, this.configuration::getDownloadLinkExpiration, exchange);
    }

    public boolean isCommitBlockListLater(Exchange exchange) {
        return this.getOption(BlobExchangeHeaders::getCommitBlockListFlagFromHeaders, this.configuration::isCommitBlockListLater, exchange);
    }

    public BlockListType getBlockListType(Exchange exchange) {
        return this.getOption(BlobExchangeHeaders::getBlockListTypeFromHeaders, this.configuration::getBlockListType, exchange);
    }

    public boolean isCreateAppendBlob(Exchange exchange) {
        return this.getOption(BlobExchangeHeaders::getCreateAppendBlobFlagFromHeaders, this.configuration::isCreateAppendBlob, exchange);
    }

    public Long getPageBlobSize(Exchange exchange) {
        return this.getOption(BlobExchangeHeaders::getPageBlobSize, this.configuration::getPageBlobSize, exchange);
    }

    public Long getBlobSequenceNumber(Exchange exchange) {
        return this.getOption(BlobExchangeHeaders::getBlobSequenceNumberFromHeaders, this.configuration::getBlobSequenceNumber, exchange);
    }

    public boolean isCreatePageBlob(Exchange exchange) {
        return this.getOption(BlobExchangeHeaders::getCreatePageBlobFlagFromHeaders, this.configuration::isCreatePageBlob, exchange);
    }

    public String getBlobName(Exchange exchange) {
        return this.getOption(BlobExchangeHeaders::getBlobNameFromHeaders, this.configuration::getBlobName, exchange);
    }

    public String getContainerName(Exchange exchange) {
        return this.getOption(BlobExchangeHeaders::getBlobContainerNameFromHeaders, this.configuration::getContainerName, exchange);
    }

    public BlobOperationsDefinition getOperation(Exchange exchange) {
        return this.getOption(BlobExchangeHeaders::getBlobOperationsDefinitionFromHeaders, this.configuration::getOperation, exchange);
    }

    public int getMaxRetryRequests() {
        return this.configuration.getMaxRetryRequests();
    }

    public OffsetDateTime getChangeFeedStartTime(Exchange exchange) {
        return this.getOption(BlobExchangeHeaders::getChangeFeedStartTimeFromHeaders, this.configuration::getChangeFeedStartTime, exchange);
    }

    public OffsetDateTime getChangeFeedEndTime(Exchange exchange) {
        return this.getOption(BlobExchangeHeaders::getChangeFeedEndTimeFromHeaders, this.configuration::getChangeFeedEndTime, exchange);
    }

    public Context getChangeFeedContext(Exchange exchange) {
        return this.getOption(BlobExchangeHeaders::getChangeFeedContextFromHeaders, this.configuration::getChangeFeedContext, exchange);
    }

    public BlobConfiguration getConfiguration() {
        return this.configuration;
    }

    private <R> R getOption(Function<Exchange, R> exchangeFn, Supplier<R> fallbackFn, Exchange exchange) {
        return ObjectHelper.isEmpty((Object)exchange) || ObjectHelper.isEmpty(exchangeFn.apply(exchange)) ? fallbackFn.get() : exchangeFn.apply(exchange);
    }
}

