/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.azure;

import com.azure.storage.file.share.models.ShareFileItem;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileOperationFailedException;
import org.apache.camel.component.file.GenericFileProcessStrategy;
import org.apache.camel.component.file.azure.FilesEndpoint;
import org.apache.camel.component.file.azure.FilesOperations;
import org.apache.camel.component.file.azure.FilesPath;
import org.apache.camel.component.file.remote.RemoteFile;
import org.apache.camel.component.file.remote.RemoteFileConfiguration;
import org.apache.camel.component.file.remote.RemoteFileConsumer;
import org.apache.camel.component.file.remote.RemoteFileEndpoint;
import org.apache.camel.component.file.remote.RemoteFileOperations;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedResource(description="Camel Azure Files consumer")
public class FilesConsumer
extends RemoteFileConsumer<ShareFileItem> {
    private static final Logger LOG = LoggerFactory.getLogger(FilesConsumer.class);
    protected String endpointPath;
    private transient String toString;

    public FilesConsumer(FilesEndpoint endpoint, Processor processor, FilesOperations fileOperations, GenericFileProcessStrategy<?> processStrategy) {
        super((RemoteFileEndpoint)endpoint, processor, (RemoteFileOperations)fileOperations, processStrategy);
        this.endpointPath = endpoint.getConfiguration().getDirectory();
    }

    protected FilesOperations getOperations() {
        return (FilesOperations)super.getOperations();
    }

    protected void doStart() throws Exception {
        boolean startScheduler = this.isStartScheduler();
        this.setStartScheduler(false);
        try {
            super.doStart();
            if (this.endpoint.isAutoCreate() && this.hasStartingDirectory()) {
                LOG.debug("Auto creating directory: {}", (Object)this.endpointPath);
                try {
                    this.connectIfNecessary();
                    this.operations.buildDirectory(this.endpointPath, true);
                }
                catch (GenericFileOperationFailedException e) {
                    LOG.warn("Error auto creating directory: {} due to {}. This exception is ignored.", new Object[]{this.endpointPath, e.getMessage(), e});
                }
            }
        }
        finally {
            if (startScheduler) {
                this.setStartScheduler(true);
                this.startScheduler();
            }
        }
    }

    protected boolean pollDirectory(String path, List<GenericFile<ShareFileItem>> fileList, int depth) {
        LOG.trace("pollDirectory({},,{})", (Object)path, (Object)depth);
        return this.doPollDirectory(FilesPath.trimTrailingSeparator(path), null, fileList, depth);
    }

    protected boolean doPollDirectory(String path, String dirName, List<GenericFile<ShareFileItem>> fileList, int depth) {
        LOG.trace("doPollDirectory({},{},,{})", new Object[]{path, dirName, depth});
        ShareFileItem[] listedFileItems = this.listFileItems(path);
        this.forceConsumerAsReady();
        if (listedFileItems == null || listedFileItems.length == 0) {
            LOG.trace("No files found in directory: {}", (Object)path);
            return true;
        }
        LOG.trace("Found {} files in directory: {}", (Object)listedFileItems.length, (Object)path);
        if (this.getEndpoint().isPreSort()) {
            Arrays.sort(listedFileItems, Comparator.comparing(ShareFileItem::getName));
        }
        for (ShareFileItem fileItem : listedFileItems) {
            if (!this.handleFileItem(path, fileList, depth + 1, listedFileItems, fileItem)) continue;
            return false;
        }
        return true;
    }

    private boolean handleFileItem(String path, List<GenericFile<ShareFileItem>> polledFiles, int depth, ShareFileItem[] listedFileItems, ShareFileItem fileItem) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Item[name={}, dir={}]", (Object)fileItem.getName(), (Object)fileItem.isDirectory());
        }
        if (!this.canPollMoreFiles(polledFiles)) {
            return true;
        }
        if (fileItem.isDirectory()) {
            if (this.handleDirectory(path, polledFiles, depth, listedFileItems, fileItem)) {
                return true;
            }
        } else {
            this.handleFile(path, polledFiles, depth, listedFileItems, fileItem);
        }
        return false;
    }

    private boolean handleDirectory(String path, List<GenericFile<ShareFileItem>> polledFiles, int depth, ShareFileItem[] listedFileItems, ShareFileItem dir) {
        String dirName;
        String dirPath;
        boolean canPollMore;
        RemoteFile<ShareFileItem> remote;
        return this.endpoint.isRecursive() && depth < this.endpoint.getMaxDepth() && this.isValidFile((GenericFile)(remote = this.asRemoteFile(path, dir)), true, listedFileItems) && !(canPollMore = this.doSafePollSubDirectory(dirPath = FilesPath.concat(path, dirName = dir.getName()), dirName, polledFiles, depth));
    }

    private void handleFile(String path, List<GenericFile<ShareFileItem>> polledFiles, int depth, ShareFileItem[] listedFileItems, ShareFileItem file) {
        RemoteFile<ShareFileItem> remote;
        if (depth >= this.endpoint.getMinDepth() && this.isValidFile((GenericFile)(remote = this.asRemoteFile(path, file)), false, listedFileItems)) {
            polledFiles.add((GenericFile<ShareFileItem>)remote);
        }
    }

    private ShareFileItem[] listFileItems(String dir) {
        try {
            return (ShareFileItem[])this.operations.listFiles(dir);
        }
        catch (GenericFileOperationFailedException e) {
            if (this.ignoreCannotRetrieveFile(null, null, (Exception)((Object)e))) {
                LOG.debug("Cannot list files in directory {} due directory does not exist or file permission error.", (Object)dir);
                return null;
            }
            throw e;
        }
    }

    protected boolean isMatched(GenericFile<ShareFileItem> file, String doneFileName, ShareFileItem[] files) {
        String onlyName = FileUtil.stripPath((String)doneFileName);
        for (ShareFileItem f : files) {
            if (!f.getName().equals(onlyName)) continue;
            return true;
        }
        LOG.trace("Done file: {} does not exist", (Object)doneFileName);
        return false;
    }

    private RemoteFile<ShareFileItem> asRemoteFile(String path, ShareFileItem file) {
        RemoteFile answer = new RemoteFile();
        answer.setEndpointPath(this.endpointPath);
        answer.setFile((Object)file);
        answer.setFileNameOnly(file.getName());
        if (!file.isDirectory()) {
            answer.setFileLength(file.getFileSize().longValue());
            answer.setLastModified(FilesConsumer.lastModified(file));
        }
        answer.setDirectory(file.isDirectory());
        answer.setHostname(((RemoteFileConfiguration)this.endpoint.getConfiguration()).getHost());
        answer.setAbsolute(FilesPath.isAbsolute(path));
        String pseudoAbsoluteFileName = FilesPath.concat(path, file.getName());
        answer.setAbsoluteFilePath(pseudoAbsoluteFileName);
        String relativePath = StringHelper.after((String)pseudoAbsoluteFileName, (String)this.endpointPath);
        relativePath = FilesPath.ensureRelative(relativePath);
        answer.setRelativeFilePath(relativePath);
        answer.setFileName(relativePath);
        return answer;
    }

    protected void updateFileHeaders(GenericFile<ShareFileItem> file, Message message) {
        message.setHeader("CamelFileLength", (Object)file.getFileLength());
        message.setHeader("CamelFileLastModified", (Object)file.getLastModified());
    }

    public String toString() {
        if (this.toString == null) {
            this.toString = "FilesConsumer[" + URISupport.sanitizeUri((String)this.getEndpoint().getEndpointUri()) + "]";
        }
        return this.toString;
    }

    private static long lastModified(ShareFileItem file) {
        OffsetDateTime raw = file.getProperties().getLastModified();
        if (raw == null) {
            return 0L;
        }
        return raw.toInstant().toEpochMilli();
    }
}

