/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.azure;

import java.net.URISyntaxException;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.camel.component.file.azure.FilesURIStrings;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;

@UriParams
final class FilesToken {
    @UriParam(label="security", description="part of SAS token", secret=true)
    private String sv;
    @UriParam(label="security", description="part of account SAS token", secret=true)
    private String ss;
    @UriParam(label="security", description="part of SAS token", secret=true)
    private String srt;
    @UriParam(label="security", description="part of SAS token", secret=true)
    private String sp;
    @UriParam(label="security", description="part of SAS token", secret=true)
    private String se;
    @UriParam(label="security", description="part of SAS token", secret=true)
    private String st;
    @UriParam(label="security", description="part of SAS token", secret=true)
    private String spr;
    @UriParam(label="security", description="part of SAS token", secret=true)
    private String sig;
    @UriParam(label="security", description="part of service SAS token", secret=true)
    private String si;
    @UriParam(label="security", description="part of service SAS token", secret=true)
    private String sr;
    @UriParam(label="security", description="part of service SAS token", secret=true)
    private String sdd;
    @UriParam(label="security", description="part of SAS token", secret=true)
    private String sip;

    FilesToken() {
    }

    public void setSv(String sv) {
        this.sv = sv;
    }

    public void setSs(String ss) {
        this.ss = ss;
    }

    public void setSrt(String srt) {
        this.srt = srt;
    }

    public void setSp(String sp) {
        this.sp = sp;
    }

    public void setSe(String se) {
        this.se = se;
    }

    public void setSt(String st) {
        this.st = st;
    }

    public void setSpr(String spr) {
        this.spr = spr;
    }

    public void setSig(String sig) {
        this.sig = sig;
    }

    public void setSi(String si) {
        this.si = si;
    }

    public void setSr(String sr) {
        this.sr = sr;
    }

    public void setSdd(String sdd) {
        this.sdd = sdd;
    }

    public void setSip(String sip) {
        this.sip = sip;
    }

    boolean isInvalid() {
        return this.sig == null || this.sv == null || this.se == null || !this.isAccountTokenForFilesService() && !this.isFilesServiceToken();
    }

    private boolean isAccountTokenForFilesService() {
        return this.ss != null && this.ss.contains("f");
    }

    private boolean isFilesServiceToken() {
        return this.sr != null && (this.sr.contains("f") || this.sr.contains("s"));
    }

    public String toURIQuery() {
        try {
            return Stream.of(this.e("sv", this.sv), this.e("ss", this.ss), this.e("srt", this.srt), this.e("sp", this.sp), this.e("se", this.se), this.e("st", this.st), this.e("spr", this.spr), this.e("sig", this.sig), this.e("si", this.si), this.e("sr", this.sr), this.e("sdd", this.sdd), this.e("sip", this.sip)).filter(Objects::nonNull).collect(Collectors.joining("&"));
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    private String e(String param, String value) throws URISyntaxException {
        if (value == null || value.isBlank()) {
            return null;
        }
        return param + "=" + FilesURIStrings.encodeTokenValue(value);
    }

    public int hashCode() {
        return Objects.hash(this.sdd, this.se, this.si, this.sig, this.sip, this.sp, this.spr, this.sr, this.srt, this.ss, this.st, this.sv);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FilesToken other = (FilesToken)obj;
        return Objects.equals(this.sdd, other.sdd) && Objects.equals(this.se, other.se) && Objects.equals(this.si, other.si) && Objects.equals(this.sig, other.sig) && Objects.equals(this.sip, other.sip) && Objects.equals(this.sp, other.sp) && Objects.equals(this.spr, other.spr) && Objects.equals(this.sr, other.sr) && Objects.equals(this.srt, other.srt) && Objects.equals(this.ss, other.ss) && Objects.equals(this.st, other.st) && Objects.equals(this.sv, other.sv);
    }

    String getSv() {
        return this.sv;
    }

    String getSs() {
        return this.ss;
    }

    String getSrt() {
        return this.srt;
    }

    String getSp() {
        return this.sp;
    }

    String getSe() {
        return this.se;
    }

    String getSt() {
        return this.st;
    }

    String getSpr() {
        return this.spr;
    }

    String getSig() {
        return this.sig;
    }

    String getSi() {
        return this.si;
    }

    String getSr() {
        return this.sr;
    }

    String getSdd() {
        return this.sdd;
    }

    String getSip() {
        return this.sip;
    }
}

