/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.stepfunctions;

import java.util.Map;
import org.apache.camel.component.aws2.stepfunctions.StepFunctions2Configuration;
import org.apache.camel.component.aws2.stepfunctions.StepFunctions2Endpoint;
import org.apache.camel.health.HealthCheckResultBuilder;
import org.apache.camel.impl.health.AbstractHealthCheck;
import org.apache.camel.util.ObjectHelper;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sfn.SfnClient;
import software.amazon.awssdk.services.sfn.model.ListStateMachinesRequest;

public class StepFunctions2ProducerHealthCheck
extends AbstractHealthCheck {
    private final StepFunctions2Endpoint stepFunctions2Endpoint;

    public StepFunctions2ProducerHealthCheck(StepFunctions2Endpoint stepFunctions2Endpoint, String clientId) {
        super("camel", "producer:aws2-step-functions-" + clientId);
        this.stepFunctions2Endpoint = stepFunctions2Endpoint;
    }

    protected void doCall(HealthCheckResultBuilder builder, Map<String, Object> options) {
        StepFunctions2Configuration configuration = this.stepFunctions2Endpoint.getConfiguration();
        if (ObjectHelper.isNotEmpty((String)configuration.getRegion()) && !SfnClient.serviceMetadata().regions().contains(Region.of((String)configuration.getRegion()))) {
            builder.message("The service is not supported in this region");
            builder.down();
            return;
        }
        try {
            SfnClient client = this.stepFunctions2Endpoint.getAwsSfnClient();
            client.listStateMachines((ListStateMachinesRequest)ListStateMachinesRequest.builder().maxResults(Integer.valueOf(1)).build());
        }
        catch (AwsServiceException e) {
            builder.message(e.getMessage());
            builder.error((Throwable)e);
            if (ObjectHelper.isNotEmpty((Object)e.statusCode())) {
                builder.detail("service.status.code", (Object)e.statusCode());
            }
            if (ObjectHelper.isNotEmpty((String)e.awsErrorDetails().errorCode())) {
                builder.detail("service.error.code", (Object)e.awsErrorDetails().errorCode());
            }
            builder.down();
            return;
        }
        catch (Exception e) {
            builder.error((Throwable)e);
            builder.down();
            return;
        }
        builder.up();
    }
}

