/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.lambda.client;

import org.apache.camel.component.aws2.lambda.Lambda2Configuration;
import org.apache.camel.component.aws2.lambda.client.Lambda2InternalClient;
import org.apache.camel.component.aws2.lambda.client.impl.Lambda2ClientIAMProfileOptimizedImpl;
import org.apache.camel.component.aws2.lambda.client.impl.Lambda2ClientOptimizedImpl;
import org.apache.camel.component.aws2.lambda.client.impl.Lambda2ClientStandardImpl;

public final class Lambda2ClientFactory {
    private Lambda2ClientFactory() {
    }

    public static Lambda2InternalClient getLambdaClient(Lambda2Configuration configuration) {
        if (Boolean.TRUE.equals(configuration.isUseDefaultCredentialsProvider())) {
            return new Lambda2ClientOptimizedImpl(configuration);
        }
        if (Boolean.TRUE.equals(configuration.isUseProfileCredentialsProvider())) {
            return new Lambda2ClientIAMProfileOptimizedImpl(configuration);
        }
        return new Lambda2ClientStandardImpl(configuration);
    }
}

