/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.lambda;

import java.net.URI;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.aws2.lambda.Lambda2Configuration;
import org.apache.camel.component.aws2.lambda.Lambda2Producer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.util.ObjectHelper;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.http.apache.ProxyConfiguration;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.lambda.LambdaClient;
import software.amazon.awssdk.services.lambda.LambdaClientBuilder;

@UriEndpoint(firstVersion="3.2.0", scheme="aws2-lambda", title="AWS 2 Lambda", syntax="aws2-lambda:function", producerOnly=true, category={Category.CLOUD, Category.COMPUTING, Category.SERVERLESS})
public class Lambda2Endpoint
extends DefaultEndpoint {
    private LambdaClient awsLambdaClient;
    @UriPath
    @Metadata(required=true)
    private String function;
    @UriParam
    private Lambda2Configuration configuration;

    public Lambda2Endpoint(String uri, Component component, Lambda2Configuration configuration) {
        super(uri, component);
        this.configuration = configuration;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("You cannot receive messages from this endpoint");
    }

    public Producer createProducer() throws Exception {
        return new Lambda2Producer((Endpoint)this);
    }

    public String getFunction() {
        return this.function;
    }

    public void setFunction(String function) {
        this.function = function;
    }

    public void doStart() throws Exception {
        super.doStart();
        this.awsLambdaClient = this.configuration.getAwsLambdaClient() != null ? this.configuration.getAwsLambdaClient() : this.createLambdaClient();
    }

    public void doStop() throws Exception {
        if (ObjectHelper.isEmpty((Object)this.configuration.getAwsLambdaClient()) && this.awsLambdaClient != null) {
            this.awsLambdaClient.close();
        }
        super.doStop();
    }

    public Lambda2Configuration getConfiguration() {
        return this.configuration;
    }

    public LambdaClient getAwsLambdaClient() {
        return this.awsLambdaClient;
    }

    LambdaClient createLambdaClient() {
        LambdaClient client = null;
        LambdaClientBuilder clientBuilder = LambdaClient.builder();
        ProxyConfiguration.Builder proxyConfig = null;
        ApacheHttpClient.Builder httpClientBuilder = null;
        boolean isClientConfigFound = false;
        if (ObjectHelper.isNotEmpty((Object)this.configuration.getProxyHost()) && ObjectHelper.isNotEmpty((Object)this.configuration.getProxyPort())) {
            proxyConfig = ProxyConfiguration.builder();
            URI proxyEndpoint = URI.create(this.configuration.getProxyProtocol() + "://" + this.configuration.getProxyHost() + ":" + this.configuration.getProxyPort());
            proxyConfig.endpoint(proxyEndpoint);
            httpClientBuilder = ApacheHttpClient.builder().proxyConfiguration((ProxyConfiguration)proxyConfig.build());
            isClientConfigFound = true;
        }
        if (this.configuration.getAccessKey() != null && this.configuration.getSecretKey() != null) {
            AwsBasicCredentials cred = AwsBasicCredentials.create((String)this.configuration.getAccessKey(), (String)this.configuration.getSecretKey());
            clientBuilder = isClientConfigFound ? (LambdaClientBuilder)((LambdaClientBuilder)clientBuilder.httpClientBuilder(httpClientBuilder)).credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)cred)) : (LambdaClientBuilder)clientBuilder.credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)cred));
        } else if (!isClientConfigFound) {
            clientBuilder = (LambdaClientBuilder)clientBuilder.httpClientBuilder(httpClientBuilder);
        }
        if (ObjectHelper.isNotEmpty((Object)this.configuration.getRegion())) {
            clientBuilder = (LambdaClientBuilder)clientBuilder.region(Region.of((String)this.configuration.getRegion()));
        }
        client = (LambdaClient)clientBuilder.build();
        return client;
    }
}

