/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.kms;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.aws2.kms.KMS2Configuration;
import org.apache.camel.component.aws2.kms.KMS2Endpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;

@org.apache.camel.spi.annotations.Component(value="aws2-kms")
public class KMS2Component
extends DefaultComponent {
    @Metadata
    private KMS2Configuration configuration = new KMS2Configuration();

    public KMS2Component() {
        this(null);
    }

    public KMS2Component(CamelContext context) {
        super(context);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        KMS2Configuration configuration = this.configuration != null ? this.configuration.copy() : new KMS2Configuration();
        KMS2Endpoint endpoint = new KMS2Endpoint(uri, (Component)this, configuration);
        this.setProperties((Endpoint)endpoint, parameters);
        if (Boolean.FALSE.equals(configuration.isUseDefaultCredentialsProvider()) && Boolean.FALSE.equals(configuration.isUseProfileCredentialsProvider()) && Boolean.FALSE.equals(configuration.isUseSessionCredentials()) && configuration.getKmsClient() == null && (configuration.getAccessKey() == null || configuration.getSecretKey() == null)) {
            throw new IllegalArgumentException("useDefaultCredentialsProvider is set to false, useProfileCredentialsProvider is set to false, useSessionCredentials is set to false, Amazon kms client or accessKey and secretKey must be specified");
        }
        return endpoint;
    }

    public KMS2Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(KMS2Configuration configuration) {
        this.configuration = configuration;
    }
}

