/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.eventbridge;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.component.aws2.eventbridge.EventbridgeConfiguration;
import org.apache.camel.component.aws2.eventbridge.EventbridgeEndpoint;
import org.apache.camel.component.aws2.eventbridge.EventbridgeOperations;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.services.eventbridge.EventBridgeClient;
import software.amazon.awssdk.services.eventbridge.model.DeleteRuleRequest;
import software.amazon.awssdk.services.eventbridge.model.DeleteRuleResponse;
import software.amazon.awssdk.services.eventbridge.model.DescribeRuleRequest;
import software.amazon.awssdk.services.eventbridge.model.DescribeRuleResponse;
import software.amazon.awssdk.services.eventbridge.model.DisableRuleRequest;
import software.amazon.awssdk.services.eventbridge.model.DisableRuleResponse;
import software.amazon.awssdk.services.eventbridge.model.EnableRuleRequest;
import software.amazon.awssdk.services.eventbridge.model.EnableRuleResponse;
import software.amazon.awssdk.services.eventbridge.model.ListRuleNamesByTargetRequest;
import software.amazon.awssdk.services.eventbridge.model.ListRuleNamesByTargetResponse;
import software.amazon.awssdk.services.eventbridge.model.ListRulesRequest;
import software.amazon.awssdk.services.eventbridge.model.ListRulesResponse;
import software.amazon.awssdk.services.eventbridge.model.ListTargetsByRuleRequest;
import software.amazon.awssdk.services.eventbridge.model.ListTargetsByRuleResponse;
import software.amazon.awssdk.services.eventbridge.model.PutRuleRequest;
import software.amazon.awssdk.services.eventbridge.model.PutRuleResponse;
import software.amazon.awssdk.services.eventbridge.model.PutTargetsRequest;
import software.amazon.awssdk.services.eventbridge.model.PutTargetsResponse;
import software.amazon.awssdk.services.eventbridge.model.RemoveTargetsRequest;
import software.amazon.awssdk.services.eventbridge.model.RemoveTargetsResponse;

public class EventbridgeProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(EventbridgeProducer.class);
    private transient String eventbridgeProducerToString;

    public EventbridgeProducer(Endpoint endpoint) {
        super(endpoint);
    }

    public void process(Exchange exchange) throws Exception {
        switch (this.determineOperation(exchange)) {
            case putRule: {
                this.putRule(this.getEndpoint().getEventbridgeClient(), exchange);
                break;
            }
            case putTargets: {
                this.putTargets(this.getEndpoint().getEventbridgeClient(), exchange);
                break;
            }
            case removeTargets: {
                this.removeTargets(this.getEndpoint().getEventbridgeClient(), exchange);
                break;
            }
            case deleteRule: {
                this.deleteRule(this.getEndpoint().getEventbridgeClient(), exchange);
                break;
            }
            case enableRule: {
                this.enableRule(this.getEndpoint().getEventbridgeClient(), exchange);
                break;
            }
            case disableRule: {
                this.disableRule(this.getEndpoint().getEventbridgeClient(), exchange);
                break;
            }
            case listRules: {
                this.listRules(this.getEndpoint().getEventbridgeClient(), exchange);
                break;
            }
            case describeRule: {
                this.describeRule(this.getEndpoint().getEventbridgeClient(), exchange);
                break;
            }
            case listTargetsByRule: {
                this.listTargetsByRule(this.getEndpoint().getEventbridgeClient(), exchange);
                break;
            }
            case listRuleNamesByTarget: {
                this.listRuleNamesByTarget(this.getEndpoint().getEventbridgeClient(), exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation");
            }
        }
    }

    private EventbridgeOperations determineOperation(Exchange exchange) {
        EventbridgeOperations operation = (EventbridgeOperations)((Object)exchange.getIn().getHeader("CamelAwsEventbridgeOperation", EventbridgeOperations.class));
        if (operation == null) {
            operation = this.getConfiguration().getOperation();
        }
        return operation;
    }

    protected EventbridgeConfiguration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    public String toString() {
        if (this.eventbridgeProducerToString == null) {
            this.eventbridgeProducerToString = "EventbridgeProducer[" + URISupport.sanitizeUri((String)this.getEndpoint().getEndpointUri()) + "]";
        }
        return this.eventbridgeProducerToString;
    }

    private void putRule(EventBridgeClient eventbridgeClient, Exchange exchange) throws InvalidPayloadException, IOException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof PutRuleRequest) {
                PutRuleResponse result;
                try {
                    result = eventbridgeClient.putRule((PutRuleRequest)payload);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("PutRule command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = EventbridgeProducer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            PutRuleResponse result;
            PutRuleRequest.Builder builder = PutRuleRequest.builder();
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsEventbridgeRuleName"))) {
                String ruleName = (String)exchange.getIn().getHeader("CamelAwsEventbridgeRuleName", String.class);
                builder.name(ruleName);
            }
            if (ObjectHelper.isEmpty((Object)exchange.getIn().getHeader("CamelAwsEventbridgeEventPattern"))) {
                try (InputStream s = ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)this.getEndpoint().getCamelContext(), (String)this.getConfiguration().getEventPatternFile());){
                    String eventPattern = IOUtils.toString((InputStream)s, (Charset)Charset.defaultCharset());
                    builder.eventPattern(eventPattern);
                }
            } else {
                String eventPattern = (String)exchange.getIn().getHeader("CamelAwsEventbridgeEventPattern", String.class);
                builder.eventPattern(eventPattern);
            }
            builder.eventBusName(this.getConfiguration().getEventbusName());
            try {
                result = eventbridgeClient.putRule((PutRuleRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("Put Rule command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = EventbridgeProducer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void putTargets(EventBridgeClient eventbridgeClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof PutTargetsRequest) {
                PutTargetsResponse result;
                try {
                    result = eventbridgeClient.putTargets((PutTargetsRequest)payload);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("PutTargets command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = EventbridgeProducer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            PutTargetsResponse result;
            PutTargetsRequest.Builder builder = PutTargetsRequest.builder();
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsEventbridgeRuleName"))) {
                String ruleName = (String)exchange.getIn().getHeader("CamelAwsEventbridgeRuleName", String.class);
                builder.rule(ruleName);
            }
            if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsEventbridgeTargets"))) {
                throw new IllegalArgumentException("At least one targets must be specified");
            }
            Collection targets = (Collection)exchange.getIn().getHeader("CamelAwsEventbridgeTargets", Collection.class);
            builder.targets(targets);
            builder.eventBusName(this.getConfiguration().getEventbusName());
            try {
                result = eventbridgeClient.putTargets((PutTargetsRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("Put Targets command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = EventbridgeProducer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void removeTargets(EventBridgeClient eventbridgeClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof RemoveTargetsRequest) {
                RemoveTargetsResponse result;
                try {
                    result = eventbridgeClient.removeTargets((RemoveTargetsRequest)payload);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("RemoveTargets command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = EventbridgeProducer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            RemoveTargetsResponse result;
            RemoveTargetsRequest.Builder builder = RemoveTargetsRequest.builder();
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsEventbridgeRuleName"))) {
                String ruleName = (String)exchange.getIn().getHeader("CamelAwsEventbridgeRuleName", String.class);
                builder.rule(ruleName);
            }
            if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsEventbridgeTargetsIds"))) {
                throw new IllegalArgumentException("At least one targets must be specified");
            }
            Collection ids = (Collection)exchange.getIn().getHeader("CamelAwsEventbridgeTargetsIds", Collection.class);
            builder.ids(ids);
            builder.eventBusName(this.getConfiguration().getEventbusName());
            try {
                result = eventbridgeClient.removeTargets((RemoveTargetsRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("Remove Targets command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = EventbridgeProducer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void deleteRule(EventBridgeClient eventbridgeClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof DeleteRuleRequest) {
                DeleteRuleResponse result;
                try {
                    result = eventbridgeClient.deleteRule((DeleteRuleRequest)payload);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Delete Rule command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = EventbridgeProducer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            DeleteRuleResponse result;
            DeleteRuleRequest.Builder builder = DeleteRuleRequest.builder();
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsEventbridgeRuleName"))) {
                String ruleName = (String)exchange.getIn().getHeader("CamelAwsEventbridgeRuleName", String.class);
                builder.name(ruleName);
            }
            builder.eventBusName(this.getConfiguration().getEventbusName());
            try {
                result = eventbridgeClient.deleteRule((DeleteRuleRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("Delete Rule command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = EventbridgeProducer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void enableRule(EventBridgeClient eventbridgeClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof EnableRuleRequest) {
                EnableRuleResponse result;
                try {
                    result = eventbridgeClient.enableRule((EnableRuleRequest)payload);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Enable Rule command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = EventbridgeProducer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            EnableRuleResponse result;
            EnableRuleRequest.Builder builder = EnableRuleRequest.builder();
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsEventbridgeRuleName"))) {
                String ruleName = (String)exchange.getIn().getHeader("CamelAwsEventbridgeRuleName", String.class);
                builder.name(ruleName);
            }
            builder.eventBusName(this.getConfiguration().getEventbusName());
            try {
                result = eventbridgeClient.enableRule((EnableRuleRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("Enable Rule command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = EventbridgeProducer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void disableRule(EventBridgeClient eventbridgeClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof DisableRuleRequest) {
                DisableRuleResponse result;
                try {
                    result = eventbridgeClient.disableRule((DisableRuleRequest)payload);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Disable Rule command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = EventbridgeProducer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            DisableRuleResponse result;
            DisableRuleRequest.Builder builder = DisableRuleRequest.builder();
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsEventbridgeRuleName"))) {
                String ruleName = (String)exchange.getIn().getHeader("CamelAwsEventbridgeRuleName", String.class);
                builder.name(ruleName);
            }
            builder.eventBusName(this.getConfiguration().getEventbusName());
            try {
                result = eventbridgeClient.disableRule((DisableRuleRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("Disable Rule command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = EventbridgeProducer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void listRules(EventBridgeClient eventbridgeClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof ListRulesRequest) {
                ListRulesResponse result;
                try {
                    result = eventbridgeClient.listRules((ListRulesRequest)payload);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("List Rules command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = EventbridgeProducer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            ListRulesResponse result;
            ListRulesRequest.Builder builder = ListRulesRequest.builder();
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsEventbridgeRuleNamePrefix"))) {
                String ruleNamePrefix = (String)exchange.getIn().getHeader("CamelAwsEventbridgeRuleNamePrefix", String.class);
                builder.namePrefix(ruleNamePrefix);
            }
            builder.eventBusName(this.getConfiguration().getEventbusName());
            try {
                result = eventbridgeClient.listRules((ListRulesRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("Disable Rule command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = EventbridgeProducer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void describeRule(EventBridgeClient eventbridgeClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof DescribeRuleRequest) {
                DescribeRuleResponse result;
                try {
                    result = eventbridgeClient.describeRule((DescribeRuleRequest)payload);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Describe Rule command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = EventbridgeProducer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            DescribeRuleResponse result;
            DescribeRuleRequest.Builder builder = DescribeRuleRequest.builder();
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsEventbridgeRuleName"))) {
                String ruleName = (String)exchange.getIn().getHeader("CamelAwsEventbridgeRuleName", String.class);
                builder.name(ruleName);
            }
            builder.eventBusName(this.getConfiguration().getEventbusName());
            try {
                result = eventbridgeClient.describeRule((DescribeRuleRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("Describe Rule command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = EventbridgeProducer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void listTargetsByRule(EventBridgeClient eventbridgeClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof ListTargetsByRuleRequest) {
                ListTargetsByRuleResponse result;
                try {
                    result = eventbridgeClient.listTargetsByRule((ListTargetsByRuleRequest)payload);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("List Targets by Rule command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = EventbridgeProducer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            ListTargetsByRuleResponse result;
            ListTargetsByRuleRequest.Builder builder = ListTargetsByRuleRequest.builder();
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsEventbridgeRuleName"))) {
                String ruleName = (String)exchange.getIn().getHeader("CamelAwsEventbridgeRuleName", String.class);
                builder.rule(ruleName);
            }
            builder.eventBusName(this.getConfiguration().getEventbusName());
            try {
                result = eventbridgeClient.listTargetsByRule((ListTargetsByRuleRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("List Targets by Rule command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = EventbridgeProducer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void listRuleNamesByTarget(EventBridgeClient eventbridgeClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof ListRuleNamesByTargetRequest) {
                ListRuleNamesByTargetResponse result;
                try {
                    result = eventbridgeClient.listRuleNamesByTarget((ListRuleNamesByTargetRequest)payload);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("List Rule Name by Targets command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = EventbridgeProducer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            ListRuleNamesByTargetResponse result;
            ListRuleNamesByTargetRequest.Builder builder = ListRuleNamesByTargetRequest.builder();
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsEventbridgeTargetArn"))) {
                String targetArn = (String)exchange.getIn().getHeader("CamelAwsEventbridgeTargetArn", String.class);
                builder.targetArn(targetArn);
            }
            builder.eventBusName(this.getConfiguration().getEventbusName());
            try {
                result = eventbridgeClient.listRuleNamesByTarget((ListRuleNamesByTargetRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("List Rule by Target command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = EventbridgeProducer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    public EventbridgeEndpoint getEndpoint() {
        return (EventbridgeEndpoint)super.getEndpoint();
    }

    public static Message getMessageForResponse(Exchange exchange) {
        return exchange.getMessage();
    }
}

