/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.ecs;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.aws2.ecs.ECS2Configuration;
import org.apache.camel.component.aws2.ecs.ECS2Endpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.HealthCheckComponent;

@org.apache.camel.spi.annotations.Component(value="aws2-ecs")
public class ECS2Component
extends HealthCheckComponent {
    @Metadata
    private ECS2Configuration configuration = new ECS2Configuration();

    public ECS2Component() {
        this(null);
    }

    public ECS2Component(CamelContext context) {
        super(context);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        ECS2Configuration configuration = this.configuration != null ? this.configuration.copy() : new ECS2Configuration();
        ECS2Endpoint endpoint = new ECS2Endpoint(uri, (Component)this, configuration);
        this.setProperties((Endpoint)endpoint, parameters);
        if (Boolean.FALSE.equals(configuration.isUseDefaultCredentialsProvider()) && Boolean.FALSE.equals(configuration.isUseProfileCredentialsProvider()) && Boolean.FALSE.equals(configuration.isUseSessionCredentials()) && configuration.getEcsClient() == null && (configuration.getAccessKey() == null || configuration.getSecretKey() == null)) {
            throw new IllegalArgumentException("useDefaultCredentialsProvider is set to false, useProfileCredentialsProvider is set to false, useSessionCredentials is set to false, Amazon ecs client or accessKey and secretKey must be specified");
        }
        return endpoint;
    }

    public ECS2Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(ECS2Configuration configuration) {
        this.configuration = configuration;
    }
}

