/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.xray;

import com.amazonaws.xray.AWSXRay;
import com.amazonaws.xray.entities.Subsegment;
import java.lang.invoke.MethodHandles;
import org.apache.camel.CamelContext;
import org.apache.camel.NamedNode;
import org.apache.camel.Processor;
import org.apache.camel.component.aws.xray.XRayTracer;
import org.apache.camel.spi.InterceptStrategy;
import org.apache.camel.support.processor.DelegateAsyncProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EIPTracingStrategy
implements InterceptStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public Processor wrapProcessorInInterceptors(CamelContext camelContext, NamedNode processorDefinition, Processor target, Processor nextTarget) throws Exception {
        String defName = processorDefinition.getShortName();
        return new DelegateAsyncProcessor(exchange -> {
            LOG.trace("Creating new subsegment for {} - EIP {}", (Object)defName, (Object)target);
            Subsegment subsegment = AWSXRay.beginSubsegment((String)XRayTracer.sanitizeName(defName));
            try {
                LOG.trace("Processing EIP {}", (Object)target);
                target.process(exchange);
            }
            catch (Exception ex) {
                LOG.trace("Handling exception thrown by invoked EIP {}", (Object)target);
                subsegment.addException((Throwable)ex);
                throw ex;
            }
            finally {
                LOG.trace("Closing down subsegment for {}", (Object)defName);
                subsegment.close();
            }
        });
    }
}

