/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.swf;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.simpleworkflow.AmazonSimpleWorkflow;
import com.amazonaws.services.simpleworkflow.AmazonSimpleWorkflowClient;
import com.amazonaws.services.simpleworkflow.AmazonSimpleWorkflowClientBuilder;
import com.amazonaws.services.simpleworkflow.flow.StartWorkflowOptions;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.aws.swf.CamelSWFActivityClient;
import org.apache.camel.component.aws.swf.CamelSWFWorkflowClient;
import org.apache.camel.component.aws.swf.SWFActivityConsumer;
import org.apache.camel.component.aws.swf.SWFActivityProducer;
import org.apache.camel.component.aws.swf.SWFComponent;
import org.apache.camel.component.aws.swf.SWFConfiguration;
import org.apache.camel.component.aws.swf.SWFWorkflowConsumer;
import org.apache.camel.component.aws.swf.SWFWorkflowProducer;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.support.EndpointHelper;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;

@UriEndpoint(firstVersion="2.13.0", scheme="aws-swf", title="AWS Simple Workflow", syntax="aws-swf:type", label="cloud,workflow")
public class SWFEndpoint
extends DefaultEndpoint {
    private AmazonSimpleWorkflowClient amazonSWClient;
    @UriParam
    private SWFConfiguration configuration;

    public SWFEndpoint() {
    }

    public SWFEndpoint(String uri, SWFComponent component, SWFConfiguration configuration) {
        super(uri, (Component)component);
        this.configuration = configuration;
    }

    public Producer createProducer() throws Exception {
        return this.isWorkflow() ? new SWFWorkflowProducer(this, new CamelSWFWorkflowClient(this, this.configuration)) : new SWFActivityProducer(this, new CamelSWFActivityClient(this.configuration));
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        DefaultConsumer consumer = this.isWorkflow() ? new SWFWorkflowConsumer(this, processor, this.configuration) : new SWFActivityConsumer(this, processor, this.configuration);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    protected void doStart() throws Exception {
        if (this.configuration.getAmazonSWClient() == null) {
            this.amazonSWClient = (AmazonSimpleWorkflowClient)this.createSWClient();
        }
        super.doStart();
    }

    protected void doStop() throws Exception {
        if (ObjectHelper.isEmpty((Object)this.configuration.getAmazonSWClient()) && this.amazonSWClient != null) {
            this.amazonSWClient.shutdown();
            this.amazonSWClient = null;
        }
        super.doStop();
    }

    public AmazonSimpleWorkflow getSWClient() {
        return this.configuration.getAmazonSWClient() != null ? this.configuration.getAmazonSWClient() : this.amazonSWClient;
    }

    private AmazonSimpleWorkflow createSWClient() throws Exception {
        BasicAWSCredentials credentials = new BasicAWSCredentials(this.configuration.getAccessKey(), this.configuration.getSecretKey());
        AWSStaticCredentialsProvider credentialsProvider = new AWSStaticCredentialsProvider((AWSCredentials)credentials);
        ClientConfiguration clientConfiguration = new ClientConfiguration();
        if (!this.configuration.getClientConfigurationParameters().isEmpty()) {
            this.setProperties(clientConfiguration, this.configuration.getClientConfigurationParameters());
        }
        AmazonSimpleWorkflowClientBuilder builder = (AmazonSimpleWorkflowClientBuilder)((AmazonSimpleWorkflowClientBuilder)AmazonSimpleWorkflowClientBuilder.standard().withClientConfiguration(clientConfiguration)).withCredentials((AWSCredentialsProvider)credentialsProvider);
        if (ObjectHelper.isNotEmpty((Object)this.configuration.getRegion())) {
            builder = (AmazonSimpleWorkflowClientBuilder)builder.withRegion(Regions.valueOf((String)this.configuration.getRegion()));
        }
        AmazonSimpleWorkflow client = (AmazonSimpleWorkflow)builder.build();
        if (!this.configuration.getSWClientParameters().isEmpty()) {
            this.setProperties(client, this.configuration.getSWClientParameters());
        }
        return client;
    }

    public StartWorkflowOptions getStartWorkflowOptions() {
        StartWorkflowOptions startWorkflowOptions = new StartWorkflowOptions();
        try {
            EndpointHelper.setReferenceProperties((CamelContext)this.getCamelContext(), (Object)startWorkflowOptions, this.configuration.getStartWorkflowOptionsParameters());
            EndpointHelper.setProperties((CamelContext)this.getCamelContext(), (Object)startWorkflowOptions, this.configuration.getStartWorkflowOptionsParameters());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return startWorkflowOptions;
    }

    private boolean isWorkflow() {
        return this.configuration.getType().equalsIgnoreCase("workflow");
    }

    public Exchange createExchange(Object request, String action) {
        Exchange exchange = this.createExchange(ExchangePattern.InOut);
        exchange.getIn().setBody(request);
        exchange.getIn().setHeader("CamelSWFAction", (Object)action);
        return exchange;
    }

    public Object getResult(Exchange exchange) {
        return ExchangeHelper.isOutCapable((Exchange)exchange) ? exchange.getOut().getBody() : exchange.getIn().getBody();
    }

    public void setResult(Exchange exchange, Object result) {
        if (ExchangeHelper.isOutCapable((Exchange)exchange)) {
            exchange.getOut().setBody(result);
        } else {
            exchange.getIn().setBody(result);
        }
    }

    public void setConfiguration(SWFConfiguration configuration) {
        this.configuration = configuration;
    }

    public SWFConfiguration getConfiguration() {
        return this.configuration;
    }
}

