/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.swf;

import com.amazonaws.services.simpleworkflow.AmazonSimpleWorkflow;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.aws.swf.SWFConfiguration;
import org.apache.camel.component.aws.swf.SWFEndpoint;
import org.apache.camel.component.aws.swf.SwfComponentVerifierExtension;
import org.apache.camel.component.extension.ComponentExtension;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.support.IntrospectionSupport;
import org.apache.camel.util.ObjectHelper;

@Component(value="aws-swf")
public class SWFComponent
extends DefaultComponent {
    @Metadata
    private String accessKey;
    @Metadata
    private String secretKey;
    @Metadata
    private String region;
    @Metadata(label="advanced")
    private SWFConfiguration configuration = new SWFConfiguration();

    public SWFComponent() {
        this(null);
    }

    public SWFComponent(CamelContext context) {
        super(context);
        this.registerExtension((ComponentExtension)new SwfComponentVerifierExtension());
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        Map clientConfigurationParameters = IntrospectionSupport.extractProperties(parameters, (String)"clientConfiguration.");
        Map sWClientParameters = IntrospectionSupport.extractProperties(parameters, (String)"sWClient.");
        Map startWorkflowOptionsParameters = IntrospectionSupport.extractProperties(parameters, (String)"startWorkflowOptions.");
        SWFConfiguration configuration = this.configuration.copy();
        configuration.setType(remaining);
        this.setProperties(configuration, parameters);
        configuration.setClientConfigurationParameters(clientConfigurationParameters);
        configuration.setSWClientParameters(sWClientParameters);
        configuration.setStartWorkflowOptionsParameters(startWorkflowOptionsParameters);
        if (ObjectHelper.isEmpty((Object)configuration.getAccessKey())) {
            this.setAccessKey(this.accessKey);
        }
        if (ObjectHelper.isEmpty((Object)configuration.getSecretKey())) {
            this.setSecretKey(this.secretKey);
        }
        if (ObjectHelper.isEmpty((Object)configuration.getRegion())) {
            this.setRegion(this.region);
        }
        this.checkAndSetRegistryClient(configuration);
        if (configuration.getAmazonSWClient() == null && (configuration.getAccessKey() == null || configuration.getSecretKey() == null)) {
            throw new IllegalArgumentException("AmazonSWClient or accessKey and secretKey must be specified.");
        }
        return new SWFEndpoint(uri, this, configuration);
    }

    public SWFConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(SWFConfiguration configuration) {
        this.configuration = configuration;
    }

    public String getAccessKey() {
        return this.configuration.getAccessKey();
    }

    public void setAccessKey(String accessKey) {
        this.configuration.setAccessKey(accessKey);
    }

    public String getSecretKey() {
        return this.configuration.getSecretKey();
    }

    public void setSecretKey(String secretKey) {
        this.configuration.setSecretKey(secretKey);
    }

    public String getRegion() {
        return this.configuration.getRegion();
    }

    public void setRegion(String region) {
        this.configuration.setRegion(region);
    }

    private void checkAndSetRegistryClient(SWFConfiguration configuration) {
        Set clients = this.getCamelContext().getRegistry().findByType(AmazonSimpleWorkflow.class);
        if (clients.size() == 1) {
            configuration.setAmazonSWClient((AmazonSimpleWorkflow)clients.stream().findFirst().get());
        }
    }
}

