/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.bedrock.runtime.stream;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.camel.component.aws2.bedrock.runtime.stream.StreamResponseParser;

public class MistralStreamParser
implements StreamResponseParser {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    @Override
    public String extractText(String chunk) throws JsonProcessingException {
        if (chunk == null || chunk.trim().isEmpty()) {
            return "";
        }
        JsonNode node = MAPPER.readTree(chunk);
        JsonNode outputs = node.get("outputs");
        if (outputs != null && outputs.isArray() && outputs.size() > 0) {
            JsonNode firstOutput = outputs.get(0);
            JsonNode text = firstOutput.get("text");
            return text != null && !text.isNull() ? text.asText() : "";
        }
        return "";
    }

    @Override
    public String extractCompletionReason(String chunk) throws JsonProcessingException {
        if (chunk == null || chunk.trim().isEmpty()) {
            return null;
        }
        JsonNode node = MAPPER.readTree(chunk);
        JsonNode outputs = node.get("outputs");
        if (outputs != null && outputs.isArray() && outputs.size() > 0) {
            JsonNode firstOutput = outputs.get(0);
            JsonNode stopReason = firstOutput.get("stop_reason");
            return stopReason != null && !stopReason.isNull() ? stopReason.asText() : null;
        }
        return null;
    }

    @Override
    public Integer extractTokenCount(String chunk) throws JsonProcessingException {
        return null;
    }

    @Override
    public boolean isFinalChunk(String chunk) throws JsonProcessingException {
        String stopReason = this.extractCompletionReason(chunk);
        return stopReason != null && !stopReason.isEmpty();
    }
}

