/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.bedrock.runtime.stream;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.camel.component.aws2.bedrock.runtime.stream.StreamResponseParser;

public class LlamaStreamParser
implements StreamResponseParser {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    @Override
    public String extractText(String chunk) throws JsonProcessingException {
        if (chunk == null || chunk.trim().isEmpty()) {
            return "";
        }
        JsonNode node = MAPPER.readTree(chunk);
        JsonNode generation = node.get("generation");
        return generation != null && !generation.isNull() ? generation.asText() : "";
    }

    @Override
    public String extractCompletionReason(String chunk) throws JsonProcessingException {
        if (chunk == null || chunk.trim().isEmpty()) {
            return null;
        }
        JsonNode node = MAPPER.readTree(chunk);
        JsonNode stopReason = node.get("stop_reason");
        return stopReason != null && !stopReason.isNull() ? stopReason.asText() : null;
    }

    @Override
    public Integer extractTokenCount(String chunk) throws JsonProcessingException {
        if (chunk == null || chunk.trim().isEmpty()) {
            return null;
        }
        JsonNode node = MAPPER.readTree(chunk);
        JsonNode tokenCount = node.get("generation_token_count");
        return tokenCount != null && !tokenCount.isNull() ? Integer.valueOf(tokenCount.asInt()) : null;
    }

    @Override
    public boolean isFinalChunk(String chunk) throws JsonProcessingException {
        String stopReason = this.extractCompletionReason(chunk);
        return stopReason != null && !stopReason.isEmpty();
    }
}

