/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.bedrock.runtime.stream;

import java.util.List;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.bedrockruntime.model.ConverseStreamResponseHandler;
import software.amazon.awssdk.services.bedrockruntime.model.TokenUsage;

public final class ConverseStreamHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ConverseStreamHandler.class);

    private ConverseStreamHandler() {
    }

    public static ConverseStreamResponseHandler createCompleteHandler(StreamMetadata metadata, StringBuilder fullText) {
        int[] chunkCount = new int[]{0};
        return ((ConverseStreamResponseHandler.Builder)ConverseStreamResponseHandler.builder().subscriber(ConverseStreamResponseHandler.Visitor.builder().onContentBlockDelta(delta -> {
            if (delta.delta() != null && delta.delta().text() != null) {
                fullText.append(delta.delta().text());
            }
            chunkCount[0] = chunkCount[0] + 1;
        }).onMetadata(metadataEvent -> {
            if (metadataEvent.usage() != null) {
                metadata.setUsage(metadataEvent.usage());
            }
        }).onMessageStop(stop -> {
            if (stop.stopReason() != null) {
                metadata.setStopReason(stop.stopReason().toString());
            }
        }).build()).onComplete(() -> {
            metadata.setChunkCount(chunkCount[0]);
            metadata.setFullText(fullText.toString());
        })).build();
    }

    public static ConverseStreamResponseHandler createChunksHandler(StreamMetadata metadata, List<String> chunks, Consumer<String> chunkConsumer) {
        int[] chunkCount = new int[]{0};
        return ((ConverseStreamResponseHandler.Builder)ConverseStreamResponseHandler.builder().subscriber(ConverseStreamResponseHandler.Visitor.builder().onContentBlockDelta(delta -> {
            if (delta.delta() != null && delta.delta().text() != null) {
                String text = delta.delta().text();
                chunks.add(text);
                if (chunkConsumer != null) {
                    chunkConsumer.accept(text);
                }
            }
            chunkCount[0] = chunkCount[0] + 1;
        }).onMetadata(metadataEvent -> {
            if (metadataEvent.usage() != null) {
                metadata.setUsage(metadataEvent.usage());
            }
        }).onMessageStop(stop -> {
            if (stop.stopReason() != null) {
                metadata.setStopReason(stop.stopReason().toString());
            }
        }).build()).onComplete(() -> {
            metadata.setChunkCount(chunkCount[0]);
            metadata.setChunks(chunks);
        })).build();
    }

    public static class StreamMetadata {
        private String fullText;
        private List<String> chunks;
        private String stopReason;
        private TokenUsage usage;
        private int chunkCount;

        public String getFullText() {
            return this.fullText;
        }

        public void setFullText(String fullText) {
            this.fullText = fullText;
        }

        public List<String> getChunks() {
            return this.chunks;
        }

        public void setChunks(List<String> chunks) {
            this.chunks = chunks;
        }

        public String getStopReason() {
            return this.stopReason;
        }

        public void setStopReason(String stopReason) {
            this.stopReason = stopReason;
        }

        public TokenUsage getUsage() {
            return this.usage;
        }

        public void setUsage(TokenUsage usage) {
            this.usage = usage;
        }

        public int getChunkCount() {
            return this.chunkCount;
        }

        public void setChunkCount(int chunkCount) {
            this.chunkCount = chunkCount;
        }
    }
}

