/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.bedrock.runtime.stream;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.camel.component.aws2.bedrock.runtime.stream.StreamResponseParser;

public class CohereStreamParser
implements StreamResponseParser {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    @Override
    public String extractText(String chunk) throws JsonProcessingException {
        if (chunk == null || chunk.trim().isEmpty()) {
            return "";
        }
        JsonNode node = MAPPER.readTree(chunk);
        JsonNode eventType = node.get("event_type");
        if (eventType != null && "text-generation".equals(eventType.asText())) {
            JsonNode text = node.get("text");
            return text != null && !text.isNull() ? text.asText() : "";
        }
        return "";
    }

    @Override
    public String extractCompletionReason(String chunk) throws JsonProcessingException {
        if (chunk == null || chunk.trim().isEmpty()) {
            return null;
        }
        JsonNode node = MAPPER.readTree(chunk);
        JsonNode finishReason = node.get("finish_reason");
        return finishReason != null && !finishReason.isNull() ? finishReason.asText() : null;
    }

    @Override
    public Integer extractTokenCount(String chunk) throws JsonProcessingException {
        JsonNode tokens;
        JsonNode meta;
        if (chunk == null || chunk.trim().isEmpty()) {
            return null;
        }
        JsonNode node = MAPPER.readTree(chunk);
        JsonNode response = node.get("response");
        if (response != null && (meta = response.get("meta")) != null && (tokens = meta.get("tokens")) != null) {
            JsonNode outputTokens = tokens.get("output_tokens");
            return outputTokens != null && !outputTokens.isNull() ? Integer.valueOf(outputTokens.asInt()) : null;
        }
        return null;
    }

    @Override
    public boolean isFinalChunk(String chunk) throws JsonProcessingException {
        if (chunk == null || chunk.trim().isEmpty()) {
            return false;
        }
        JsonNode node = MAPPER.readTree(chunk);
        JsonNode isFinished = node.get("is_finished");
        return isFinished != null && isFinished.asBoolean(false);
    }
}

