/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.asn1;

import com.beanit.asn1bean.ber.ReverseByteArrayOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.camel.Exchange;
import org.apache.camel.dataformat.asn1.ASN1GenericIterator;
import org.apache.camel.dataformat.asn1.ASN1MessageIterator;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatName;
import org.apache.camel.spi.annotations.Dataformat;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Primitive;

@Dataformat(value="asn1")
public class ASN1DataFormat
extends ServiceSupport
implements DataFormat,
DataFormatName {
    private boolean usingIterator;
    private Class<?> unmarshalType;

    public ASN1DataFormat() {
        this.usingIterator = false;
    }

    public ASN1DataFormat(Class<?> unmarshalType) {
        this.usingIterator = true;
        this.unmarshalType = unmarshalType;
    }

    public String getDataFormatName() {
        return "asn1";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void marshal(Exchange exchange, Object graph, OutputStream stream) throws Exception {
        ByteArrayInputStream berOut = null;
        if (this.usingIterator) {
            if (this.unmarshalType != null) {
                this.encodeGenericTypeObject(exchange, stream);
                return;
            }
            Object body = exchange.getIn().getBody();
            if (body instanceof ASN1Primitive) {
                ASN1Primitive asn1Primitive = (ASN1Primitive)ObjectHelper.cast(ASN1Primitive.class, (Object)body);
                berOut = new ByteArrayInputStream(asn1Primitive.getEncoded());
            } else if (body instanceof byte[]) {
                berOut = new ByteArrayInputStream((byte[])ObjectHelper.cast(byte[].class, (Object)body));
            }
        } else {
            byte[] byteInput = (byte[])exchange.getContext().getTypeConverter().mandatoryConvertTo(byte[].class, exchange, graph);
            berOut = new ByteArrayInputStream(byteInput);
        }
        try {
            IOHelper.copy((InputStream)berOut, (OutputStream)stream);
        }
        catch (Throwable throwable) {
            IOHelper.close((Closeable[])new Closeable[]{berOut, stream});
            throw throwable;
        }
        IOHelper.close((Closeable[])new Closeable[]{berOut, stream});
    }

    private void encodeGenericTypeObject(Exchange exchange, OutputStream stream) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, IOException {
        Class[] paramOut = new Class[]{OutputStream.class};
        try (ReverseByteArrayOutputStream berOut = new ReverseByteArrayOutputStream(16, true);){
            Method encodeMethod = exchange.getIn().getBody().getClass().getDeclaredMethod("encode", paramOut);
            encodeMethod.invoke(exchange.getIn().getBody(), berOut);
            stream.write(berOut.getArray());
        }
    }

    public Object unmarshal(Exchange exchange, InputStream stream) throws Exception {
        byte[] asn1Bytes;
        if (this.usingIterator) {
            if (this.unmarshalType != null) {
                return new ASN1GenericIterator(this.unmarshalType, stream);
            }
            return new ASN1MessageIterator(exchange, stream);
        }
        ASN1Primitive asn1Record = null;
        try (ASN1InputStream ais = new ASN1InputStream(stream);
             ByteArrayOutputStream asn1Out = new ByteArrayOutputStream();){
            while (ais.available() > 0) {
                asn1Record = ais.readObject();
                asn1Out.write(asn1Record.getEncoded());
            }
            asn1Bytes = asn1Out.toByteArray();
        }
        return asn1Bytes;
    }

    public boolean isUsingIterator() {
        return this.usingIterator;
    }

    public void setUsingIterator(boolean usingIterator) {
        this.usingIterator = usingIterator;
    }

    public Class<?> getUnmarshalType() {
        return this.unmarshalType;
    }

    public void setUnmarshalType(Class<?> unmarshalType) {
        this.unmarshalType = unmarshalType;
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
    }
}

