/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.as2.api.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.camel.CamelException;
import org.apache.camel.component.as2.api.entity.ApplicationEDIConsentEntity;
import org.apache.camel.component.as2.api.entity.ApplicationEDIFACTEntity;
import org.apache.camel.component.as2.api.entity.ApplicationEDIX12Entity;
import org.apache.camel.component.as2.api.entity.ApplicationEntity;
import org.apache.camel.component.as2.api.entity.ApplicationXMLEntity;
import org.apache.camel.component.as2.api.entity.MimeEntity;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64InputStream;
import org.apache.commons.codec.binary.Base64OutputStream;
import org.apache.commons.codec.net.QuotedPrintableCodec;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpMessage;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EntityUtils {
    private static final Logger LOG = LoggerFactory.getLogger(EntityUtils.class);
    private static final AtomicLong partNumber = new AtomicLong();

    private EntityUtils() {
    }

    public static String createBoundaryValue() {
        StringBuilder s = new StringBuilder();
        s.append("----=_Part_").append(partNumber.incrementAndGet()).append("_").append(s.hashCode()).append(".").append(System.currentTimeMillis());
        return s.toString();
    }

    public static String appendParameter(String headerString, String parameterName, String parameterValue) {
        return headerString + "; " + parameterName + "=" + parameterValue;
    }

    public static String encode(String data, Charset charset, String encoding) throws CamelException {
        byte[] encoded = EntityUtils.encode(data.getBytes(charset), encoding);
        return new String(encoded, charset);
    }

    public static byte[] encode(byte[] data, String encoding) throws CamelException {
        ObjectHelper.notNull((Object)data, (String)"Data");
        if (encoding == null) {
            return data;
        }
        switch (encoding.toLowerCase()) {
            case "base64": {
                return Base64.encode((byte[])data);
            }
            case "quoted-printable": {
                return QuotedPrintableCodec.encodeQuotedPrintable(null, (byte[])data);
            }
            case "binary": 
            case "7bit": 
            case "8bit": {
                return data;
            }
        }
        throw new CamelException("Unknown encoding: " + encoding);
    }

    public static OutputStream encode(OutputStream os, String encoding) throws CamelException {
        ObjectHelper.notNull((Object)os, (String)"Output Stream");
        if (encoding == null) {
            return os;
        }
        switch (encoding.toLowerCase()) {
            case "base64": {
                return new Base64OutputStream(os, true);
            }
            case "quoted-printable": {
                return new Base64OutputStream(os, true);
            }
            case "binary": 
            case "7bit": 
            case "8bit": {
                return os;
            }
        }
        throw new CamelException("Unknown encoding: " + encoding);
    }

    public static String decode(String data, Charset charset, String encoding) throws CamelException, DecoderException {
        byte[] decoded = EntityUtils.decode(data.getBytes(charset), encoding);
        return new String(decoded, charset);
    }

    public static byte[] decode(byte[] data, String encoding) throws CamelException, DecoderException {
        ObjectHelper.notNull((Object)data, (String)"Data");
        if (encoding == null) {
            return data;
        }
        switch (encoding.toLowerCase()) {
            case "base64": {
                return Base64.decode((byte[])data);
            }
            case "quoted-printable": {
                return QuotedPrintableCodec.decodeQuotedPrintable((byte[])data);
            }
            case "binary": 
            case "7bit": 
            case "8bit": {
                return data;
            }
        }
        throw new CamelException("Unknown encoding: " + encoding);
    }

    public static InputStream decode(InputStream is, String encoding) throws CamelException {
        ObjectHelper.notNull((Object)is, (String)"Input Stream");
        if (encoding == null) {
            return is;
        }
        switch (encoding.toLowerCase()) {
            case "base64": {
                return new Base64InputStream(is, false);
            }
            case "quoted-printable": {
                return new Base64InputStream(is, false);
            }
            case "binary": 
            case "7bit": 
            case "8bit": {
                return is;
            }
        }
        throw new CamelException("Unknown encoding: " + encoding);
    }

    public static ApplicationEntity createEDIEntity(String ediMessage, ContentType ediMessageContentType, String contentTransferEncoding, boolean isMainBody, String filename) throws CamelException {
        ObjectHelper.notNull((Object)ediMessage, (String)"EDI Message");
        ObjectHelper.notNull((Object)ediMessageContentType, (String)"EDI Message Content Type");
        String charset = null;
        if (ediMessageContentType.getCharset() != null) {
            charset = ediMessageContentType.getCharset().toString();
        }
        switch (ediMessageContentType.getMimeType().toLowerCase()) {
            case "application/edifact": {
                return new ApplicationEDIFACTEntity(ediMessage, charset, contentTransferEncoding, isMainBody, filename);
            }
            case "application/edi-x12": {
                return new ApplicationEDIX12Entity(ediMessage, charset, contentTransferEncoding, isMainBody, filename);
            }
            case "application/edi-consent": {
                return new ApplicationEDIConsentEntity(ediMessage, charset, contentTransferEncoding, isMainBody, filename);
            }
            case "application/xml": {
                return new ApplicationXMLEntity(ediMessage, charset, contentTransferEncoding, isMainBody, filename);
            }
        }
        throw new CamelException("Invalid EDI entity mime type: " + ediMessageContentType.getMimeType());
    }

    public static byte[] getContent(HttpEntity entity) {
        byte[] byArray;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            entity.writeTo((OutputStream)os);
            os.flush();
            byArray = os.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    os.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                LOG.debug("failed to get content", (Throwable)e);
                return null;
            }
        }
        os.close();
        return byArray;
    }

    public static boolean hasEntity(HttpMessage message) {
        boolean hasEntity = false;
        if (message instanceof ClassicHttpRequest) {
            ClassicHttpRequest httpEntityEnclosingRequest = (ClassicHttpRequest)message;
            hasEntity = httpEntityEnclosingRequest.getEntity() != null;
        } else if (message instanceof ClassicHttpResponse) {
            ClassicHttpResponse httpResponse = (ClassicHttpResponse)message;
            hasEntity = httpResponse.getEntity() != null;
        }
        return hasEntity;
    }

    public static HttpEntity getMessageEntity(HttpMessage message) {
        if (message instanceof ClassicHttpRequest) {
            ClassicHttpRequest httpEntityEnclosingRequest = (ClassicHttpRequest)message;
            return httpEntityEnclosingRequest.getEntity();
        }
        if (message instanceof ClassicHttpResponse) {
            ClassicHttpResponse httpResponse = (ClassicHttpResponse)message;
            return httpResponse.getEntity();
        }
        return null;
    }

    public static void setMessageEntity(HttpMessage message, HttpEntity entity) {
        MimeEntity mimeEntity;
        Header contentTransferEncodingHeader;
        if (message instanceof ClassicHttpRequest) {
            ClassicHttpRequest httpEntityEnclosingRequest = (ClassicHttpRequest)message;
            httpEntityEnclosingRequest.setEntity(entity);
        } else if (message instanceof ClassicHttpResponse) {
            ClassicHttpResponse httpResponse = (ClassicHttpResponse)message;
            httpResponse.setEntity(entity);
        }
        String contentType = entity.getContentType();
        if (contentType != null) {
            message.setHeader("Content-Type", (Object)contentType);
        }
        if (entity instanceof MimeEntity && (contentTransferEncodingHeader = (mimeEntity = (MimeEntity)entity).getContentTransferEncoding()) != null) {
            message.setHeader(contentTransferEncodingHeader);
        }
        long contentLength = entity.getContentLength();
        message.setHeader("Content-Length", (Object)Long.toString(contentLength));
    }

    public static byte[] decodeTransferEncodingOfBodyPartContent(String bodyPartContent, ContentType contentType, String bodyPartTransferEncoding) throws CamelException, DecoderException {
        ObjectHelper.notNull((Object)bodyPartContent, (String)"bodyPartContent");
        Charset contentCharset = contentType.getCharset();
        if (contentCharset == null) {
            contentCharset = StandardCharsets.US_ASCII;
        }
        return EntityUtils.decode(bodyPartContent.getBytes(contentCharset), bodyPartTransferEncoding);
    }

    public static void printEntity(PrintStream out, HttpEntity entity) throws IOException {
        entity.writeTo((OutputStream)out);
    }

    public static String printEntity(HttpEntity entity) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            PrintStream ps = new PrintStream((OutputStream)baos, true, StandardCharsets.UTF_8);
            try {
                EntityUtils.printEntity(ps, entity);
                String string = baos.toString(StandardCharsets.UTF_8);
                ps.close();
                return string;
            }
            catch (Throwable throwable) {
                try {
                    ps.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }
}

