/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.as2.api.entity;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.component.as2.api.CanonicalOutputStream;
import org.apache.camel.component.as2.api.entity.AS2DispositionModifier;
import org.apache.camel.component.as2.api.entity.AS2DispositionType;
import org.apache.camel.component.as2.api.entity.DispositionMode;
import org.apache.camel.component.as2.api.entity.MimeEntity;
import org.apache.camel.component.as2.api.util.HttpMessageUtils;
import org.apache.camel.component.as2.api.util.MicUtils;
import org.apache.camel.util.ObjectHelper;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpMessage;
import org.apache.http.HttpResponse;
import org.apache.http.entity.ContentType;
import org.apache.http.message.BasicHeader;

public class AS2MessageDispositionNotificationEntity
extends MimeEntity {
    private static final String ADDRESS_TYPE_PREFIX = "rfc822;";
    private static final String MTA_NAME_TYPE_PREFIX = "dns;";
    private static final String REPORTING_UA = "Reporting-UA";
    private static final String MDN_GATEWAY = "MDN-Gateway";
    private static final String FINAL_RECIPIENT = "Final-Recipient";
    private static final String ORIGINAL_MESSAGE_ID = "Original-Message-ID";
    private static final String AS2_DISPOSITION = "Disposition";
    private static final String FAILURE = "Failure";
    private static final String ERROR = "Error";
    private static final String WARNING = "Warning";
    private static final String RECEIVED_CONTENT_MIC = "Received-content-MIC";
    private String reportingUA;
    private String mtnName;
    private String finalRecipient;
    private String originalMessageId;
    private DispositionMode dispositionMode;
    private AS2DispositionType dispositionType;
    private AS2DispositionModifier dispositionModifier;
    private String[] failureFields;
    private String[] errorFields;
    private String[] warningFields;
    private Map<String, String> extensionFields = new HashMap<String, String>();
    private MicUtils.ReceivedContentMic receivedContentMic;
    private String parsedBodyPartFields;

    public AS2MessageDispositionNotificationEntity(HttpEntityEnclosingRequest request, HttpResponse response, DispositionMode dispositionMode, AS2DispositionType dispositionType, AS2DispositionModifier dispositionModifier, String[] failureFields, String[] errorFields, String[] warningFields, Map<String, String> extensionFields, String charset, boolean isMainBody, PrivateKey decryptingPrivateKey, Certificate[] validateSigningCertificateChain) throws HttpException {
        this.setMainBody(isMainBody);
        this.setContentType(ContentType.create((String)"message/disposition-notification", (String)charset));
        this.finalRecipient = HttpMessageUtils.getHeaderValue((HttpMessage)request, "AS2-To");
        if (this.finalRecipient == null) {
            throw new HttpException("The AS2-To is missing");
        }
        this.originalMessageId = HttpMessageUtils.getHeaderValue((HttpMessage)request, "Message-Id");
        this.receivedContentMic = MicUtils.createReceivedContentMic(request, validateSigningCertificateChain, decryptingPrivateKey);
        this.reportingUA = HttpMessageUtils.getHeaderValue((HttpMessage)response, "Server");
        this.dispositionMode = (DispositionMode)((Object)ObjectHelper.notNull((Object)((Object)dispositionMode), (String)"Disposition Mode"));
        this.dispositionType = (AS2DispositionType)((Object)ObjectHelper.notNull((Object)((Object)dispositionType), (String)"Disposition Type"));
        this.dispositionModifier = dispositionModifier;
        this.failureFields = failureFields;
        this.errorFields = errorFields;
        this.warningFields = warningFields;
        if (extensionFields == null || extensionFields.isEmpty()) {
            this.extensionFields.clear();
        } else {
            this.extensionFields.putAll(extensionFields);
        }
    }

    public AS2MessageDispositionNotificationEntity(String reportingUA, String mtnName, String finalRecipient, String originalMessageId, DispositionMode dispositionMode, AS2DispositionType dispositionType, AS2DispositionModifier dispositionModifier, String[] failureFields, String[] errorFields, String[] warningFields, Map<String, String> extensionFields, MicUtils.ReceivedContentMic receivedContentMic, String parsedBodyPartFields) {
        this.reportingUA = reportingUA;
        this.mtnName = mtnName;
        this.finalRecipient = finalRecipient;
        this.originalMessageId = originalMessageId;
        this.dispositionMode = dispositionMode;
        this.dispositionType = dispositionType;
        this.dispositionModifier = dispositionModifier;
        this.failureFields = failureFields;
        this.errorFields = errorFields;
        this.warningFields = warningFields;
        this.extensionFields = extensionFields;
        this.receivedContentMic = receivedContentMic;
        this.parsedBodyPartFields = parsedBodyPartFields;
    }

    public String getReportingUA() {
        return this.reportingUA;
    }

    public String getMtnName() {
        return this.mtnName;
    }

    public String getFinalRecipient() {
        return this.finalRecipient;
    }

    public String getOriginalMessageId() {
        return this.originalMessageId;
    }

    public DispositionMode getDispositionMode() {
        return this.dispositionMode;
    }

    public AS2DispositionType getDispositionType() {
        return this.dispositionType;
    }

    public AS2DispositionModifier getDispositionModifier() {
        return this.dispositionModifier;
    }

    public String[] getFailureFields() {
        return this.failureFields;
    }

    public String[] getErrorFields() {
        return this.errorFields;
    }

    public String[] getWarningFields() {
        return this.warningFields;
    }

    public Map<String, String> getExtensionFields() {
        return this.extensionFields;
    }

    public MicUtils.ReceivedContentMic getReceivedContentMic() {
        return this.receivedContentMic;
    }

    public void writeTo(OutputStream outstream) throws IOException {
        MimeEntity.NoCloseOutputStream ncos = new MimeEntity.NoCloseOutputStream(outstream);
        try (CanonicalOutputStream canonicalOutstream = new CanonicalOutputStream(ncos, StandardCharsets.US_ASCII.name());){
            BasicHeader failureField;
            if (!this.isMainBody()) {
                HeaderIterator it = this.headerIterator();
                while (it.hasNext()) {
                    Header header = it.nextHeader();
                    canonicalOutstream.writeln(header.toString());
                }
                canonicalOutstream.writeln();
            }
            if (this.parsedBodyPartFields != null) {
                canonicalOutstream.writeln(this.parsedBodyPartFields);
                return;
            }
            if (this.reportingUA != null) {
                BasicHeader reportingUAField = new BasicHeader(REPORTING_UA, this.reportingUA);
                canonicalOutstream.writeln(reportingUAField.toString());
            }
            if (this.mtnName != null) {
                BasicHeader mdnGatewayField = new BasicHeader(MDN_GATEWAY, MTA_NAME_TYPE_PREFIX + this.mtnName);
                canonicalOutstream.writeln(mdnGatewayField.toString());
            }
            BasicHeader finalRecipientField = new BasicHeader(FINAL_RECIPIENT, ADDRESS_TYPE_PREFIX + this.finalRecipient);
            canonicalOutstream.writeln(finalRecipientField.toString());
            if (this.originalMessageId != null) {
                BasicHeader originalMessageIdField = new BasicHeader(ORIGINAL_MESSAGE_ID, this.originalMessageId);
                canonicalOutstream.writeln(originalMessageIdField.toString());
            }
            String as2Disposition = this.dispositionMode.toString() + ";" + this.dispositionType.toString();
            if (this.dispositionModifier != null) {
                as2Disposition = as2Disposition + "/" + this.dispositionModifier.toString();
            }
            BasicHeader as2DispositionField = new BasicHeader(AS2_DISPOSITION, as2Disposition);
            canonicalOutstream.writeln(as2DispositionField.toString());
            if (this.failureFields != null) {
                for (String string : this.failureFields) {
                    failureField = new BasicHeader(FAILURE, string);
                    canonicalOutstream.writeln(failureField.toString());
                }
            }
            if (this.errorFields != null) {
                for (String string : this.errorFields) {
                    BasicHeader errorField = new BasicHeader(ERROR, string);
                    canonicalOutstream.writeln(errorField.toString());
                }
            }
            if (this.failureFields != null) {
                for (String string : this.failureFields) {
                    failureField = new BasicHeader(WARNING, string);
                    canonicalOutstream.writeln(failureField.toString());
                }
            }
            if (this.extensionFields != null) {
                for (Map.Entry entry : this.extensionFields.entrySet()) {
                    BasicHeader failureField2 = new BasicHeader((String)entry.getKey(), (String)entry.getValue());
                    canonicalOutstream.writeln(failureField2.toString());
                }
            }
            if (this.receivedContentMic != null) {
                BasicHeader as2ReceivedContentMicField = new BasicHeader(RECEIVED_CONTENT_MIC, this.receivedContentMic.toString());
                canonicalOutstream.writeln(as2ReceivedContentMicField.toString());
            }
        }
    }
}

