/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.as2.api.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import org.apache.camel.component.as2.api.AS2SignatureAlgorithm;
import org.apache.camel.component.as2.api.AS2SignedDataGenerator;
import org.apache.camel.component.as2.api.entity.ApplicationPkcs7SignatureEntity;
import org.apache.camel.component.as2.api.entity.MimeEntity;
import org.apache.camel.component.as2.api.entity.MultipartSignedEntity;
import org.apache.camel.util.ObjectHelper;
import org.apache.hc.core5.http.HttpException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.smime.SMIMECapabilitiesAttribute;
import org.bouncycastle.asn1.smime.SMIMECapability;
import org.bouncycastle.asn1.smime.SMIMECapabilityVector;
import org.bouncycastle.asn1.smime.SMIMEEncryptionKeyPreferenceAttribute;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInfoGenerator;
import org.bouncycastle.cms.SignerInformationVerifier;
import org.bouncycastle.cms.SignerInformationVerifierProvider;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoGeneratorBuilder;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.util.Store;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SigningUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SigningUtils.class);

    private SigningUtils() {
    }

    public static AS2SignedDataGenerator createSigningGenerator(AS2SignatureAlgorithm signingAlgorithm, Certificate[] certificateChain, PrivateKey privateKey) throws HttpException {
        ObjectHelper.notNull((Object)certificateChain, (String)"certificateChain");
        if (certificateChain.length == 0 || !(certificateChain[0] instanceof X509Certificate)) {
            throw new IllegalArgumentException("Invalid certificate chain");
        }
        ObjectHelper.notNull((Object)privateKey, (String)"privateKey");
        AS2SignedDataGenerator gen = new AS2SignedDataGenerator();
        X509Certificate signingCert = (X509Certificate)certificateChain[0];
        SMIMECapabilityVector capabilities = new SMIMECapabilityVector();
        capabilities.addCapability(SMIMECapability.dES_EDE3_CBC);
        capabilities.addCapability(SMIMECapability.rC2_CBC, 128);
        capabilities.addCapability(SMIMECapability.dES_CBC);
        ASN1EncodableVector attributes = new ASN1EncodableVector();
        attributes.add((ASN1Encodable)new SMIMEEncryptionKeyPreferenceAttribute(new IssuerAndSerialNumber(new X500Name(signingCert.getIssuerX500Principal().getName()), signingCert.getSerialNumber())));
        attributes.add((ASN1Encodable)new SMIMECapabilitiesAttribute(capabilities));
        SignerInfoGenerator signerInfoGenerator = null;
        try {
            signerInfoGenerator = new JcaSimpleSignerInfoGeneratorBuilder().setProvider("BC").setSignedAttributeGenerator(new AttributeTable(attributes)).build(signingAlgorithm.getSignatureAlgorithmName(), privateKey, signingCert);
        }
        catch (Exception e) {
            throw new HttpException("Failed to create signer info", (Throwable)e);
        }
        gen.addSignerInfoGenerator(signerInfoGenerator);
        try {
            JcaCertStore certs = new JcaCertStore(Arrays.asList(certificateChain));
            gen.addCertificates((Store)certs);
        }
        catch (CertificateEncodingException | CMSException e) {
            throw new HttpException("Failed to add certificate chain to signature", e);
        }
        return gen;
    }

    public static boolean isValidSigned(byte[] signedContent, byte[] signature, Certificate[] signingCertificateChain) {
        if (signedContent == null || signature == null || signingCertificateChain == null) {
            return false;
        }
        try {
            CMSSignedData signedData = new CMSSignedData((CMSProcessable)new CMSProcessableByteArray(signedContent), (InputStream)new ByteArrayInputStream(signature));
            SignerInformationVerifierProvider sivp = sid -> {
                for (Certificate knownCert : signingCertificateChain) {
                    SignerInformationVerifier siv = new JcaSimpleSignerInfoVerifierBuilder().setProvider("BC").build((X509Certificate)knownCert);
                    if (!siv.getAssociatedCertificate().getIssuer().equals((Object)sid.getIssuer()) || !siv.getAssociatedCertificate().getSerialNumber().equals(sid.getSerialNumber())) continue;
                    return siv;
                }
                throw new RuntimeException("Signature was created with an unknown certificate");
            };
            return signedData.verifySignatures(sivp);
        }
        catch (CMSException e) {
            LOG.debug(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            LOG.debug(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    public static boolean isValid(MultipartSignedEntity multipartSignedEntity, Certificate[] signingCertificateChain) {
        boolean bl;
        MimeEntity signedEntity = multipartSignedEntity.getSignedDataEntity();
        ApplicationPkcs7SignatureEntity applicationPkcs7SignatureEntity = multipartSignedEntity.getSignatureEntity();
        if (signedEntity == null || applicationPkcs7SignatureEntity == null) {
            return false;
        }
        ByteArrayOutputStream o = new ByteArrayOutputStream();
        try {
            signedEntity.writeTo(o);
            bl = SigningUtils.isValidSigned(o.toByteArray(), applicationPkcs7SignatureEntity.getSignature(), signingCertificateChain);
        }
        catch (Throwable throwable) {
            try {
                try {
                    o.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return false;
            }
        }
        o.close();
        return bl;
    }
}

