/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.as2.api.entity;

import org.apache.camel.component.as2.api.AS2SignedDataGenerator;
import org.apache.camel.component.as2.api.entity.ApplicationPkcs7SignatureEntity;
import org.apache.camel.component.as2.api.entity.MimeEntity;
import org.apache.camel.component.as2.api.entity.MultipartMimeEntity;
import org.apache.http.HttpException;

public class MultipartSignedEntity
extends MultipartMimeEntity {
    public MultipartSignedEntity(MimeEntity data, AS2SignedDataGenerator signer, String signatureCharSet, String signatureTransferEncoding, boolean isMainBody, String boundary) throws HttpException {
        super(null, isMainBody, boundary);
        this.setContentType(signer.createMultipartSignedContentType(this.boundary));
        this.addPart(data);
        ApplicationPkcs7SignatureEntity signature = new ApplicationPkcs7SignatureEntity(data, signer, signatureCharSet, signatureTransferEncoding, false);
        this.addPart(signature);
    }

    protected MultipartSignedEntity(String boundary, boolean isMainBody) {
        this.boundary = boundary;
        this.isMainBody = isMainBody;
    }

    public MimeEntity getSignedDataEntity() {
        if (this.getPartCount() > 0) {
            return this.getPart(0);
        }
        return null;
    }

    public ApplicationPkcs7SignatureEntity getSignatureEntity() {
        if (this.getPartCount() > 1 && this.getPart(1) instanceof ApplicationPkcs7SignatureEntity) {
            return (ApplicationPkcs7SignatureEntity)this.getPart(1);
        }
        return null;
    }
}

