/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.as2.api.protocol;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.camel.component.as2.api.AS2SignatureAlgorithm;
import org.apache.camel.component.as2.api.AS2SignedDataGenerator;
import org.apache.camel.component.as2.api.InvalidAS2NameException;
import org.apache.camel.component.as2.api.entity.AS2DispositionModifier;
import org.apache.camel.component.as2.api.entity.AS2DispositionType;
import org.apache.camel.component.as2.api.entity.DispositionMode;
import org.apache.camel.component.as2.api.entity.DispositionNotificationMultipartReportEntity;
import org.apache.camel.component.as2.api.entity.DispositionNotificationOptions;
import org.apache.camel.component.as2.api.entity.DispositionNotificationOptionsParser;
import org.apache.camel.component.as2.api.entity.MultipartSignedEntity;
import org.apache.camel.component.as2.api.util.AS2Utils;
import org.apache.camel.component.as2.api.util.EntityUtils;
import org.apache.camel.component.as2.api.util.HttpMessageUtils;
import org.apache.camel.component.as2.api.util.SigningUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpMessage;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpCoreContext;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseMDN
implements HttpResponseInterceptor {
    public static final String BOUNDARY_PARAM_NAME = "boundary";
    private static final String DEFAULT_MDN_MESSAGE_TEMPLATE = "MDN for -\n Message ID: $requestHeaders[\"Message-Id\"]\n  Subject: $requestHeaders[\"Subject\"]\n  Date: $requestHeaders[\"Date\"]\n  From: $requestHeaders[\"AS2-From\"]\n  To: $requestHeaders[\"AS2-To\"]\n  Received on: $responseHeaders[\"Date\"]\n Status: $dispositionType \n";
    private static final Logger LOG = LoggerFactory.getLogger(ResponseMDN.class);
    private final String as2Version;
    private final String serverFQDN;
    private AS2SignatureAlgorithm signingAlgorithm;
    private Certificate[] signingCertificateChain;
    private PrivateKey signingPrivateKey;
    private PrivateKey decryptingPrivateKey;
    private String mdnMessageTemplate;
    private Certificate[] validateSigningCertificateChain;
    private VelocityEngine velocityEngine;

    public ResponseMDN(String as2Version, String serverFQDN, AS2SignatureAlgorithm signingAlgorithm, Certificate[] signingCertificateChain, PrivateKey signingPrivateKey, PrivateKey decryptingPrivateKey, String mdnMessageTemplate, Certificate[] validateSigningCertificateChain) {
        this.as2Version = as2Version;
        this.serverFQDN = serverFQDN;
        this.signingAlgorithm = signingAlgorithm;
        this.signingCertificateChain = signingCertificateChain;
        this.signingPrivateKey = signingPrivateKey;
        this.decryptingPrivateKey = decryptingPrivateKey;
        this.mdnMessageTemplate = !StringUtils.isBlank((CharSequence)mdnMessageTemplate) ? mdnMessageTemplate : DEFAULT_MDN_MESSAGE_TEMPLATE;
        this.validateSigningCertificateChain = validateSigningCertificateChain;
    }

    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        DispositionNotificationMultipartReportEntity multipartReportEntity;
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode < 200 || statusCode >= 300) {
            LOG.debug("MDN not return due to response status code: {}", (Object)statusCode);
            return;
        }
        HttpCoreContext coreContext = HttpCoreContext.adapt((HttpContext)context);
        HttpRequest request = (HttpRequest)coreContext.getAttribute("http.request", HttpRequest.class);
        if (request == null || !(request instanceof HttpEntityEnclosingRequest)) {
            return;
        }
        HttpEntityEnclosingRequest httpEntityEnclosingRequest = (HttpEntityEnclosingRequest)request;
        LOG.debug("Processing MDN for request: {}", (Object)httpEntityEnclosingRequest);
        if (HttpMessageUtils.getHeaderValue((HttpMessage)httpEntityEnclosingRequest, "Disposition-Notification-To") == null) {
            LOG.debug("MDN not returned: no receipt requested");
            return;
        }
        String boundary = EntityUtils.createBoundaryValue();
        if (AS2DispositionType.FAILED.getType().equals(HttpMessageUtils.getHeaderValue((HttpMessage)request, "Disposition-Type"))) {
            mdnMessage = this.createMdnDescription(httpEntityEnclosingRequest, response, DispositionMode.AUTOMATIC_ACTION_MDN_SENT_AUTOMATICALLY, AS2DispositionType.FAILED, null, null, null, null, null, this.mdnMessageTemplate);
            multipartReportEntity = new DispositionNotificationMultipartReportEntity(httpEntityEnclosingRequest, response, DispositionMode.AUTOMATIC_ACTION_MDN_SENT_AUTOMATICALLY, AS2DispositionType.FAILED, null, null, null, null, null, StandardCharsets.US_ASCII.name(), boundary, true, this.decryptingPrivateKey, mdnMessage, this.validateSigningCertificateChain);
        } else {
            mdnMessage = this.createMdnDescription(httpEntityEnclosingRequest, response, DispositionMode.AUTOMATIC_ACTION_MDN_SENT_AUTOMATICALLY, AS2DispositionType.PROCESSED, null, null, null, null, null, this.mdnMessageTemplate);
            multipartReportEntity = new DispositionNotificationMultipartReportEntity(httpEntityEnclosingRequest, response, DispositionMode.AUTOMATIC_ACTION_MDN_SENT_AUTOMATICALLY, AS2DispositionType.PROCESSED, null, null, null, null, null, StandardCharsets.US_ASCII.name(), boundary, true, this.decryptingPrivateKey, mdnMessage, this.validateSigningCertificateChain);
        }
        DispositionNotificationOptions dispositionNotificationOptions = DispositionNotificationOptionsParser.parseDispositionNotificationOptions(HttpMessageUtils.getHeaderValue((HttpMessage)httpEntityEnclosingRequest, "Disposition-Notification-Options"), null);
        String receiptAddress = HttpMessageUtils.getHeaderValue((HttpMessage)httpEntityEnclosingRequest, "Receipt-Delivery-Option");
        if (receiptAddress != null) {
            coreContext.setAttribute("camel-as2.async-mdn.recipient-address", (Object)receiptAddress);
            coreContext.setAttribute("camel-as2.async-mdn.asynchronous-mdn", (Object)multipartReportEntity);
        } else {
            response.addHeader("MIME-Version", "1.0");
            response.addHeader("AS2-Version", this.as2Version);
            String subjectPrefix = (String)coreContext.getAttribute("camel-as2.serversubject", String.class);
            Object subject = HttpMessageUtils.getHeaderValue((HttpMessage)httpEntityEnclosingRequest, "Subject");
            subject = subjectPrefix != null && subject != null ? subjectPrefix + (String)subject : (subject != null ? "MDN Response To:" + (String)subject : "Your Requested MDN Response");
            response.addHeader("Subject", (String)subject);
            String from = (String)coreContext.getAttribute("camel-as2.serverfrom", String.class);
            response.addHeader("From", from);
            String as2From = HttpMessageUtils.getHeaderValue((HttpMessage)httpEntityEnclosingRequest, "AS2-To");
            try {
                AS2Utils.validateAS2Name(as2From);
            }
            catch (InvalidAS2NameException e) {
                throw new HttpException("Invalid AS-From name", (Throwable)e);
            }
            response.addHeader("AS2-From", as2From);
            String as2To = HttpMessageUtils.getHeaderValue((HttpMessage)httpEntityEnclosingRequest, "AS2-From");
            try {
                AS2Utils.validateAS2Name(as2To);
            }
            catch (InvalidAS2NameException e) {
                throw new HttpException("Invalid AS-To name", (Throwable)e);
            }
            response.addHeader("AS2-To", as2To);
            response.addHeader("Message-Id", AS2Utils.createMessageId(this.serverFQDN));
            AS2SignedDataGenerator gen = null;
            if (dispositionNotificationOptions.getSignedReceiptProtocol() != null && this.signingCertificateChain != null && this.signingPrivateKey != null) {
                gen = SigningUtils.createSigningGenerator(this.signingAlgorithm, this.signingCertificateChain, this.signingPrivateKey);
            }
            if (gen != null) {
                try {
                    multipartReportEntity.setMainBody(false);
                    MultipartSignedEntity multipartSignedEntity = new MultipartSignedEntity(multipartReportEntity, gen, StandardCharsets.US_ASCII.name(), "base64", false, null);
                    response.setHeader(multipartSignedEntity.getContentType());
                    EntityUtils.setMessageEntity((HttpMessage)response, (HttpEntity)multipartSignedEntity);
                }
                catch (Exception e) {
                    LOG.warn("failed to sign receipt");
                }
            } else {
                response.setHeader(multipartReportEntity.getContentType());
                EntityUtils.setMessageEntity((HttpMessage)response, (HttpEntity)multipartReportEntity);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(AS2Utils.printMessage((HttpMessage)response));
        }
    }

    private String createMdnDescription(HttpEntityEnclosingRequest request, HttpResponse response, DispositionMode dispositionMode, AS2DispositionType dispositionType, AS2DispositionModifier dispositionModifier, String[] failureFields, String[] errorFields, String[] warningFields, Map<String, String> extensionFields, String mdnMessageTemplate) throws HttpException {
        try {
            VelocityContext context = new VelocityContext();
            context.put("request", (Object)request);
            HashMap<String, String> requestHeaders = new HashMap<String, String>();
            for (Header header : request.getAllHeaders()) {
                requestHeaders.put(header.getName(), header.getValue());
            }
            context.put("requestHeaders", requestHeaders);
            HashMap<String, String> responseHeaders = new HashMap<String, String>();
            for (Header header : response.getAllHeaders()) {
                responseHeaders.put(header.getName(), header.getValue());
            }
            context.put("responseHeaders", responseHeaders);
            context.put("dispositionMode", (Object)dispositionMode);
            context.put("dispositionType", (Object)dispositionType);
            context.put("dispositionModifier", (Object)dispositionModifier);
            context.put("failureFields", (Object)failureFields);
            context.put("errorFields", (Object)errorFields);
            context.put("warningFields", (Object)warningFields);
            context.put("extensionFields", extensionFields);
            VelocityEngine engine = this.getVelocityEngine();
            StringWriter buffer = new StringWriter();
            engine.evaluate((Context)context, (Writer)buffer, this.getClass().getName(), mdnMessageTemplate);
            return buffer.toString();
        }
        catch (Exception e) {
            throw new HttpException("failed to create MDN description", (Throwable)e);
        }
    }

    private synchronized VelocityEngine getVelocityEngine() {
        if (this.velocityEngine == null) {
            this.velocityEngine = new VelocityEngine();
            Properties properties = new Properties();
            properties.setProperty("resource.loader", "file, class");
            properties.setProperty("class.resource.loader.description", "Camel Velocity Classpath Resource Loader");
            properties.setProperty("class.resource.loader.class", ClasspathResourceLoader.class.getName());
            Logger velocityLogger = LoggerFactory.getLogger((String)"org.apache.camel.maven.Velocity");
            properties.setProperty("runtime.log.name", velocityLogger.getName());
            this.velocityEngine.init(properties);
        }
        return this.velocityEngine;
    }
}

