/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.as2.api.util;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import org.apache.camel.component.as2.api.AS2MicAlgorithm;
import org.apache.camel.component.as2.api.entity.ApplicationEntity;
import org.apache.camel.component.as2.api.entity.DispositionNotificationOptions;
import org.apache.camel.component.as2.api.entity.DispositionNotificationOptionsParser;
import org.apache.camel.component.as2.api.util.EntityUtils;
import org.apache.camel.component.as2.api.util.HttpMessageUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MicUtils {
    private static final Logger LOG = LoggerFactory.getLogger(MicUtils.class);

    private MicUtils() {
    }

    public static byte[] createMic(byte[] content, String algorithmId) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(algorithmId, "BC");
            return messageDigest.digest(content);
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            LOG.debug("failed to get message digets '{}'", (Object)algorithmId);
            return null;
        }
    }

    public static ReceivedContentMic createReceivedContentMic(HttpEntityEnclosingRequest request, Certificate[] validateSigningCertificateChain, PrivateKey decryptingPrivateKey) throws HttpException {
        String dispositionNotificationOptionsString = HttpMessageUtils.getHeaderValue((HttpMessage)request, "Disposition-Notification-Options");
        if (dispositionNotificationOptionsString == null) {
            LOG.debug("do not create MIC: no disposition notification options in request");
            return null;
        }
        DispositionNotificationOptions dispositionNotificationOptions = DispositionNotificationOptionsParser.parseDispositionNotificationOptions(dispositionNotificationOptionsString, null);
        String micJdkAlgorithmName = MicUtils.getMicJdkAlgorithmName(dispositionNotificationOptions.getSignedReceiptMicalg().getValues());
        if (micJdkAlgorithmName == null) {
            LOG.debug("do not create MIC: no matching MIC algorithms found");
            return null;
        }
        ApplicationEntity entity = HttpMessageUtils.extractEdiPayload((HttpMessage)request, new HttpMessageUtils.DecrpytingAndSigningInfo(validateSigningCertificateChain, decryptingPrivateKey));
        byte[] content = EntityUtils.getContent((HttpEntity)entity);
        String micAS2AlgorithmName = AS2MicAlgorithm.getAS2AlgorithmName(micJdkAlgorithmName);
        byte[] mic = MicUtils.createMic(content, micJdkAlgorithmName);
        try {
            return new ReceivedContentMic(micAS2AlgorithmName, mic);
        }
        catch (Exception e) {
            throw new HttpException("Failed to encode MIC", (Throwable)e);
        }
    }

    public static String getMicJdkAlgorithmName(String[] micAs2AlgorithmNames) {
        if (micAs2AlgorithmNames == null) {
            return AS2MicAlgorithm.SHA_1.getJdkAlgorithmName();
        }
        for (String micAs2AlgorithmName : micAs2AlgorithmNames) {
            String micJdkAlgorithmName = AS2MicAlgorithm.getJdkAlgorithmName(micAs2AlgorithmName);
            if (micJdkAlgorithmName == null) continue;
            return micJdkAlgorithmName;
        }
        return AS2MicAlgorithm.SHA_1.getJdkAlgorithmName();
    }

    public static class ReceivedContentMic {
        private final String digestAlgorithmId;
        private final String encodedMessageDigest;

        public ReceivedContentMic(String digestAlgorithmId, byte[] messageDigest) throws Exception {
            this.digestAlgorithmId = digestAlgorithmId;
            messageDigest = EntityUtils.encode(messageDigest, "base64");
            this.encodedMessageDigest = new String(messageDigest, StandardCharsets.US_ASCII);
        }

        protected ReceivedContentMic(String digestAlgorithmId, String encodedMessageDigest) {
            this.digestAlgorithmId = digestAlgorithmId;
            this.encodedMessageDigest = encodedMessageDigest;
        }

        public String getDigestAlgorithmId() {
            return this.digestAlgorithmId;
        }

        public String getEncodedMessageDigest() {
            return this.encodedMessageDigest;
        }

        public String toString() {
            return this.encodedMessageDigest + "," + this.digestAlgorithmId;
        }
    }
}

