/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.as2.api;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import org.apache.camel.component.as2.api.AS2AsynchronousMDNManager;
import org.apache.camel.component.as2.api.AS2SignatureAlgorithm;
import org.apache.camel.component.as2.api.entity.DispositionNotificationMultipartReportEntity;
import org.apache.camel.component.as2.api.io.AS2BHttpServerConnection;
import org.apache.camel.component.as2.api.protocol.ResponseMDN;
import org.apache.http.ConnectionClosedException;
import org.apache.http.HttpException;
import org.apache.http.HttpInetConnection;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.HttpServerConnection;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpCoreContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpProcessorBuilder;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.protocol.HttpRequestHandlerMapper;
import org.apache.http.protocol.HttpService;
import org.apache.http.protocol.ResponseConnControl;
import org.apache.http.protocol.ResponseContent;
import org.apache.http.protocol.ResponseDate;
import org.apache.http.protocol.ResponseServer;
import org.apache.http.protocol.UriHttpRequestHandlerMapper;
import org.apache.http.util.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AS2ServerConnection {
    private static final Logger LOG = LoggerFactory.getLogger(AS2ServerConnection.class);
    private static final String REQUEST_LISTENER_THREAD_NAME_PREFIX = "AS2Svr-";
    private static final String REQUEST_HANDLER_THREAD_NAME_PREFIX = "AS2Hdlr-";
    private RequestListenerThread listenerThread;
    private String as2Version;
    private String originServer;
    private String serverFqdn;
    private Integer serverPortNumber;
    private AS2SignatureAlgorithm signingAlgorithm;
    private Certificate[] signingCertificateChain;
    private PrivateKey signingPrivateKey;
    private PrivateKey decryptingPrivateKey;

    public AS2ServerConnection(String as2Version, String originServer, String serverFqdn, Integer serverPortNumber, AS2SignatureAlgorithm signingAlgorithm, Certificate[] signingCertificateChain, PrivateKey signingPrivateKey, PrivateKey decryptingPrivateKey) throws IOException {
        this.as2Version = (String)Args.notNull((Object)as2Version, (String)"as2Version");
        this.originServer = (String)Args.notNull((Object)originServer, (String)"userAgent");
        this.serverFqdn = (String)Args.notNull((Object)serverFqdn, (String)"serverFqdn");
        this.serverPortNumber = (Integer)Args.notNull((Object)serverPortNumber, (String)"serverPortNumber");
        this.signingAlgorithm = signingAlgorithm;
        this.signingCertificateChain = signingCertificateChain;
        this.signingPrivateKey = signingPrivateKey;
        this.decryptingPrivateKey = decryptingPrivateKey;
        this.listenerThread = new RequestListenerThread(this.as2Version, this.originServer, this.serverFqdn, this.serverPortNumber, this.signingAlgorithm, this.signingCertificateChain, this.signingPrivateKey, this.decryptingPrivateKey);
        this.listenerThread.setDaemon(true);
        this.listenerThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.listenerThread != null) {
            RequestListenerThread requestListenerThread = this.listenerThread;
            synchronized (requestListenerThread) {
                try {
                    this.listenerThread.serversocket.close();
                }
                catch (IOException e) {
                    LOG.debug(e.getMessage(), (Throwable)e);
                }
                finally {
                    this.listenerThread = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listen(String requestUri, HttpRequestHandler handler) throws IOException {
        if (this.listenerThread != null) {
            RequestListenerThread requestListenerThread = this.listenerThread;
            synchronized (requestListenerThread) {
                this.listenerThread.registerHandler(requestUri, handler);
            }
        }
    }

    public void stopListening(String requestUri) {
        if (this.listenerThread != null) {
            this.listenerThread.unregisterHandler(requestUri);
        }
    }

    protected HttpProcessor initProtocolProcessor(String as2Version, String originServer, String serverFqdn, int port, AS2SignatureAlgorithm signatureAlgorithm, Certificate[] signingCertificateChain, PrivateKey signingPrivateKey, PrivateKey decryptingPrivateKey) {
        return HttpProcessorBuilder.create().add((HttpResponseInterceptor)new ResponseContent(true)).add((HttpResponseInterceptor)new ResponseServer(originServer)).add((HttpResponseInterceptor)new ResponseDate()).add((HttpResponseInterceptor)new ResponseConnControl()).add((HttpResponseInterceptor)new ResponseMDN(as2Version, serverFqdn, signatureAlgorithm, signingCertificateChain, signingPrivateKey, decryptingPrivateKey)).build();
    }

    class RequestHandlerThread
    extends Thread {
        private HttpService httpService;
        private HttpServerConnection serverConnection;

        public RequestHandlerThread(HttpService httpService, HttpServerConnection serverConnection) {
            if (serverConnection instanceof HttpInetConnection) {
                HttpInetConnection inetConnection = (HttpInetConnection)serverConnection;
                this.setName(AS2ServerConnection.REQUEST_HANDLER_THREAD_NAME_PREFIX + inetConnection.getLocalPort());
            } else {
                this.setName(AS2ServerConnection.REQUEST_HANDLER_THREAD_NAME_PREFIX + this.getId());
            }
            this.httpService = httpService;
            this.serverConnection = serverConnection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LOG.info("Processing new AS2 request");
            BasicHttpContext context = new BasicHttpContext(null);
            try {
                while (!Thread.interrupted()) {
                    this.httpService.handleRequest(this.serverConnection, (HttpContext)context);
                    HttpCoreContext coreContext = HttpCoreContext.adapt((HttpContext)context);
                    String recipientAddress = (String)coreContext.getAttribute("camel-as2.async-mdn.recipient-address", String.class);
                    if (recipientAddress == null) continue;
                    DispositionNotificationMultipartReportEntity multipartReportEntity = (DispositionNotificationMultipartReportEntity)((Object)coreContext.getAttribute("camel-as2.async-mdn.asynchronous-mdn", DispositionNotificationMultipartReportEntity.class));
                    AS2AsynchronousMDNManager asynchronousMDNManager = new AS2AsynchronousMDNManager(AS2ServerConnection.this.as2Version, AS2ServerConnection.this.originServer, AS2ServerConnection.this.serverFqdn, AS2ServerConnection.this.signingCertificateChain, AS2ServerConnection.this.signingPrivateKey);
                    asynchronousMDNManager.send(multipartReportEntity, recipientAddress);
                }
            }
            catch (ConnectionClosedException ex) {
                LOG.info("Client closed connection");
            }
            catch (IOException ex) {
                LOG.error("I/O error: {}", (Object)ex.getMessage());
            }
            catch (HttpException ex) {
                ex.printStackTrace();
                LOG.error("Unrecoverable HTTP protocol violation: {}", (Object)ex.getMessage());
            }
            finally {
                try {
                    this.serverConnection.shutdown();
                }
                catch (IOException ex) {}
            }
        }
    }

    class RequestListenerThread
    extends Thread {
        private final ServerSocket serversocket;
        private final HttpService httpService;
        private UriHttpRequestHandlerMapper reqistry;

        public RequestListenerThread(String as2Version, String originServer, String serverFqdn, int port, AS2SignatureAlgorithm signatureAlgorithm, Certificate[] signingCertificateChain, PrivateKey signingPrivateKey, PrivateKey decryptingPrivateKey) throws IOException {
            this.setName(AS2ServerConnection.REQUEST_LISTENER_THREAD_NAME_PREFIX + port);
            this.serversocket = new ServerSocket(port);
            HttpProcessor inhttpproc = AS2ServerConnection.this.initProtocolProcessor(as2Version, originServer, serverFqdn, port, signatureAlgorithm, signingCertificateChain, signingPrivateKey, decryptingPrivateKey);
            this.reqistry = new UriHttpRequestHandlerMapper();
            this.httpService = new HttpService(inhttpproc, (HttpRequestHandlerMapper)this.reqistry);
        }

        @Override
        public void run() {
            LOG.info("Listening on port {}", (Object)this.serversocket.getLocalPort());
            while (!Thread.interrupted()) {
                try {
                    int bufsize = 8192;
                    Socket insocket = this.serversocket.accept();
                    AS2BHttpServerConnection inconn = new AS2BHttpServerConnection(8192);
                    LOG.info("Incoming connection from {}", (Object)insocket.getInetAddress());
                    inconn.bind(insocket);
                    RequestHandlerThread t = new RequestHandlerThread(this.httpService, (HttpServerConnection)inconn);
                    t.setDaemon(true);
                    t.start();
                }
                catch (InterruptedIOException ex) {
                    break;
                }
                catch (SocketException e) {
                    break;
                }
                catch (IOException e) {
                    LOG.error("I/O error initialising connection thread: {}", (Object)e.getMessage());
                    break;
                }
            }
        }

        void registerHandler(String requestUriPattern, HttpRequestHandler httpRequestHandler) {
            this.reqistry.register(requestUriPattern, httpRequestHandler);
        }

        void unregisterHandler(String requestUri) {
            this.reqistry.unregister(requestUri);
        }
    }
}

