/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.as2.api.entity;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.security.cert.X509Certificate;
import java.util.Collection;
import org.apache.camel.component.as2.api.AS2SignedDataGenerator;
import org.apache.camel.component.as2.api.entity.ApplicationPkcs7SignatureEntity;
import org.apache.camel.component.as2.api.entity.MimeEntity;
import org.apache.camel.component.as2.api.entity.MultipartMimeEntity;
import org.apache.http.HttpException;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.Store;

public class MultipartSignedEntity
extends MultipartMimeEntity {
    public MultipartSignedEntity(MimeEntity data, AS2SignedDataGenerator signer, String signatureCharSet, String signatureTransferEncoding, boolean isMainBody, String boundary) throws HttpException {
        super(null, isMainBody, boundary);
        this.setContentType(signer.createMultipartSignedContentType(this.boundary));
        this.addPart(data);
        ApplicationPkcs7SignatureEntity signature = new ApplicationPkcs7SignatureEntity(data, signer, signatureCharSet, signatureTransferEncoding, false);
        this.addPart(signature);
    }

    protected MultipartSignedEntity(String boundary, boolean isMainBody) {
        this.boundary = boundary;
        this.isMainBody = isMainBody;
    }

    public boolean isValid() {
        MimeEntity signedEntity = this.getSignedDataEntity();
        ApplicationPkcs7SignatureEntity applicationPkcs7SignatureEntity = this.getSignatureEntity();
        if (signedEntity == null || applicationPkcs7SignatureEntity == null) {
            return false;
        }
        try {
            ByteArrayOutputStream outstream = new ByteArrayOutputStream();
            signedEntity.writeTo(outstream);
            CMSProcessableByteArray signedContent = new CMSProcessableByteArray(outstream.toByteArray());
            byte[] signature = applicationPkcs7SignatureEntity.getSignature();
            ByteArrayInputStream is = new ByteArrayInputStream(signature);
            CMSSignedData signedData = new CMSSignedData((CMSProcessable)signedContent, (InputStream)is);
            Store store = signedData.getCertificates();
            SignerInformationStore signers = signedData.getSignerInfos();
            for (SignerInformation signer : signers.getSigners()) {
                Collection certCollection = store.getMatches((Selector)signer.getSID());
                X509CertificateHolder certHolder = (X509CertificateHolder)certCollection.iterator().next();
                X509Certificate cert = new JcaX509CertificateConverter().setProvider("BC").getCertificate(certHolder);
                if (signer.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider("BC").build(cert))) continue;
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public MimeEntity getSignedDataEntity() {
        if (this.getPartCount() > 0) {
            return this.getPart(0);
        }
        return null;
    }

    public ApplicationPkcs7SignatureEntity getSignatureEntity() {
        if (this.getPartCount() > 1 && this.getPart(1) instanceof ApplicationPkcs7SignatureEntity) {
            return (ApplicationPkcs7SignatureEntity)this.getPart(1);
        }
        return null;
    }
}

