/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.as2.api.entity;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.camel.component.as2.api.entity.AS2MessageDispositionNotificationEntity;
import org.apache.camel.component.as2.api.entity.ApplicationEDIEntity;
import org.apache.camel.component.as2.api.entity.ApplicationPkcs7MimeCompressedDataEntity;
import org.apache.camel.component.as2.api.entity.ApplicationPkcs7MimeEnvelopedDataEntity;
import org.apache.camel.component.as2.api.entity.ApplicationPkcs7SignatureEntity;
import org.apache.camel.component.as2.api.entity.DispositionNotificationMultipartReportEntity;
import org.apache.camel.component.as2.api.entity.MimeEntity;
import org.apache.camel.component.as2.api.entity.MultipartSignedEntity;
import org.apache.camel.component.as2.api.entity.TextPlainEntity;
import org.apache.camel.component.as2.api.io.AS2SessionInputBuffer;
import org.apache.camel.component.as2.api.util.AS2HeaderUtils;
import org.apache.camel.component.as2.api.util.ContentTypeUtils;
import org.apache.camel.component.as2.api.util.DispositionNotificationContentUtils;
import org.apache.camel.component.as2.api.util.EntityUtils;
import org.apache.camel.component.as2.api.util.HttpMessageUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpMessage;
import org.apache.http.NameValuePair;
import org.apache.http.ParseException;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.io.AbstractMessageParser;
import org.apache.http.impl.io.HttpTransportMetricsImpl;
import org.apache.http.io.SessionInputBuffer;
import org.apache.http.message.BasicLineParser;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.message.LineParser;
import org.apache.http.message.ParserCursor;
import org.apache.http.util.Args;
import org.apache.http.util.CharArrayBuffer;
import org.bouncycastle.cms.CMSCompressedData;
import org.bouncycastle.cms.CMSEnvelopedData;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.Recipient;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.cms.RecipientInformationStore;
import org.bouncycastle.cms.jcajce.JceKeyTransEnvelopedRecipient;
import org.bouncycastle.cms.jcajce.ZlibExpanderProvider;
import org.bouncycastle.operator.InputExpanderProvider;

public final class EntityParser {
    private static final int DEFAULT_BUFFER_SIZE = 8192;

    private EntityParser() {
    }

    public static boolean isBoundaryCloseDelimiter(CharArrayBuffer buffer, ParserCursor cursor, String boundary) {
        Args.notNull((Object)buffer, (String)"Buffer");
        Args.notNull((Object)boundary, (String)"Boundary");
        String boundaryCloseDelimiter = "--" + boundary + "--";
        if (cursor == null) {
            cursor = new ParserCursor(0, boundaryCloseDelimiter.length());
        }
        int indexFrom = cursor.getPos();
        int indexTo = cursor.getUpperBound();
        if (indexFrom + boundaryCloseDelimiter.length() > indexTo) {
            return false;
        }
        for (int i = indexFrom; i < indexTo; ++i) {
            if (buffer.charAt(i) == boundaryCloseDelimiter.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean isBoundaryDelimiter(CharArrayBuffer buffer, ParserCursor cursor, String boundary) {
        Args.notNull((Object)buffer, (String)"Buffer");
        Args.notNull((Object)boundary, (String)"Boundary");
        String boundaryDelimiter = "--" + boundary;
        if (cursor == null) {
            cursor = new ParserCursor(0, boundaryDelimiter.length());
        }
        int indexFrom = cursor.getPos();
        int indexTo = cursor.getUpperBound();
        if (indexFrom + boundaryDelimiter.length() > indexTo) {
            return false;
        }
        for (int i = indexFrom; i < indexTo; ++i) {
            if (buffer.charAt(i) == boundaryDelimiter.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static void skipPreambleAndStartBoundary(AS2SessionInputBuffer inbuffer, String boundary) throws HttpException {
        boolean foundStartBoundary;
        try {
            foundStartBoundary = false;
            CharArrayBuffer lineBuffer = new CharArrayBuffer(1024);
            while (inbuffer.readLine(lineBuffer) != -1) {
                ParserCursor cursor = new ParserCursor(0, lineBuffer.length());
                if (EntityParser.isBoundaryDelimiter(lineBuffer, cursor, boundary)) {
                    foundStartBoundary = true;
                    break;
                }
                lineBuffer.clear();
            }
        }
        catch (Exception e) {
            throw new HttpException("Failed to read start boundary for body part", (Throwable)e);
        }
        if (!foundStartBoundary) {
            throw new HttpException("Failed to find start boundary for body part");
        }
    }

    public static void skipToBoundary(AS2SessionInputBuffer inbuffer, String boundary) throws HttpException {
        boolean foundEndBoundary;
        try {
            foundEndBoundary = false;
            CharArrayBuffer lineBuffer = new CharArrayBuffer(1024);
            while (inbuffer.readLine(lineBuffer) != -1) {
                ParserCursor cursor = new ParserCursor(0, lineBuffer.length());
                if (EntityParser.isBoundaryDelimiter(lineBuffer, cursor, boundary)) {
                    foundEndBoundary = true;
                    break;
                }
                lineBuffer.clear();
            }
        }
        catch (Exception e) {
            throw new HttpException("Failed to read start boundary for body part", (Throwable)e);
        }
        if (!foundEndBoundary && boundary != null) {
            throw new HttpException("Failed to find start boundary for body part");
        }
    }

    public static MimeEntity parseCompressedEntity(byte[] compressedData, InputExpanderProvider expanderProvider) throws HttpException {
        byte[] uncompressedContent = EntityParser.uncompressData(compressedData, expanderProvider);
        return EntityParser.parseEntity(uncompressedContent);
    }

    public static MimeEntity parseEnvelopedEntity(byte[] envelopedContent, PrivateKey privateKey) throws HttpException {
        byte[] decryptedContent = EntityParser.decryptData(envelopedContent, privateKey);
        return EntityParser.parseEntity(decryptedContent);
    }

    public static MimeEntity parseEntity(byte[] content) throws HttpException {
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(content);
            AS2SessionInputBuffer inbuffer = new AS2SessionInputBuffer(new HttpTransportMetricsImpl(), 8192);
            inbuffer.bind(is);
            Header[] headers = AbstractMessageParser.parseHeaders((SessionInputBuffer)inbuffer, (int)-1, (int)-1, (LineParser)BasicLineParser.INSTANCE, new ArrayList());
            ContentType entityContentType = null;
            String entityContentTransferEncoding = null;
            block10: for (Header header : headers) {
                switch (header.getName()) {
                    case "Content-Type": {
                        entityContentType = ContentType.parse((String)header.getValue());
                        continue block10;
                    }
                    case "Content-Transfer-Encoding": {
                        entityContentTransferEncoding = header.getValue();
                        continue block10;
                    }
                    default: {
                        continue block10;
                    }
                }
            }
            if (entityContentType == null) {
                throw new HttpException("Failed to find Content-Type header in enveloped entity");
            }
            MimeEntity entity = EntityParser.parseEntityBody(inbuffer, null, entityContentType, entityContentTransferEncoding, headers);
            entity.removeAllHeaders();
            entity.setHeaders(headers);
            return entity;
        }
        catch (Exception e) {
            throw new HttpException("Failed to parse entity", (Throwable)e);
        }
    }

    public static byte[] uncompressData(byte[] compressedData, InputExpanderProvider expanderProvider) throws HttpException {
        try {
            CMSCompressedData cmsCompressedData = new CMSCompressedData(compressedData);
            return cmsCompressedData.getContent(expanderProvider);
        }
        catch (CMSException e) {
            throw new HttpException("Failed to decompress data", (Throwable)e);
        }
    }

    public static byte[] decryptData(byte[] encryptedData, PrivateKey privateKey) throws HttpException {
        try {
            CMSEnvelopedData cmsEnvelopedData = new CMSEnvelopedData(encryptedData);
            RecipientInformationStore recipientsInformationStore = cmsEnvelopedData.getRecipientInfos();
            Collection recipients = recipientsInformationStore.getRecipients();
            Iterator it = recipients.iterator();
            if (it.hasNext()) {
                JceKeyTransEnvelopedRecipient recipient = new JceKeyTransEnvelopedRecipient(privateKey);
                RecipientInformation recipientInfo = (RecipientInformation)it.next();
                return recipientInfo.getContent((Recipient)recipient);
            }
        }
        catch (CMSException e) {
            throw new HttpException("Failed to decrypt data", (Throwable)e);
        }
        throw new HttpException("Failed to decrypt data: bno recipeint information");
    }

    private static void parseApplicationPkcs7MimeCompressedEntity(HttpMessage message, AS2SessionInputBuffer inBuffer, ContentType contentType, String contentTransferEncoding) throws HttpException {
        ApplicationPkcs7MimeCompressedDataEntity applicationPkcs7MimeCompressedDataEntity = null;
        Args.notNull((Object)message, (String)"message");
        Args.notNull((Object)inBuffer, (String)"inBuffer");
        HttpEntity entity = (HttpEntity)Args.notNull((Object)EntityUtils.getMessageEntity(message), (String)"message entity");
        if (entity instanceof ApplicationPkcs7MimeCompressedDataEntity) {
            return;
        }
        Args.check((boolean)entity.isStreaming(), (String)"Message entity can not be parsed: entity is not streaming");
        try {
            applicationPkcs7MimeCompressedDataEntity = EntityParser.parseApplicationPkcs7MimeCompressedDataEntityBody(inBuffer, null, contentType, contentTransferEncoding);
            applicationPkcs7MimeCompressedDataEntity.setMainBody(true);
            EntityUtils.setMessageEntity(message, (HttpEntity)applicationPkcs7MimeCompressedDataEntity);
        }
        catch (Exception e) {
            throw new HttpException("Failed to parse entity content", (Throwable)e);
        }
    }

    private static void parseApplicationPkcs7MimeEnvelopedEntity(HttpMessage message, AS2SessionInputBuffer inBuffer, ContentType contentType, String contentTransferEncoding) throws HttpException {
        ApplicationPkcs7MimeEnvelopedDataEntity applicationPkcs7MimeEnvelopedDataEntity = null;
        Args.notNull((Object)message, (String)"message");
        Args.notNull((Object)inBuffer, (String)"inBuffer");
        HttpEntity entity = (HttpEntity)Args.notNull((Object)EntityUtils.getMessageEntity(message), (String)"message entity");
        if (entity instanceof ApplicationPkcs7MimeCompressedDataEntity) {
            return;
        }
        Args.check((boolean)entity.isStreaming(), (String)"Message entity can not be parsed: entity is not streaming");
        try {
            applicationPkcs7MimeEnvelopedDataEntity = EntityParser.parseApplicationPkcs7MimeEnvelopedDataEntityBody(inBuffer, null, contentType, contentTransferEncoding);
            applicationPkcs7MimeEnvelopedDataEntity.setMainBody(true);
            EntityUtils.setMessageEntity(message, (HttpEntity)applicationPkcs7MimeEnvelopedDataEntity);
        }
        catch (Exception e) {
            throw new HttpException("Failed to parse entity content", (Throwable)e);
        }
    }

    private static void parseMultipartSignedEntity(HttpMessage message, AS2SessionInputBuffer inBuffer, String boundary, String charsetName, String contentTransferEncoding) throws HttpException {
        MultipartSignedEntity multipartSignedEntity = null;
        Args.notNull((Object)message, (String)"message");
        Args.notNull((Object)inBuffer, (String)"inBuffer");
        Args.notNull((Object)boundary, (String)"boundary");
        Args.notNull((Object)charsetName, (String)"charsetName");
        HttpEntity entity = (HttpEntity)Args.notNull((Object)EntityUtils.getMessageEntity(message), (String)"message entity");
        if (entity instanceof MultipartSignedEntity) {
            return;
        }
        Args.check((boolean)entity.isStreaming(), (String)"Message entity can not be parsed: entity is not streaming");
        try {
            String micalg = HttpMessageUtils.getParameterValue(message, "Content-Type", "micalg");
            if (micalg == null) {
                throw new HttpException("Failed to retrieve 'micalg' parameter from content type header");
            }
            multipartSignedEntity = EntityParser.parseMultipartSignedEntityBody(inBuffer, boundary, micalg, charsetName, contentTransferEncoding);
            multipartSignedEntity.setMainBody(true);
            EntityUtils.setMessageEntity(message, (HttpEntity)multipartSignedEntity);
        }
        catch (HttpException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HttpException("Failed to parse entity content", (Throwable)e);
        }
    }

    private static void parseApplicationEDIEntity(HttpMessage message, AS2SessionInputBuffer inBuffer, ContentType contentType, String contentTransferEncoding) throws HttpException {
        ApplicationEDIEntity applicationEDIEntity = null;
        Args.notNull((Object)message, (String)"message");
        Args.notNull((Object)inBuffer, (String)"inBuffer");
        HttpEntity entity = (HttpEntity)Args.notNull((Object)EntityUtils.getMessageEntity(message), (String)"message entity");
        if (entity instanceof ApplicationEDIEntity) {
            return;
        }
        Args.check((boolean)entity.isStreaming(), (String)"Message entity can not be parsed: entity is not streaming");
        try {
            applicationEDIEntity = EntityParser.parseEDIEntityBody(inBuffer, null, contentType, contentTransferEncoding);
            applicationEDIEntity.setMainBody(true);
            EntityUtils.setMessageEntity(message, (HttpEntity)applicationEDIEntity);
        }
        catch (Exception e) {
            throw new HttpException("Failed to parse entity content", (Throwable)e);
        }
    }

    private static void parseMessageDispositionNotificationReportEntity(HttpMessage message, AS2SessionInputBuffer inBuffer, String boundary, String charsetName, String contentTransferEncoding) throws HttpException {
        DispositionNotificationMultipartReportEntity dispositionNotificationMultipartReportEntity = null;
        Args.notNull((Object)message, (String)"message");
        Args.notNull((Object)inBuffer, (String)"inBuffer");
        Args.notNull((Object)boundary, (String)"boundary");
        Args.notNull((Object)charsetName, (String)"charsetName");
        HttpEntity entity = (HttpEntity)Args.notNull((Object)EntityUtils.getMessageEntity(message), (String)"message entity");
        if (entity instanceof DispositionNotificationMultipartReportEntity) {
            return;
        }
        Args.check((boolean)entity.isStreaming(), (String)"Message entity can not be parsed: entity is not streaming");
        try {
            dispositionNotificationMultipartReportEntity = EntityParser.parseMultipartReportEntityBody(inBuffer, boundary, charsetName, contentTransferEncoding);
            EntityUtils.setMessageEntity(message, (HttpEntity)dispositionNotificationMultipartReportEntity);
        }
        catch (Exception e) {
            throw new HttpException("Failed to parse entity content", (Throwable)e);
        }
    }

    public static void parseAS2MessageEntity(HttpMessage message) throws HttpException {
        if (EntityUtils.hasEntity(message)) {
            HttpEntity entity = (HttpEntity)Args.notNull((Object)EntityUtils.getMessageEntity(message), (String)"message entity");
            if (entity instanceof MimeEntity) {
                return;
            }
            try {
                String contentTypeStr = HttpMessageUtils.getHeaderValue(message, "Content-Type");
                ContentType contentType = ContentType.parse((String)contentTypeStr);
                String charsetName = "US-ASCII";
                Charset charset = contentType.getCharset();
                if (charset != null) {
                    charsetName = charset.name();
                }
                String boundary = HttpMessageUtils.getParameterValue(message, "Content-Type", "boundary");
                String contentTransferEncoding = HttpMessageUtils.getHeaderValue(message, "Content-Transfer-Encoding");
                AS2SessionInputBuffer inBuffer = new AS2SessionInputBuffer(new HttpTransportMetricsImpl(), 8192);
                inBuffer.bind(entity.getContent());
                block9 : switch (contentType.getMimeType().toLowerCase()) {
                    case "application/edifact": 
                    case "application/edi-x12": 
                    case "application/edi-consent": {
                        EntityParser.parseApplicationEDIEntity(message, inBuffer, contentType, contentTransferEncoding);
                        break;
                    }
                    case "multipart/signed": {
                        EntityParser.parseMultipartSignedEntity(message, inBuffer, boundary, charsetName, contentTransferEncoding);
                        break;
                    }
                    case "application/pkcs7-mime": {
                        switch (contentType.getParameter("smime-type")) {
                            case "compressed-data": {
                                EntityParser.parseApplicationPkcs7MimeCompressedEntity(message, inBuffer, contentType, contentTransferEncoding);
                                break block9;
                            }
                            case "enveloped-data": {
                                EntityParser.parseApplicationPkcs7MimeEnvelopedEntity(message, inBuffer, contentType, contentTransferEncoding);
                                break block9;
                            }
                        }
                        break;
                    }
                    case "multipart/report": {
                        EntityParser.parseMessageDispositionNotificationReportEntity(message, inBuffer, boundary, charsetName, contentTransferEncoding);
                        break;
                    }
                }
            }
            catch (HttpException e) {
                throw e;
            }
            catch (Exception e) {
                throw new HttpException("Failed to parse entity content", (Throwable)e);
            }
        }
    }

    public static MultipartSignedEntity parseMultipartSignedEntityBody(AS2SessionInputBuffer inbuffer, String boundary, String micalg, String charsetName, String contentTransferEncoding) throws ParseException {
        CharsetDecoder previousDecoder = inbuffer.getCharsetDecoder();
        try {
            if (charsetName == null) {
                charsetName = "US-ASCII";
            }
            Charset charset = Charset.forName(charsetName);
            CharsetDecoder charsetDecoder = charset.newDecoder();
            inbuffer.setCharsetDecoder(charsetDecoder);
            MultipartSignedEntity multipartSignedEntity = new MultipartSignedEntity(boundary, false);
            EntityParser.skipPreambleAndStartBoundary(inbuffer, boundary);
            Header[] headers = AbstractMessageParser.parseHeaders((SessionInputBuffer)inbuffer, (int)-1, (int)-1, (LineParser)BasicLineParser.INSTANCE, new ArrayList());
            ContentType signedEntityContentType = null;
            String signedEntityContentTransferEncoding = null;
            block21: for (Header header : headers) {
                switch (header.getName()) {
                    case "Content-Type": {
                        signedEntityContentType = ContentType.parse((String)header.getValue());
                        continue block21;
                    }
                    case "Content-Transfer-Encoding": {
                        signedEntityContentTransferEncoding = header.getValue();
                        continue block21;
                    }
                    default: {
                        continue block21;
                    }
                }
            }
            if (signedEntityContentType == null) {
                throw new HttpException("Failed to find Content-Type header in signed entity body part");
            }
            MimeEntity signedEntity = EntityParser.parseEntityBody(inbuffer, boundary, signedEntityContentType, signedEntityContentTransferEncoding, headers);
            signedEntity.removeAllHeaders();
            signedEntity.setHeaders(headers);
            multipartSignedEntity.addPart(signedEntity);
            headers = AbstractMessageParser.parseHeaders((SessionInputBuffer)inbuffer, (int)-1, (int)-1, (LineParser)BasicLineParser.INSTANCE, new ArrayList());
            ContentType signatureContentType = null;
            String signatureContentTransferEncoding = null;
            block22: for (Header header : headers) {
                switch (header.getName()) {
                    case "Content-Type": {
                        signatureContentType = ContentType.parse((String)header.getValue());
                        continue block22;
                    }
                    case "Content-Transfer-Encoding": {
                        signatureContentTransferEncoding = header.getValue();
                        continue block22;
                    }
                    default: {
                        continue block22;
                    }
                }
            }
            if (signatureContentType == null) {
                throw new HttpException("Failed to find Content-Type header in signature body part");
            }
            if (!ContentTypeUtils.isPkcs7SignatureType(signatureContentType)) {
                throw new HttpException("Invalid content type '" + signatureContentType.getMimeType() + "' for signature body part");
            }
            ApplicationPkcs7SignatureEntity applicationPkcs7SignatureEntity = EntityParser.parseApplicationPkcs7SignatureEntityBody(inbuffer, boundary, signatureContentType, signatureContentTransferEncoding);
            applicationPkcs7SignatureEntity.removeAllHeaders();
            applicationPkcs7SignatureEntity.setHeaders(headers);
            multipartSignedEntity.addPart(applicationPkcs7SignatureEntity);
            NameValuePair[] parameters = new NameValuePair[]{new BasicNameValuePair("protocol", "application/pkcs7-signature"), new BasicNameValuePair("boundary", boundary), new BasicNameValuePair("micalg", micalg), new BasicNameValuePair("charset", charsetName)};
            ContentType contentType = ContentType.create((String)"multipart/signed", (NameValuePair[])parameters);
            multipartSignedEntity.setContentType(contentType);
            multipartSignedEntity.setContentTransferEncoding(contentTransferEncoding);
            MultipartSignedEntity multipartSignedEntity2 = multipartSignedEntity;
            return multipartSignedEntity2;
        }
        catch (Exception e) {
            ParseException parseException = new ParseException("failed to parse text entity");
            parseException.initCause((Throwable)e);
            throw parseException;
        }
        finally {
            inbuffer.setCharsetDecoder(previousDecoder);
        }
    }

    public static DispositionNotificationMultipartReportEntity parseMultipartReportEntityBody(AS2SessionInputBuffer inbuffer, String boundary, String charsetName, String contentTransferEncoding) throws ParseException {
        CharsetDecoder previousDecoder = inbuffer.getCharsetDecoder();
        try {
            if (charsetName == null) {
                charsetName = "US-ASCII";
            }
            Charset charset = Charset.forName(charsetName);
            CharsetDecoder charsetDecoder = charset.newDecoder();
            inbuffer.setCharsetDecoder(charsetDecoder);
            DispositionNotificationMultipartReportEntity dispositionNotificationMultipartReportEntity = new DispositionNotificationMultipartReportEntity(boundary, false);
            EntityParser.skipPreambleAndStartBoundary(inbuffer, boundary);
            Header[] headers = AbstractMessageParser.parseHeaders((SessionInputBuffer)inbuffer, (int)-1, (int)-1, (LineParser)BasicLineParser.INSTANCE, new ArrayList());
            ContentType textReportContentType = null;
            String textReportContentTransferEncoding = null;
            block21: for (Header header : headers) {
                switch (header.getName()) {
                    case "Content-Type": {
                        textReportContentType = ContentType.parse((String)header.getValue());
                        continue block21;
                    }
                    case "Content-Transfer-Encoding": {
                        textReportContentTransferEncoding = header.getValue();
                        continue block21;
                    }
                    default: {
                        continue block21;
                    }
                }
            }
            if (textReportContentType == null) {
                throw new HttpException("Failed to find Content-Type header in EDI message body part");
            }
            if (!textReportContentType.getMimeType().equalsIgnoreCase("text/plain")) {
                throw new HttpException("Invalid content type '" + textReportContentType.getMimeType() + "' for first body part of disposition notification");
            }
            String textReportCharsetName = textReportContentType.getCharset() == null ? "US-ASCII" : textReportContentType.getCharset().name();
            TextPlainEntity textReportEntity = EntityParser.parseTextPlainEntityBody(inbuffer, boundary, textReportCharsetName, textReportContentTransferEncoding);
            textReportEntity.setHeaders(headers);
            dispositionNotificationMultipartReportEntity.addPart(textReportEntity);
            headers = AbstractMessageParser.parseHeaders((SessionInputBuffer)inbuffer, (int)-1, (int)-1, (LineParser)BasicLineParser.INSTANCE, new ArrayList());
            ContentType dispositionNotificationContentType = null;
            String dispositionNotificationContentTransferEncoding = null;
            block22: for (Header header : headers) {
                switch (header.getName()) {
                    case "Content-Type": {
                        dispositionNotificationContentType = ContentType.parse((String)header.getValue());
                        continue block22;
                    }
                    case "Content-Transfer-Encoding": {
                        dispositionNotificationContentTransferEncoding = header.getValue();
                        continue block22;
                    }
                    default: {
                        continue block22;
                    }
                }
            }
            if (dispositionNotificationContentType == null) {
                throw new HttpException("Failed to find Content-Type header in body part");
            }
            if (!dispositionNotificationContentType.getMimeType().equalsIgnoreCase("message/disposition-notification")) {
                throw new HttpException("Invalid content type '" + dispositionNotificationContentType.getMimeType() + "' for second body part of disposition notification");
            }
            String dispositionNotificationCharsetName = dispositionNotificationContentType.getCharset() == null ? "US-ASCII" : dispositionNotificationContentType.getCharset().name();
            AS2MessageDispositionNotificationEntity messageDispositionNotificationEntity = EntityParser.parseMessageDispositionNotificationEntityBody(inbuffer, boundary, dispositionNotificationCharsetName, dispositionNotificationContentTransferEncoding);
            messageDispositionNotificationEntity.setHeaders(headers);
            dispositionNotificationMultipartReportEntity.addPart(messageDispositionNotificationEntity);
            dispositionNotificationMultipartReportEntity.setContentTransferEncoding(contentTransferEncoding);
            DispositionNotificationMultipartReportEntity dispositionNotificationMultipartReportEntity2 = dispositionNotificationMultipartReportEntity;
            return dispositionNotificationMultipartReportEntity2;
        }
        catch (Exception e) {
            ParseException parseException = new ParseException("failed to parse text entity");
            parseException.initCause((Throwable)e);
            throw parseException;
        }
        finally {
            inbuffer.setCharsetDecoder(previousDecoder);
        }
    }

    public static TextPlainEntity parseTextPlainEntityBody(AS2SessionInputBuffer inbuffer, String boundary, String charsetName, String contentTransferEncoding) throws ParseException {
        CharsetDecoder previousDecoder = inbuffer.getCharsetDecoder();
        try {
            if (charsetName == null) {
                charsetName = "US-ASCII";
            }
            Charset charset = Charset.forName(charsetName);
            CharsetDecoder charsetDecoder = charset.newDecoder();
            inbuffer.setCharsetDecoder(charsetDecoder);
            String text = EntityParser.parseBodyPartText(inbuffer, boundary);
            if (contentTransferEncoding != null) {
                text = EntityUtils.decode(text, charset, contentTransferEncoding);
            }
            TextPlainEntity textPlainEntity = new TextPlainEntity(text, charsetName, contentTransferEncoding, false);
            return textPlainEntity;
        }
        catch (Exception e) {
            ParseException parseException = new ParseException("failed to parse text entity");
            parseException.initCause((Throwable)e);
            throw parseException;
        }
        finally {
            inbuffer.setCharsetDecoder(previousDecoder);
        }
    }

    public static AS2MessageDispositionNotificationEntity parseMessageDispositionNotificationEntityBody(AS2SessionInputBuffer inbuffer, String boundary, String charsetName, String contentTransferEncoding) throws ParseException {
        CharsetDecoder previousDecoder = inbuffer.getCharsetDecoder();
        try {
            if (charsetName == null) {
                charsetName = "US-ASCII";
            }
            Charset charset = Charset.forName(charsetName);
            CharsetDecoder charsetDecoder = charset.newDecoder();
            inbuffer.setCharsetDecoder(charsetDecoder);
            List<CharArrayBuffer> dispositionNotificationFields = EntityParser.parseBodyPartFields(inbuffer, boundary, (LineParser)BasicLineParser.INSTANCE, new ArrayList<CharArrayBuffer>());
            AS2MessageDispositionNotificationEntity as2MessageDispositionNotificationEntity = DispositionNotificationContentUtils.parseDispositionNotification(dispositionNotificationFields);
            ContentType contentType = ContentType.create((String)"message/disposition-notification", (Charset)charset);
            as2MessageDispositionNotificationEntity.setContentType(contentType);
            AS2MessageDispositionNotificationEntity aS2MessageDispositionNotificationEntity = as2MessageDispositionNotificationEntity;
            return aS2MessageDispositionNotificationEntity;
        }
        catch (Exception e) {
            ParseException parseException = new ParseException("failed to parse MDN entity");
            parseException.initCause((Throwable)e);
            throw parseException;
        }
        finally {
            inbuffer.setCharsetDecoder(previousDecoder);
        }
    }

    public static MimeEntity parseEntityBody(AS2SessionInputBuffer inbuffer, String boundary, ContentType entityContentType, String contentTransferEncoding, Header[] headers) throws ParseException {
        CharsetDecoder previousDecoder = inbuffer.getCharsetDecoder();
        try {
            Charset charset = entityContentType.getCharset();
            if (charset == null) {
                charset = Charset.forName("US-ASCII");
            }
            CharsetDecoder charsetDecoder = charset.newDecoder();
            inbuffer.setCharsetDecoder(charsetDecoder);
            MimeEntity entity = null;
            block13 : switch (entityContentType.getMimeType().toLowerCase()) {
                case "application/edifact": 
                case "application/edi-x12": 
                case "application/edi-consent": {
                    entity = EntityParser.parseEDIEntityBody(inbuffer, boundary, entityContentType, contentTransferEncoding);
                    break;
                }
                case "multipart/signed": {
                    String multipartSignedBoundary = AS2HeaderUtils.getParameterValue(headers, "Content-Type", "boundary");
                    String micalg = AS2HeaderUtils.getParameterValue(headers, "Content-Type", "micalg");
                    entity = EntityParser.parseMultipartSignedEntityBody(inbuffer, multipartSignedBoundary, micalg, charset.name(), contentTransferEncoding);
                    EntityParser.skipToBoundary(inbuffer, boundary);
                    break;
                }
                case "message/disposition-notification": {
                    entity = EntityParser.parseMessageDispositionNotificationEntityBody(inbuffer, boundary, charset.name(), contentTransferEncoding);
                    break;
                }
                case "multipart/report": {
                    String multipartReportBoundary = AS2HeaderUtils.getParameterValue(headers, "Content-Type", "boundary");
                    entity = EntityParser.parseMultipartReportEntityBody(inbuffer, multipartReportBoundary, charset.name(), contentTransferEncoding);
                    EntityParser.skipToBoundary(inbuffer, boundary);
                    break;
                }
                case "text/plain": {
                    entity = EntityParser.parseTextPlainEntityBody(inbuffer, boundary, charset.name(), contentTransferEncoding);
                    break;
                }
                case "application/pkcs7-signature": {
                    entity = EntityParser.parseApplicationPkcs7SignatureEntityBody(inbuffer, boundary, entityContentType, contentTransferEncoding);
                    break;
                }
                case "application/pkcs7-mime": {
                    switch (entityContentType.getParameter("smime-type")) {
                        case "compressed-data": {
                            entity = EntityParser.parseApplicationPkcs7MimeCompressedDataEntityBody(inbuffer, boundary, entityContentType, contentTransferEncoding);
                            break block13;
                        }
                        case "enveloped-data": {
                            entity = EntityParser.parseApplicationPkcs7MimeEnvelopedDataEntityBody(inbuffer, boundary, entityContentType, contentTransferEncoding);
                            break block13;
                        }
                    }
                    break;
                }
            }
            String string = entity;
            return string;
        }
        catch (Exception e) {
            ParseException parseException = new ParseException("failed to parse EDI entity");
            parseException.initCause((Throwable)e);
            throw parseException;
        }
        finally {
            inbuffer.setCharsetDecoder(previousDecoder);
        }
    }

    public static ApplicationEDIEntity parseEDIEntityBody(AS2SessionInputBuffer inbuffer, String boundary, ContentType ediMessageContentType, String contentTransferEncoding) throws ParseException {
        CharsetDecoder previousDecoder = inbuffer.getCharsetDecoder();
        try {
            ApplicationEDIEntity applicationEDIEntity;
            Charset charset = ediMessageContentType.getCharset();
            if (charset == null) {
                charset = Charset.forName("US-ASCII");
            }
            CharsetDecoder charsetDecoder = charset.newDecoder();
            inbuffer.setCharsetDecoder(charsetDecoder);
            String ediMessageBodyPartContent = EntityParser.parseBodyPartText(inbuffer, boundary);
            if (contentTransferEncoding != null) {
                ediMessageBodyPartContent = EntityUtils.decode(ediMessageBodyPartContent, charset, contentTransferEncoding);
            }
            ApplicationEDIEntity applicationEDIEntity2 = applicationEDIEntity = EntityUtils.createEDIEntity(ediMessageBodyPartContent, ediMessageContentType, contentTransferEncoding, false);
            return applicationEDIEntity2;
        }
        catch (Exception e) {
            ParseException parseException = new ParseException("failed to parse EDI entity");
            parseException.initCause((Throwable)e);
            throw parseException;
        }
        finally {
            inbuffer.setCharsetDecoder(previousDecoder);
        }
    }

    public static ApplicationPkcs7SignatureEntity parseApplicationPkcs7SignatureEntityBody(AS2SessionInputBuffer inbuffer, String boundary, ContentType contentType, String contentTransferEncoding) throws ParseException {
        CharsetDecoder previousDecoder = inbuffer.getCharsetDecoder();
        try {
            ApplicationPkcs7SignatureEntity applicationPkcs7SignatureEntity;
            Charset charset = contentType.getCharset();
            if (charset == null) {
                charset = Charset.forName("US-ASCII");
            }
            CharsetDecoder charsetDecoder = charset.newDecoder();
            inbuffer.setCharsetDecoder(charsetDecoder);
            String pkcs7SignatureBodyContent = EntityParser.parseBodyPartText(inbuffer, boundary);
            byte[] signature = EntityUtils.decode(pkcs7SignatureBodyContent.getBytes(charset), contentTransferEncoding);
            String charsetName = charset.toString();
            ApplicationPkcs7SignatureEntity applicationPkcs7SignatureEntity2 = applicationPkcs7SignatureEntity = new ApplicationPkcs7SignatureEntity(signature, charsetName, contentTransferEncoding, false);
            return applicationPkcs7SignatureEntity2;
        }
        catch (Exception e) {
            ParseException parseException = new ParseException("failed to parse PKCS7 Signature entity");
            parseException.initCause((Throwable)e);
            throw parseException;
        }
        finally {
            inbuffer.setCharsetDecoder(previousDecoder);
        }
    }

    public static ApplicationPkcs7MimeEnvelopedDataEntity parseApplicationPkcs7MimeEnvelopedDataEntityBody(AS2SessionInputBuffer inbuffer, String boundary, ContentType contentType, String contentTransferEncoding) throws ParseException {
        CharsetDecoder previousDecoder = inbuffer.getCharsetDecoder();
        try {
            ApplicationPkcs7MimeEnvelopedDataEntity applicationPkcs7MimeEntity;
            Charset charset = contentType.getCharset();
            if (charset == null) {
                charset = Charset.forName("US-ASCII");
            }
            CharsetDecoder charsetDecoder = charset.newDecoder();
            inbuffer.setCharsetDecoder(charsetDecoder);
            String pkcs7EncryptedBodyContent = EntityParser.parseBodyPartText(inbuffer, boundary);
            byte[] encryptedContent = EntityUtils.decode(pkcs7EncryptedBodyContent.getBytes(charset), contentTransferEncoding);
            ApplicationPkcs7MimeEnvelopedDataEntity applicationPkcs7MimeEnvelopedDataEntity = applicationPkcs7MimeEntity = new ApplicationPkcs7MimeEnvelopedDataEntity(encryptedContent, contentTransferEncoding, false);
            return applicationPkcs7MimeEnvelopedDataEntity;
        }
        catch (Exception e) {
            ParseException parseException = new ParseException("failed to parse PKCS7 Mime entity");
            parseException.initCause((Throwable)e);
            throw parseException;
        }
        finally {
            inbuffer.setCharsetDecoder(previousDecoder);
        }
    }

    public static ApplicationPkcs7MimeCompressedDataEntity parseApplicationPkcs7MimeCompressedDataEntityBody(AS2SessionInputBuffer inbuffer, String boundary, ContentType contentType, String contentTransferEncoding) throws ParseException {
        CharsetDecoder previousDecoder = inbuffer.getCharsetDecoder();
        try {
            ApplicationPkcs7MimeCompressedDataEntity applicationPkcs7MimeEntity;
            Charset charset = contentType.getCharset();
            if (charset == null) {
                charset = Charset.forName("US-ASCII");
            }
            CharsetDecoder charsetDecoder = charset.newDecoder();
            inbuffer.setCharsetDecoder(charsetDecoder);
            String pkcs7CompressedBodyContent = EntityParser.parseBodyPartText(inbuffer, boundary);
            byte[] compressedContent = EntityUtils.decode(pkcs7CompressedBodyContent.getBytes(charset), contentTransferEncoding);
            ApplicationPkcs7MimeCompressedDataEntity applicationPkcs7MimeCompressedDataEntity = applicationPkcs7MimeEntity = new ApplicationPkcs7MimeCompressedDataEntity(compressedContent, contentTransferEncoding, false);
            return applicationPkcs7MimeCompressedDataEntity;
        }
        catch (Exception e) {
            ParseException parseException = new ParseException("failed to parse PKCS7 Mime entity");
            parseException.initCause((Throwable)e);
            throw parseException;
        }
        finally {
            inbuffer.setCharsetDecoder(previousDecoder);
        }
    }

    public static String parseBodyPartText(AS2SessionInputBuffer inbuffer, String boundary) throws IOException {
        int l;
        CharArrayBuffer buffer = new CharArrayBuffer(8192);
        CharArrayBuffer line = new CharArrayBuffer(8192);
        while ((l = inbuffer.readLine(line)) != -1) {
            if (boundary != null && EntityParser.isBoundaryDelimiter(line, null, boundary)) {
                int length = buffer.length();
                buffer.setLength(length - 2);
                break;
            }
            buffer.append(line);
            if (inbuffer.isLastLineReadTerminatedByLineFeed()) {
                buffer.append("\r\n");
            }
            line.clear();
        }
        return buffer.toString();
    }

    public static List<CharArrayBuffer> parseBodyPartFields(AS2SessionInputBuffer inbuffer, String boundary, LineParser parser, List<CharArrayBuffer> fields) throws IOException {
        Args.notNull((Object)parser, (String)"parser");
        Args.notNull(fields, (String)"fields");
        CharArrayBuffer current = null;
        CharArrayBuffer previous = null;
        while (true) {
            int l;
            if (current == null) {
                current = new CharArrayBuffer(64);
            }
            if ((l = inbuffer.readLine(current)) == -1 || current.length() < 1 || boundary != null && EntityParser.isBoundaryDelimiter(current, null, boundary)) break;
            if ((current.charAt(0) == ' ' || current.charAt(0) == '\t') && previous != null) {
                char ch;
                int i;
                for (i = 0; i < current.length() && ((ch = current.charAt(i)) == ' ' || ch == '\t'); ++i) {
                }
                previous.append(' ');
                previous.append(current, i, current.length() - i);
                current.clear();
                continue;
            }
            fields.add(current);
            previous = current;
            current = null;
        }
        return fields;
    }

    public static HttpEntity extractEdiPayload(HttpEntityEnclosingRequest request, PrivateKey privateKey) throws HttpException {
        String contentTypeString = HttpMessageUtils.getHeaderValue((HttpMessage)request, "Content-Type");
        if (contentTypeString == null) {
            throw new HttpException("Failed to create MIC: content type missing from request");
        }
        ContentType contentType = ContentType.parse((String)contentTypeString);
        EntityParser.parseAS2MessageEntity((HttpMessage)request);
        MimeEntity ediEntity = null;
        block7 : switch (contentType.getMimeType().toLowerCase()) {
            case "application/edifact": 
            case "application/edi-x12": 
            case "application/edi-consent": {
                ediEntity = HttpMessageUtils.getEntity((HttpMessage)request, ApplicationEDIEntity.class);
                break;
            }
            case "multipart/signed": {
                MultipartSignedEntity multipartSignedEntity = HttpMessageUtils.getEntity((HttpMessage)request, MultipartSignedEntity.class);
                ediEntity = multipartSignedEntity.getSignedDataEntity();
                break;
            }
            case "application/pkcs7-mime": {
                switch (contentType.getParameter("smime-type")) {
                    case "compressed-data": {
                        ApplicationPkcs7MimeCompressedDataEntity compressedDataEntity = HttpMessageUtils.getEntity((HttpMessage)request, ApplicationPkcs7MimeCompressedDataEntity.class);
                        ediEntity = EntityParser.extractEdiPayloadFromCompressedEntity(compressedDataEntity);
                        break block7;
                    }
                    case "enveloped-data": {
                        if (privateKey == null) {
                            throw new HttpException("Failed to get EDI message from encrypted request: private key is null");
                        }
                        ApplicationPkcs7MimeEnvelopedDataEntity envelopedDataEntity = HttpMessageUtils.getEntity((HttpMessage)request, ApplicationPkcs7MimeEnvelopedDataEntity.class);
                        ediEntity = EntityParser.extractEdiPayloadFromEnvelopedEntity(envelopedDataEntity, privateKey);
                        break block7;
                    }
                }
                throw new HttpException("Failed to create MIC: unknown application/pkcs7-mime smime-type: " + contentType.getParameter("smime-type"));
            }
            default: {
                throw new HttpException("Failed to create MIC: invalid content type '" + contentType.getMimeType() + "' for message integrity check");
            }
        }
        return ediEntity;
    }

    private static MimeEntity extractEdiPayloadFromEnvelopedEntity(ApplicationPkcs7MimeEnvelopedDataEntity envelopedDataEntity, PrivateKey privateKey) throws HttpException {
        MimeEntity ediEntity = null;
        MimeEntity entity = envelopedDataEntity.getEncryptedEntity(privateKey);
        String contentTypeString = entity.getContentTypeValue();
        if (contentTypeString == null) {
            throw new HttpException("Failed to create MIC: content type missing from encrypted entity");
        }
        ContentType contentType = ContentType.parse((String)contentTypeString);
        switch (contentType.getMimeType().toLowerCase()) {
            case "application/edifact": 
            case "application/edi-x12": 
            case "application/edi-consent": {
                ediEntity = entity;
                break;
            }
            case "multipart/signed": {
                MultipartSignedEntity multipartSignedEntity = (MultipartSignedEntity)entity;
                ediEntity = multipartSignedEntity.getSignedDataEntity();
                break;
            }
            case "application/pkcs7-mime": {
                if (!"compressed-data".equals(contentType.getParameter("smime-type"))) {
                    throw new HttpException("Failed to extract EDI payload: invalid mime type '" + contentType.getParameter("smime-type") + "' for AS2 enveloped entity");
                }
                ApplicationPkcs7MimeCompressedDataEntity compressedDataEntity = (ApplicationPkcs7MimeCompressedDataEntity)entity;
                ediEntity = EntityParser.extractEdiPayloadFromCompressedEntity(compressedDataEntity);
                break;
            }
            default: {
                throw new HttpException("Failed to extract EDI payload: invalid content type '" + contentType.getMimeType() + "' for AS2 enveloped entity");
            }
        }
        return ediEntity;
    }

    private static MimeEntity extractEdiPayloadFromCompressedEntity(ApplicationPkcs7MimeCompressedDataEntity compressedDataEntity) throws HttpException {
        MimeEntity ediEntity = null;
        MimeEntity entity = compressedDataEntity.getCompressedEntity((InputExpanderProvider)new ZlibExpanderProvider());
        String contentTypeString = entity.getContentTypeValue();
        if (contentTypeString == null) {
            throw new HttpException("Failed to extract EDI payload: content type missing from compressed entity");
        }
        ContentType contentType = ContentType.parse((String)contentTypeString);
        switch (contentType.getMimeType().toLowerCase()) {
            case "application/edifact": 
            case "application/edi-x12": 
            case "application/edi-consent": {
                ediEntity = entity;
                break;
            }
            case "multipart/signed": {
                MultipartSignedEntity multipartSignedEntity = (MultipartSignedEntity)entity;
                ediEntity = multipartSignedEntity.getSignedDataEntity();
                break;
            }
            default: {
                throw new HttpException("Failed to extract EDI payload: invalid content type '" + contentType.getMimeType() + "' for AS2 compressed entity");
            }
        }
        return ediEntity;
    }
}

