/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.as2.api.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import org.apache.camel.component.as2.api.AS2MicAlgorithm;
import org.apache.camel.component.as2.api.entity.ApplicationEDIEntity;
import org.apache.camel.component.as2.api.entity.DispositionNotificationOptions;
import org.apache.camel.component.as2.api.entity.DispositionNotificationOptionsParser;
import org.apache.camel.component.as2.api.entity.EntityParser;
import org.apache.camel.component.as2.api.entity.MultipartSignedEntity;
import org.apache.camel.component.as2.api.util.EntityUtils;
import org.apache.camel.component.as2.api.util.HttpMessageUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpMessage;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MicUtils {
    private static final Logger LOG = LoggerFactory.getLogger(MicUtils.class);

    private MicUtils() {
    }

    public static byte[] createMic(byte[] content, String algorithmId) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(algorithmId, "BC");
            return messageDigest.digest(content);
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            LOG.debug("failed to get message digets '{}'", (Object)algorithmId);
            return null;
        }
    }

    public static ReceivedContentMic createReceivedContentMic(HttpEntityEnclosingRequest request) throws HttpException {
        String dispositionNotificationOptionsString = HttpMessageUtils.getHeaderValue((HttpMessage)request, "Disposition-Notification-Options");
        if (dispositionNotificationOptionsString == null) {
            LOG.debug("do not create MIC: no disposition notification options in request");
            return null;
        }
        DispositionNotificationOptions dispositionNotificationOptions = DispositionNotificationOptionsParser.parseDispositionNotificationOptions(dispositionNotificationOptionsString, null);
        String micJdkAlgorithmName = MicUtils.getMicJdkAlgorithmName(dispositionNotificationOptions.getSignedReceiptMicalg().getValues());
        if (micJdkAlgorithmName == null) {
            LOG.debug("do not create MIC: no matching MIC algorithms found");
            return null;
        }
        String contentTypeString = HttpMessageUtils.getHeaderValue((HttpMessage)request, "Content-Type");
        if (contentTypeString == null) {
            LOG.debug("can not create MIC: content type missing from request");
            return null;
        }
        ContentType contentType = ContentType.parse((String)contentTypeString);
        Object entity = null;
        switch (contentType.getMimeType().toLowerCase()) {
            case "application/edifact": 
            case "application/edi-x12": 
            case "application/edi-consent": {
                EntityParser.parseAS2MessageEntity((HttpMessage)request);
                entity = (HttpEntity)HttpMessageUtils.getEntity((HttpMessage)request, ApplicationEDIEntity.class);
                break;
            }
            case "multipart/signed": {
                EntityParser.parseAS2MessageEntity((HttpMessage)request);
                MultipartSignedEntity multipartSignedEntity = HttpMessageUtils.getEntity((HttpMessage)request, MultipartSignedEntity.class);
                entity = multipartSignedEntity.getSignedDataEntity();
                break;
            }
            default: {
                LOG.debug("can not create MIC: invalid content type '{}' for message integrity check", (Object)contentType.getMimeType());
                return null;
            }
        }
        byte[] content = EntityUtils.getContent(entity);
        String micAS2AlgorithmName = AS2MicAlgorithm.getAS2AlgorithmName(micJdkAlgorithmName);
        byte[] mic = MicUtils.createMic(content, micJdkAlgorithmName);
        try {
            return new ReceivedContentMic(micAS2AlgorithmName, mic);
        }
        catch (Exception e) {
            throw new HttpException("failed to encode MIC", (Throwable)e);
        }
    }

    public static String getMicJdkAlgorithmName(String[] micAs2AlgorithmNames) {
        if (micAs2AlgorithmNames == null) {
            return AS2MicAlgorithm.SHA_1.getJdkAlgorithmName();
        }
        for (String micAs2AlgorithmName : micAs2AlgorithmNames) {
            String micJdkAlgorithmName = AS2MicAlgorithm.getJdkAlgorithmName(micAs2AlgorithmName);
            if (micJdkAlgorithmName == null) continue;
            return micJdkAlgorithmName;
        }
        return AS2MicAlgorithm.SHA_1.getJdkAlgorithmName();
    }

    public static class ReceivedContentMic {
        private final String digestAlgorithmId;
        private final String encodedMessageDigest;

        public ReceivedContentMic(String digestAlgorithmId, byte[] messageDigest) throws Exception {
            this.digestAlgorithmId = digestAlgorithmId;
            messageDigest = EntityUtils.encode(messageDigest, "base64");
            this.encodedMessageDigest = new String(messageDigest, "US-ASCII");
        }

        protected ReceivedContentMic(String digestAlgorithmId, String encodedMessageDigest) {
            this.digestAlgorithmId = digestAlgorithmId;
            this.encodedMessageDigest = encodedMessageDigest;
        }

        public String getDigestAlgorithmId() {
            return this.digestAlgorithmId;
        }

        public String getEncodedMessageDigest() {
            return this.encodedMessageDigest;
        }

        public String toString() {
            return this.encodedMessageDigest + "," + this.digestAlgorithmId;
        }
    }
}

