/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.as2.api.util;

import org.apache.camel.component.as2.api.entity.EntityParser;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpMessage;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.io.SessionInputBuffer;
import org.apache.http.util.Args;
import org.apache.http.util.CharArrayBuffer;

public final class HttpMessageUtils {
    private HttpMessageUtils() {
    }

    public static String getHeaderValue(HttpMessage message, String headerName) {
        Header header = message.getFirstHeader(headerName);
        return header == null ? null : header.getValue();
    }

    public static void setHeaderValue(HttpMessage message, String headerName, String headerValue) {
        Args.notNull((Object)message, (String)"message");
        Args.notNull((Object)headerName, (String)"headerName");
        if (headerValue == null) {
            message.removeHeaders(headerName);
        } else {
            message.setHeader(headerName, headerValue);
        }
    }

    public static <T> T getEntity(HttpMessage message, Class<T> type) {
        HttpEntity entity;
        Args.notNull((Object)message, (String)"message");
        Args.notNull(type, (String)"type");
        if (message instanceof HttpEntityEnclosingRequest) {
            HttpEntity entity2 = ((HttpEntityEnclosingRequest)message).getEntity();
            if (entity2 != null && type.isInstance(entity2)) {
                return type.cast(entity2);
            }
        } else if (message instanceof HttpResponse && (entity = ((HttpResponse)message).getEntity()) != null && type.isInstance(entity)) {
            type.cast(entity);
        }
        return null;
    }

    public static String parseBodyPartContent(SessionInputBuffer inBuffer, String boundary) throws HttpException {
        try {
            CharArrayBuffer bodyPartContentBuffer = new CharArrayBuffer(1024);
            CharArrayBuffer lineBuffer = new CharArrayBuffer(1024);
            boolean foundMultipartEndBoundary = false;
            while (inBuffer.readLine(lineBuffer) != -1) {
                if (EntityParser.isBoundaryDelimiter(lineBuffer, null, boundary)) {
                    foundMultipartEndBoundary = true;
                    bodyPartContentBuffer.setLength(bodyPartContentBuffer.length() - 2);
                    lineBuffer.clear();
                    break;
                }
                lineBuffer.append("\r\n");
                bodyPartContentBuffer.append(lineBuffer);
                lineBuffer.clear();
            }
            if (!foundMultipartEndBoundary) {
                throw new HttpException("Failed to find end boundary delimiter for body part");
            }
            return bodyPartContentBuffer.toString();
        }
        catch (HttpException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HttpException("Failed to parse body part content", (Throwable)e);
        }
    }

    public static String getBoundaryParameterValue(HttpMessage message, String headerName) {
        Args.notNull((Object)message, (String)"message");
        Args.notNull((Object)headerName, (String)"headerName");
        Header header = message.getFirstHeader(headerName);
        if (header == null) {
            return null;
        }
        for (HeaderElement headerElement : header.getElements()) {
            for (NameValuePair nameValuePair : headerElement.getParameters()) {
                if (!nameValuePair.getName().equalsIgnoreCase("boundary")) continue;
                return nameValuePair.getValue();
            }
        }
        return null;
    }
}

