/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.as2.api.protocol;

import java.io.IOException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import org.apache.camel.component.as2.api.AS2SignedDataGenerator;
import org.apache.camel.component.as2.api.InvalidAS2NameException;
import org.apache.camel.component.as2.api.Util;
import org.apache.camel.component.as2.api.entity.AS2DispositionType;
import org.apache.camel.component.as2.api.entity.DispositionMode;
import org.apache.camel.component.as2.api.entity.DispositionNotificationMultipartReportEntity;
import org.apache.camel.component.as2.api.entity.DispositionNotificationOptions;
import org.apache.camel.component.as2.api.entity.DispositionNotificationOptionsParser;
import org.apache.camel.component.as2.api.entity.MultipartSignedEntity;
import org.apache.camel.component.as2.api.util.EntityUtils;
import org.apache.camel.component.as2.api.util.HttpMessageUtils;
import org.apache.camel.component.as2.api.util.SigningUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpMessage;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpCoreContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseMDN
implements HttpResponseInterceptor {
    public static final String BOUNDARY_PARAM_NAME = "boundary";
    private static final Logger LOG = LoggerFactory.getLogger(ResponseMDN.class);
    private final String as2Version;
    private final String serverFQDN;
    private Certificate[] signingCertificateChain;
    private PrivateKey signingPrivateKey;

    public ResponseMDN(String as2Version, String serverFQDN, Certificate[] signingCertificateChain, PrivateKey signingPrivateKey) {
        this.as2Version = as2Version;
        this.serverFQDN = serverFQDN;
        this.signingCertificateChain = signingCertificateChain;
        this.signingPrivateKey = signingPrivateKey;
    }

    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode < 200 || statusCode >= 300) {
            LOG.debug("MDN not return due to response status code: " + statusCode);
            return;
        }
        HttpCoreContext coreContext = HttpCoreContext.adapt((HttpContext)context);
        HttpEntityEnclosingRequest request = (HttpEntityEnclosingRequest)coreContext.getAttribute("http.request", HttpEntityEnclosingRequest.class);
        if (request == null) {
            LOG.debug("MDN not returned due to null request");
            throw new HttpException("request missing from HTTP context");
        }
        LOG.debug("Processing MDN for request: " + request);
        if (HttpMessageUtils.getHeaderValue((HttpMessage)request, "Disposition-Notification-To") == null) {
            LOG.debug("MDN not returned: no receipt requested");
            return;
        }
        String boundary = EntityUtils.createBoundaryValue();
        DispositionNotificationMultipartReportEntity multipartReportEntity = new DispositionNotificationMultipartReportEntity(request, response, DispositionMode.AUTOMATIC_ACTION_MDN_SENT_AUTOMATICALLY, AS2DispositionType.PROCESSED, null, null, null, null, null, "US-ASCII", boundary, true);
        DispositionNotificationOptions dispositionNotificationOptions = DispositionNotificationOptionsParser.parseDispositionNotificationOptions(HttpMessageUtils.getHeaderValue((HttpMessage)request, "Disposition-Notification-Options"), null);
        String receiptAddress = HttpMessageUtils.getHeaderValue((HttpMessage)request, "Receipt-Delivery-Option");
        if (receiptAddress == null) {
            response.addHeader("MIME-Version", "1.0");
            response.addHeader("AS2-Version", this.as2Version);
            String subjectPrefix = (String)coreContext.getAttribute("camel-as2.serversubject", String.class);
            String subject = HttpMessageUtils.getHeaderValue((HttpMessage)request, "Subject");
            subject = subjectPrefix != null && subject != null ? subjectPrefix + subject : (subject != null ? "MDN Response To:" + subject : "Your Requested MDN Response");
            response.addHeader("Subject", subject);
            String from = (String)coreContext.getAttribute("camel-as2.serverfrom", String.class);
            response.addHeader("From", from);
            String as2From = HttpMessageUtils.getHeaderValue((HttpMessage)request, "AS2-To");
            try {
                Util.validateAS2Name(as2From);
            }
            catch (InvalidAS2NameException e) {
                throw new HttpException("Invalid AS-From name", (Throwable)e);
            }
            response.addHeader("AS2-From", as2From);
            String as2To = HttpMessageUtils.getHeaderValue((HttpMessage)request, "AS2-From");
            try {
                Util.validateAS2Name(as2To);
            }
            catch (InvalidAS2NameException e) {
                throw new HttpException("Invalid AS-To name", (Throwable)e);
            }
            response.addHeader("AS2-To", as2To);
            response.addHeader("Message-Id", Util.createMessageId(this.serverFQDN));
            AS2SignedDataGenerator gen = null;
            if (dispositionNotificationOptions.getSignedReceiptProtocol() != null && this.signingCertificateChain != null && this.signingPrivateKey != null) {
                gen = SigningUtils.createSigningGenerator(this.signingCertificateChain, this.signingPrivateKey);
            }
            if (gen != null) {
                try {
                    multipartReportEntity.setMainBody(false);
                    MultipartSignedEntity multipartSignedEntity = new MultipartSignedEntity(multipartReportEntity, gen, "US-ASCII", "base64", false, null);
                    response.setHeader(multipartSignedEntity.getContentType());
                    EntityUtils.setMessageEntity((HttpMessage)response, (HttpEntity)multipartSignedEntity);
                }
                catch (Exception e) {
                    LOG.warn("failed to sign receipt");
                }
            } else {
                response.setHeader(multipartReportEntity.getContentType());
                EntityUtils.setMessageEntity((HttpMessage)response, (HttpEntity)multipartReportEntity);
            }
        }
        LOG.debug(Util.printMessage((HttpMessage)response));
    }
}

