/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.as2.api.entity;

import java.util.Map;
import org.apache.camel.component.as2.api.entity.AS2DispositionModifier;
import org.apache.camel.component.as2.api.entity.AS2DispositionType;
import org.apache.camel.component.as2.api.entity.AS2MessageDispositionNotificationEntity;
import org.apache.camel.component.as2.api.entity.DispositionMode;
import org.apache.camel.component.as2.api.entity.MultipartReportEntity;
import org.apache.camel.component.as2.api.entity.TextPlainEntity;
import org.apache.camel.component.as2.api.util.HttpMessageUtils;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpMessage;
import org.apache.http.HttpResponse;
import org.apache.http.entity.ContentType;
import org.apache.http.util.CharArrayBuffer;

public class DispositionNotificationMultipartReportEntity
extends MultipartReportEntity {
    protected DispositionNotificationMultipartReportEntity(String boundary, boolean isMainBody) {
        this.boundary = boundary;
        this.isMainBody = isMainBody;
        this.removeHeaders("Content-Type");
        this.setContentType(this.getContentTypeValue(boundary));
    }

    public DispositionNotificationMultipartReportEntity(HttpEntityEnclosingRequest request, HttpResponse response, DispositionMode dispositionMode, AS2DispositionType dispositionType, AS2DispositionModifier dispositionModifier, String[] failureFields, String[] errorFields, String[] warningFields, Map<String, String> extensionFields, String charset, String boundary, boolean isMainBody) throws HttpException {
        super(charset, isMainBody, boundary);
        this.removeHeaders("Content-Type");
        this.setContentType(this.getContentTypeValue(boundary));
        this.addPart(this.buildPlainTextReport(request, response, dispositionMode, dispositionType, dispositionModifier, failureFields, errorFields, warningFields, extensionFields));
        this.addPart(new AS2MessageDispositionNotificationEntity(request, response, dispositionMode, dispositionType, dispositionModifier, failureFields, errorFields, warningFields, extensionFields, charset, false));
    }

    public String getMainMessageContentType() {
        return "multipart/report; report-type=disposition-notification; boundary=\"" + this.boundary + "\"";
    }

    protected TextPlainEntity buildPlainTextReport(HttpEntityEnclosingRequest request, HttpResponse response, DispositionMode dispositionMode, AS2DispositionType dispositionType, AS2DispositionModifier dispositionModifier, String[] failureFields, String[] errorFields, String[] warningFields, Map<String, String> extensionFields) throws HttpException {
        CharArrayBuffer charBuffer = new CharArrayBuffer(10);
        String originalMessageId = HttpMessageUtils.getHeaderValue((HttpMessage)request, "Message-Id");
        String sentDate = HttpMessageUtils.getHeaderValue((HttpMessage)request, "Date");
        String subject = HttpMessageUtils.getHeaderValue((HttpMessage)request, "Subject");
        String receivedFrom = HttpMessageUtils.getHeaderValue((HttpMessage)request, "AS2-From");
        String sentTo = HttpMessageUtils.getHeaderValue((HttpMessage)request, "AS2-To");
        String receivedDate = HttpMessageUtils.getHeaderValue((HttpMessage)response, "Date");
        charBuffer.append("MDN for -\n");
        charBuffer.append(" Message ID: " + originalMessageId + "\n");
        charBuffer.append("  Subject: " + (subject == null ? "" : subject) + "\n");
        charBuffer.append("  Date: " + (sentDate == null ? "" : sentDate) + "\n");
        charBuffer.append("  From: " + receivedFrom + "\n");
        charBuffer.append("  To: " + sentTo + "\n");
        charBuffer.append("  Received on: " + receivedDate + "\n");
        charBuffer.append(" Status: " + (Object)((Object)dispositionType) + "\n");
        return new TextPlainEntity(charBuffer.toString(), "US-ASCII", "7bit", false);
    }

    protected String getContentTypeValue(String boundary) {
        ContentType contentType = ContentType.parse((String)("multipart/report;report-type=disposition-notification; boundary=\"" + boundary + "\""));
        return contentType.toString();
    }
}

