/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.as2.api;

import java.io.IOException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import org.apache.camel.component.as2.api.AS2ClientConnection;
import org.apache.camel.component.as2.api.AS2MessageStructure;
import org.apache.camel.component.as2.api.AS2SignedDataGenerator;
import org.apache.camel.component.as2.api.entity.ApplicationEDIEntity;
import org.apache.camel.component.as2.api.entity.EntityParser;
import org.apache.camel.component.as2.api.entity.MultipartSignedEntity;
import org.apache.camel.component.as2.api.util.EntityUtils;
import org.apache.camel.component.as2.api.util.SigningUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpMessage;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.entity.ContentType;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.http.protocol.HttpCoreContext;
import org.apache.http.util.Args;

public class AS2ClientManager {
    public static final String CAMEL_AS2_CLIENT_PREFIX = "camel-as2.client.";
    public static final String AS2_MESSAGE_STRUCTURE = "camel-as2.client.as2-message-structure";
    public static final String EDI_MESSAGE_CONTENT_TYPE = "camel-as2.client.edi-message-content-type";
    public static final String EDI_MESSAGE_TRANSFER_ENCODING = "camel-as2.client.edi-message-transfer-encoding";
    public static final String HTTP_REQUEST = "http.request";
    public static final String HTTP_RESPONSE = "http.response";
    public static final String AS2_CONNECTION = "camel-as2.client.as2-connection";
    public static final String REQUEST_URI = "camel-as2.client.request-uri";
    public static final String SUBJECT = "camel-as2.client.subject";
    public static final String FROM = "camel-as2.client.from";
    public static final String AS2_FROM = "camel-as2.client.as2-from";
    public static final String AS2_TO = "camel-as2.client.as2-to";
    public static final String SIGNING_ALGORITHM_NAME = "camel-as2.client.signing-algorithm-name";
    public static final String SIGNING_CERTIFICATE_CHAIN = "camel-as2.client.signing-certificate-chain";
    public static final String SIGNING_PRIVATE_KEY = "camel-as2.client.signing-private-key";
    public static final String DISPOSITION_NOTIFICATION_TO = "camel-as2.client.disposition-notification-to";
    public static final String SIGNED_RECEIPT_MIC_ALGORITHMS = "camel-as2.client.signed-receipt-mic-algorithms";
    private AS2ClientConnection as2ClientConnection;

    public AS2ClientManager(AS2ClientConnection as2ClientConnection) {
        this.as2ClientConnection = as2ClientConnection;
    }

    public HttpCoreContext send(String ediMessage, String requestUri, String subject, String from, String as2From, String as2To, AS2MessageStructure as2MessageStructure, ContentType ediMessageContentType, String ediMessageTransferEncoding, Certificate[] signingCertificateChain, PrivateKey signingPrivateKey, String dispositionNotificationTo, String[] signedReceiptMicAlgorithms) throws HttpException {
        HttpResponse response;
        ApplicationEDIEntity applicationEDIEntity;
        Args.notNull((Object)ediMessage, (String)"EDI Message");
        Args.notNull((Object)((Object)as2MessageStructure), (String)"AS2 Message Structure");
        Args.notNull((Object)requestUri, (String)"Request URI");
        Args.notNull((Object)ediMessageContentType, (String)"EDI Message Content Type");
        HttpCoreContext httpContext = HttpCoreContext.create();
        httpContext.setAttribute(REQUEST_URI, (Object)requestUri);
        httpContext.setAttribute(SUBJECT, (Object)subject);
        httpContext.setAttribute(FROM, (Object)from);
        httpContext.setAttribute(AS2_FROM, (Object)as2From);
        httpContext.setAttribute(AS2_TO, (Object)as2To);
        httpContext.setAttribute(AS2_MESSAGE_STRUCTURE, (Object)as2MessageStructure);
        httpContext.setAttribute(EDI_MESSAGE_CONTENT_TYPE, (Object)ediMessageContentType);
        httpContext.setAttribute(EDI_MESSAGE_TRANSFER_ENCODING, (Object)ediMessageTransferEncoding);
        httpContext.setAttribute(SIGNING_CERTIFICATE_CHAIN, (Object)signingCertificateChain);
        httpContext.setAttribute(SIGNING_PRIVATE_KEY, (Object)signingPrivateKey);
        httpContext.setAttribute(DISPOSITION_NOTIFICATION_TO, (Object)dispositionNotificationTo);
        httpContext.setAttribute(SIGNED_RECEIPT_MIC_ALGORITHMS, (Object)signedReceiptMicAlgorithms);
        BasicHttpEntityEnclosingRequest request = new BasicHttpEntityEnclosingRequest("POST", requestUri);
        httpContext.setAttribute(HTTP_REQUEST, (Object)request);
        try {
            applicationEDIEntity = EntityUtils.createEDIEntity(ediMessage, ediMessageContentType, ediMessageTransferEncoding, false);
        }
        catch (Exception e) {
            throw new HttpException("Failed to create EDI message entity", (Throwable)e);
        }
        switch (as2MessageStructure) {
            case PLAIN: {
                applicationEDIEntity.setMainBody(true);
                EntityUtils.setMessageEntity((HttpMessage)request, (HttpEntity)applicationEDIEntity);
                break;
            }
            case SIGNED: {
                AS2SignedDataGenerator gen = this.createSigningGenerator(httpContext);
                try {
                    MultipartSignedEntity multipartSignedEntity = new MultipartSignedEntity(applicationEDIEntity, gen, "US-ASCII", "base64", true, null);
                    multipartSignedEntity.setMainBody(true);
                    EntityUtils.setMessageEntity((HttpMessage)request, (HttpEntity)multipartSignedEntity);
                    break;
                }
                catch (Exception e) {
                    throw new HttpException("Failed to sign message", (Throwable)e);
                }
            }
            case ENCRYPTED: {
                break;
            }
            case ENCRYPTED_SIGNED: {
                break;
            }
            default: {
                throw new HttpException("Unknown AS2 Message Structure");
            }
        }
        try {
            httpContext.setAttribute(AS2_CONNECTION, (Object)this.as2ClientConnection);
            response = this.as2ClientConnection.send((HttpRequest)request, httpContext);
            EntityParser.parseAS2MessageEntity((HttpMessage)response);
        }
        catch (IOException e) {
            throw new HttpException("Failed to send http request message", (Throwable)e);
        }
        httpContext.setAttribute(HTTP_RESPONSE, (Object)response);
        return httpContext;
    }

    public AS2SignedDataGenerator createSigningGenerator(HttpCoreContext httpContext) throws HttpException {
        Certificate[] certificateChain = (Certificate[])httpContext.getAttribute(SIGNING_CERTIFICATE_CHAIN, Certificate[].class);
        if (certificateChain == null) {
            throw new HttpException("Signing certificate chain missing");
        }
        PrivateKey privateKey = (PrivateKey)httpContext.getAttribute(SIGNING_PRIVATE_KEY, PrivateKey.class);
        if (privateKey == null) {
            throw new HttpException("Signing private key missing");
        }
        return SigningUtils.createSigningGenerator(certificateChain, privateKey);
    }
}

