/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.stream.Stream;
import org.apache.camel.maven.AbstractApiMethodBaseMojo;
import org.apache.camel.maven.AbstractApiMethodGeneratorMojo;
import org.apache.camel.maven.ApiMethodAlias;
import org.apache.camel.maven.ApiProxy;
import org.apache.camel.maven.FromJavasource;
import org.apache.camel.maven.HashHelper;
import org.apache.camel.maven.JavaSourceApiMethodGeneratorMojo;
import org.apache.camel.util.StringHelper;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.velocity.VelocityContext;

@Mojo(name="fromApis", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresProject=true, defaultPhase=LifecyclePhase.GENERATE_SOURCES, threadSafe=true)
public class ApiComponentGeneratorMojo
extends AbstractApiMethodBaseMojo {
    protected static final String DEFAULT_EXCLUDE_PACKAGES = "javax?\\.lang.*";
    private static final String CACHE_PROPERTIES_FILENAME = "camel-api-component-maven-plugin-cache.properties";
    @Parameter(required=true)
    protected ApiProxy[] apis;
    @Parameter
    protected FromJavasource fromJavasource = new FromJavasource();
    @Parameter(defaultValue="${project.build.directory}")
    private File cachedir;
    @Parameter
    private String[] nullableOptions;
    @Parameter
    private List<ApiMethodAlias> aliases = Collections.emptyList();

    @Override
    public void executeInternal() throws MojoExecutionException {
        Instant newDate;
        if (this.apis == null || this.apis.length == 0) {
            throw new MojoExecutionException("One or more API proxies are required");
        }
        if (this.apis.length == 1 && this.apis[0].getApiName() == null) {
            this.apis[0].setApiName("");
        }
        String newHash = new HashHelper().hash("ApiComponentGeneratorMojo").hash("apis", this.apis).hash("fromJavasource", this.fromJavasource).hash("nullableOptions", this.nullableOptions).hash("aliases", this.aliases).hash("substitutions", this.substitutions).hash("excludeConfigNames", this.excludeConfigNames).hash("excludeConfigTypes", this.excludeConfigTypes).hash("extraOptions", this.extraOptions).toString();
        try (Stream<File> stream = Stream.of(this.generatedSrcDir, this.generatedTestDir);){
            newDate = stream.map(File::toPath).flatMap(this::walk).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(this::lastModified).max(Comparator.naturalOrder()).orElse(Instant.now());
        }
        List<String> cache = this.readCacheFile();
        String prevHash = cache.stream().filter(s -> s.startsWith("hash=")).findFirst().map(s -> s.substring("hash=".length())).orElse(null);
        Instant prevDate = cache.stream().filter(s -> s.startsWith("date=")).findFirst().map(s -> s.substring("date=".length())).map(Instant::parse).orElse(Instant.ofEpochSecond(0L));
        if (Objects.equals(prevHash, newHash) && !newDate.isAfter(prevDate)) {
            this.getLog().info((CharSequence)"Skipping api generation, everything is up to date.");
            this.setCompileSourceRoots();
            return;
        }
        for (ApiProxy api : this.apis) {
            api.validate();
            AbstractApiMethodGeneratorMojo apiMethodGenerator = this.getApiMethodGenerator(api);
            if (apiMethodGenerator != null) {
                this.configureMethodGenerator(apiMethodGenerator, api);
                try {
                    apiMethodGenerator.setProjectClassLoader(this.getProjectClassLoader());
                    apiMethodGenerator.executeInternal();
                }
                catch (Exception e) {
                    String msg = "Error generating source for " + api.getProxyClass() + ": " + e.getMessage();
                    throw new MojoExecutionException(msg, e);
                }
            } else {
                String proxyClass = api.getProxyClass();
                boolean found = false;
                for (ApiProxy other : this.apis) {
                    if (other == api || !proxyClass.equals(other.getProxyClass())) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    throw new MojoExecutionException("Missing one of fromSignatureFile or fromJavadoc for " + proxyClass);
                }
            }
            if (!this.aliases.isEmpty() && api.getAliases().isEmpty()) {
                api.setAliases(this.aliases);
            }
            if (api.getNullableOptions() != null) continue;
            api.setNullableOptions(this.nullableOptions);
        }
        this.mergeTemplate(this.getApiContext(), this.getApiCollectionFile(), "/api-collection.vm");
        this.mergeTemplate(this.getApiContext(), this.getApiNameFile(), "/api-name-enum.vm");
        try (Stream<File> stream = Stream.of(this.generatedSrcDir, this.generatedTestDir);){
            newDate = stream.map(File::toPath).flatMap(this::walk).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(this::lastModified).max(Comparator.naturalOrder()).orElse(Instant.now());
        }
        this.writeCacheFile(Arrays.asList("# ApiComponentGenerator cache file", "hash=" + newHash, "date=" + newDate.toString()));
    }

    private Instant lastModified(Path path) {
        try {
            return Files.getLastModifiedTime(path, new LinkOption[0]).toInstant();
        }
        catch (IOException e) {
            return Instant.now();
        }
    }

    private Stream<Path> walk(Path p) {
        try {
            return Files.walk(p, Integer.MAX_VALUE, new FileVisitOption[0]);
        }
        catch (IOException e) {
            return Stream.empty();
        }
    }

    private void configureMethodGenerator(AbstractApiMethodGeneratorMojo mojo, ApiProxy apiProxy) {
        mojo.componentName = this.componentName;
        mojo.scheme = this.scheme;
        mojo.outPackage = this.outPackage;
        mojo.componentPackage = this.componentPackage;
        mojo.project = this.project;
        mojo.generatedSrcDir = this.generatedSrcDir;
        mojo.generatedTestDir = this.generatedTestDir;
        mojo.addCompileSourceRoots = this.addCompileSourceRoots;
        mojo.substitutions = apiProxy.getSubstitutions().length != 0 ? apiProxy.getSubstitutions() : this.substitutions;
        mojo.excludeConfigNames = apiProxy.getExcludeConfigNames() != null ? apiProxy.getExcludeConfigNames() : this.excludeConfigNames;
        mojo.excludeConfigTypes = apiProxy.getExcludeConfigTypes() != null ? apiProxy.getExcludeConfigTypes() : this.excludeConfigTypes;
        mojo.extraOptions = apiProxy.getExtraOptions() != null ? apiProxy.getExtraOptions() : this.extraOptions;
        mojo.proxyClass = apiProxy.getProxyClass();
        mojo.classPrefix = apiProxy.getClassPrefix();
        mojo.apiName = apiProxy.getApiName();
        mojo.apiDescription = apiProxy.getApiDescription();
        mojo.consumerOnly = apiProxy.isConsumerOnly();
        mojo.producerOnly = apiProxy.isProducerOnly();
    }

    private AbstractApiMethodGeneratorMojo getApiMethodGenerator(ApiProxy api) {
        JavaSourceApiMethodGeneratorMojo apiMethodGenerator = null;
        FromJavasource apiFromJavasource = api.getFromJavasource();
        if (apiFromJavasource != null) {
            JavaSourceApiMethodGeneratorMojo mojo = new JavaSourceApiMethodGeneratorMojo();
            mojo.excludePackages = apiFromJavasource.getExcludePackages() != null ? apiFromJavasource.getExcludePackages() : this.fromJavasource.getExcludePackages();
            mojo.excludeClasses = apiFromJavasource.getExcludeClasses() != null ? apiFromJavasource.getExcludeClasses() : this.fromJavasource.getExcludeClasses();
            mojo.includeMethods = apiFromJavasource.getIncludeMethods() != null ? apiFromJavasource.getIncludeMethods() : this.fromJavasource.getIncludeMethods();
            mojo.excludeMethods = apiFromJavasource.getExcludeMethods() != null ? apiFromJavasource.getExcludeMethods() : this.fromJavasource.getExcludeMethods();
            mojo.includeStaticMethods = apiFromJavasource.getIncludeStaticMethods() != null ? apiFromJavasource.getIncludeStaticMethods() : this.fromJavasource.getIncludeStaticMethods();
            mojo.includeSetters = apiFromJavasource.getIncludeSetters() != null ? apiFromJavasource.getIncludeSetters() : this.fromJavasource.getIncludeSetters();
            mojo.aliases = api.getAliases().isEmpty() ? this.aliases : api.getAliases();
            mojo.nullableOptions = api.getNullableOptions() != null ? api.getNullableOptions() : this.nullableOptions;
            apiMethodGenerator = mojo;
        }
        return apiMethodGenerator;
    }

    private VelocityContext getApiContext() {
        VelocityContext context = new VelocityContext();
        context.put("componentName", (Object)this.componentName);
        context.put("componentPackage", (Object)this.componentPackage);
        context.put("apis", (Object)this.apis);
        context.put("helper", ((Object)((Object)this)).getClass());
        context.put("collectionName", (Object)this.getApiCollectionName());
        context.put("apiNameEnum", (Object)this.getApiNameEnum());
        return context;
    }

    private String getApiCollectionName() {
        return this.componentName + "ApiCollection";
    }

    private String getApiNameEnum() {
        return this.componentName + "ApiName";
    }

    private File getApiCollectionFile() {
        StringBuilder fileName = this.getFileBuilder();
        fileName.append(this.getApiCollectionName()).append(".java");
        return new File(this.generatedSrcDir, fileName.toString());
    }

    private File getApiNameFile() {
        StringBuilder fileName = this.getFileBuilder();
        fileName.append(this.getApiNameEnum()).append(".java");
        return new File(this.generatedSrcDir, fileName.toString());
    }

    private StringBuilder getFileBuilder() {
        StringBuilder fileName = new StringBuilder();
        fileName.append(this.outPackage.replace(".", Matcher.quoteReplacement(File.separator))).append(File.separator);
        return fileName;
    }

    public static String getApiMethod(String proxyClass, String classPrefix) {
        String proxyClassWithCanonicalName = ApiComponentGeneratorMojo.getProxyClassWithCanonicalName(proxyClass);
        String prefix = classPrefix != null ? classPrefix : "";
        return prefix + proxyClassWithCanonicalName.substring(proxyClassWithCanonicalName.lastIndexOf(46) + 1) + "ApiMethod";
    }

    public static String getEndpointConfig(String proxyClass, String classPrefix) {
        String proxyClassWithCanonicalName = ApiComponentGeneratorMojo.getProxyClassWithCanonicalName(proxyClass);
        String prefix = classPrefix != null ? classPrefix : "";
        return prefix + proxyClassWithCanonicalName.substring(proxyClassWithCanonicalName.lastIndexOf(46) + 1) + "EndpointConfiguration";
    }

    private static String getProxyClassWithCanonicalName(String proxyClass) {
        return proxyClass.replace("$", "");
    }

    public static String getEnumConstant(String enumValue) {
        if (enumValue == null || enumValue.isEmpty()) {
            return "DEFAULT";
        }
        String value = StringHelper.camelCaseToDash((String)enumValue);
        value = value.replace('-', '_');
        value = value.toUpperCase(Locale.ENGLISH);
        return value;
    }

    public static String getNullableOptionValues(String[] nullableOptions) {
        if (nullableOptions == null || nullableOptions.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        int nOptions = nullableOptions.length;
        int i = 0;
        for (String option : nullableOptions) {
            builder.append('\"').append(option).append('\"');
            if (++i >= nOptions) continue;
            builder.append(", ");
        }
        return builder.toString();
    }

    private void writeCacheFile(List<String> cache) {
        if (this.cachedir != null) {
            File cacheFile = new File(this.cachedir, CACHE_PROPERTIES_FILENAME);
            try (FileOutputStream out = new FileOutputStream(cacheFile);){
                Files.write(cacheFile.toPath(), cache, new OpenOption[0]);
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)"Cannot store file hash cache properties file", (Throwable)e);
            }
        }
    }

    private List<String> readCacheFile() {
        File cacheFile;
        Log log = this.getLog();
        if (this.cachedir == null) {
            return Collections.emptyList();
        }
        if (!this.cachedir.exists()) {
            if (!this.cachedir.mkdirs()) {
                log.warn((CharSequence)("Unable to create cache directory '" + String.valueOf(this.cachedir) + "'."));
            }
        } else if (!this.cachedir.isDirectory()) {
            log.warn((CharSequence)("Something strange here as the '" + String.valueOf(this.cachedir) + "' supposedly cache directory is not a directory."));
            return Collections.emptyList();
        }
        if (!(cacheFile = new File(this.cachedir, CACHE_PROPERTIES_FILENAME)).exists()) {
            return Collections.emptyList();
        }
        try {
            return Files.readAllLines(cacheFile.toPath());
        }
        catch (IOException e) {
            log.warn((CharSequence)"Cannot load cache file", (Throwable)e);
            return Collections.emptyList();
        }
    }
}

