/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.camel.maven.AbstractApiMethodGeneratorMojo;
import org.apache.camel.maven.JavaSourceParser;
import org.apache.camel.maven.SignatureModel;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="fromSource", requiresDependencyResolution=ResolutionScope.TEST, requiresProject=true, defaultPhase=LifecyclePhase.GENERATE_SOURCES, threadSafe=true)
public class JavaSourceApiMethodGeneratorMojo
extends AbstractApiMethodGeneratorMojo {
    protected static final String DEFAULT_EXCLUDE_PACKAGES = "javax?\\.lang.*";
    @Parameter(property="org.apache.camel.excludePackages", defaultValue="javax?\\.lang.*")
    protected String excludePackages;
    @Parameter(property="org.apache.camel.excludeClasses")
    protected String excludeClasses;
    @Parameter(property="org.apache.camel.includeMethods")
    protected String includeMethods;
    @Parameter(property="org.apache.camel.excludeMethods")
    protected String excludeMethods;
    @Parameter(property="org.apache.camel.includeStaticMethods")
    protected Boolean includeStaticMethods;

    @Override
    public List<SignatureModel> getSignatureList() throws MojoExecutionException {
        LinkedHashMap<String, SignatureModel> result = new LinkedHashMap<String, SignatureModel>();
        Pattern packagePatterns = Pattern.compile(this.excludePackages);
        Pattern classPatterns = this.excludeClasses != null ? Pattern.compile(this.excludeClasses) : null;
        Pattern includeMethodPatterns = this.includeMethods != null ? Pattern.compile(this.includeMethods) : null;
        Pattern excludeMethodPatterns = this.excludeMethods != null ? Pattern.compile(this.excludeMethods) : null;
        for (Class<?> aClass = this.getProxyType(); !(aClass == null || packagePatterns.matcher(aClass.getPackage().getName()).matches() || classPatterns != null && classPatterns.matcher(aClass.getSimpleName()).matches()); aClass = aClass.getSuperclass()) {
            this.log.debug("Processing {}", (Object)aClass.getName());
            String sourcePath = aClass.getName();
            String nestedClass = null;
            int pos = sourcePath.indexOf(36);
            if (pos != -1) {
                nestedClass = sourcePath.substring(pos + 1);
                sourcePath = sourcePath.substring(0, pos);
            }
            sourcePath = sourcePath.replace('.', '/') + ".java";
            this.log.debug("Loading source: {}", (Object)sourcePath);
            try (InputStream inputStream = this.getProjectClassLoader().getResourceAsStream(sourcePath);){
                if (inputStream == null) {
                    this.log.debug("Java source not found on classpath for {}", (Object)aClass.getName());
                    break;
                }
                JavaSourceParser parser = new JavaSourceParser();
                parser.parse(inputStream, nestedClass);
                String parseError = parser.getErrorMessage();
                if (parseError != null) {
                    throw new MojoExecutionException(parseError);
                }
                for (String method : parser.getMethodSignatures()) {
                    if (result.containsKey(method) || includeMethodPatterns != null && !includeMethodPatterns.matcher(method).find() || excludeMethodPatterns != null && excludeMethodPatterns.matcher(method).find()) continue;
                    String signature = method;
                    method = method.replace("public ", "");
                    int whitespace = method.indexOf(32);
                    int leftBracket = method.indexOf(40);
                    String name = method.substring(whitespace + 1, leftBracket);
                    SignatureModel model = new SignatureModel();
                    model.setSignature(method);
                    model.setApiDescription(parser.getClassDoc());
                    model.setMethodDescription(parser.getMethodDocs().get(name));
                    model.setParameterDescriptions(parser.getParameterDocs().get(name));
                    model.setParameterTypes(parser.getParameterTypes().get(signature));
                    result.put(method, model);
                }
                continue;
            }
            catch (Exception e) {
                throw new MojoExecutionException(e.getMessage(), e);
            }
        }
        if (result.isEmpty()) {
            throw new MojoExecutionException("No public non-static methods found, make sure source JAR is available as project scoped=provided and optional=true dependency");
        }
        return new ArrayList<SignatureModel>(result.values());
    }

    static {
        System.setProperty("java.awt.headless", "true");
    }
}

