/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.text.ChangedCharSetException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.parser.DTD;
import javax.swing.text.html.parser.Parser;
import javax.swing.text.html.parser.TagElement;
import org.apache.commons.lang.StringEscapeUtils;

public class JavadocParser
extends Parser {
    private static final String NON_BREAKING_SPACE = "\u00a0";
    private static final String JAVA6_NON_BREAKING_SPACE = "&nbsp";
    private final String hrefPattern;
    private ParserState parserState;
    private String methodWithTypes;
    private StringBuilder methodTextBuilder = new StringBuilder();
    private List<String> methods = new ArrayList<String>();
    private Map<String, String> methodText = new HashMap<String, String>();
    private String errorMessage;

    public JavadocParser(DTD dtd, String docPath) {
        super(dtd);
        this.hrefPattern = docPath + "#";
        this.parserState = ParserState.INIT;
    }

    public void reset() {
        this.parserState = ParserState.INIT;
        this.methodWithTypes = null;
        this.methodTextBuilder = new StringBuilder();
        this.methods.clear();
        this.methodText.clear();
        this.errorMessage = null;
    }

    @Override
    protected void startTag(TagElement tag) throws ChangedCharSetException {
        super.startTag(tag);
        HTML.Tag htmlTag = tag.getHTMLTag();
        if (htmlTag != null) {
            if (HTML.Tag.A.equals(htmlTag)) {
                SimpleAttributeSet attributes = this.getAttributes();
                Object name = attributes.getAttribute(HTML.Attribute.NAME);
                Object id = attributes.getAttribute(HTML.Attribute.ID);
                if (name != null || id != null) {
                    String nameAttr = (String)name;
                    String idAttr = (String)id;
                    if (this.parserState == ParserState.INIT && ("method_summary".equals(nameAttr) || "method.summary".equals(nameAttr) || "method_summary".equals(idAttr) || "method.summary".equals(idAttr))) {
                        this.parserState = ParserState.METHOD_SUMMARY;
                    } else if (this.parserState == ParserState.METHOD) {
                        if (this.methodWithTypes == null) {
                            String hrefAttr = (String)attributes.getAttribute(HTML.Attribute.HREF);
                            if (hrefAttr != null && (hrefAttr.contains(this.hrefPattern) || hrefAttr.charAt(0) == '#')) {
                                String methodSignature = hrefAttr.substring(hrefAttr.indexOf(35) + 1);
                                int firstHyphen = methodSignature.indexOf(45);
                                if (firstHyphen != -1) {
                                    int lastHyphen = methodSignature.lastIndexOf(45);
                                    methodSignature = methodSignature.substring(0, firstHyphen) + "(" + methodSignature.substring(firstHyphen + 1, lastHyphen) + ")";
                                    methodSignature = methodSignature.replace('-', ',');
                                }
                                if (methodSignature.contains("...)")) {
                                    methodSignature = methodSignature.replace("...)", "[])");
                                }
                                if (methodSignature.contains(":A")) {
                                    methodSignature = methodSignature.replace(":A", "[]");
                                }
                                this.methodWithTypes = JavadocParser.unescapeHtml(methodSignature);
                            }
                        } else {
                            String title = (String)attributes.getAttribute(HTML.Attribute.TITLE);
                            if (title != null) {
                                this.methodTextBuilder.append(title, title.lastIndexOf(32), title.length()).append('.');
                            }
                        }
                    }
                }
            } else if (this.parserState == ParserState.METHOD_SUMMARY && HTML.Tag.CODE.equals(htmlTag)) {
                this.parserState = ParserState.METHOD;
            }
        }
    }

    private static String unescapeHtml(String htmlString) {
        String result = StringEscapeUtils.unescapeHtml((String)htmlString).replaceAll(NON_BREAKING_SPACE, " ").replaceAll(JAVA6_NON_BREAKING_SPACE, " ");
        try {
            result = URLDecoder.decode(result, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return result;
    }

    @Override
    protected void handleEmptyTag(TagElement tag) {
        if (this.parserState == ParserState.METHOD && HTML.Tag.CODE.equals(tag.getHTMLTag())) {
            if (this.methodWithTypes != null) {
                this.methods.add(this.methodWithTypes);
                this.methodText.put(this.methodWithTypes, this.getArgSignature());
                this.methodTextBuilder.delete(0, this.methodTextBuilder.length());
                this.methodWithTypes = null;
            }
            this.parserState = ParserState.METHOD_SUMMARY;
        } else if (this.parserState == ParserState.METHOD_SUMMARY && !this.methods.isEmpty() && HTML.Tag.TABLE.equals(tag.getHTMLTag())) {
            this.parserState = ParserState.INIT;
        }
    }

    private String getArgSignature() {
        String typeString = this.methodWithTypes.substring(this.methodWithTypes.indexOf(40) + 1, this.methodWithTypes.indexOf(41));
        if (typeString.isEmpty()) {
            return "()";
        }
        String plainText = JavadocParser.unescapeHtml(this.methodTextBuilder.toString());
        if (plainText.contains("...")) {
            plainText = plainText.replace("...", "[]");
        }
        return plainText.substring(plainText.indexOf(40), plainText.indexOf(41) + 1);
    }

    @Override
    protected void handleText(char[] text) {
        if (this.parserState == ParserState.METHOD && this.methodWithTypes != null) {
            this.methodTextBuilder.append(text);
        }
    }

    @Override
    protected void handleError(int ln, String msg) {
        if (msg.startsWith("exception ")) {
            this.errorMessage = "Exception parsing Javadoc line " + ln + ": " + msg;
        }
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public List<String> getMethods() {
        return this.methods;
    }

    public Map<String, String> getMethodText() {
        return this.methodText;
    }

    private static enum ParserState {
        INIT,
        METHOD_SUMMARY,
        METHOD;

    }
}

