/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import org.apache.camel.maven.AbstractApiMethodBaseMojo;
import org.apache.camel.maven.AbstractApiMethodGeneratorMojo;
import org.apache.camel.maven.ApiMethodAlias;
import org.apache.camel.maven.ApiProxy;
import org.apache.camel.maven.FileApiMethodGeneratorMojo;
import org.apache.camel.maven.FromJavadoc;
import org.apache.camel.maven.JavadocApiMethodGeneratorMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.velocity.VelocityContext;

@Mojo(name="fromApis", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresProject=true, defaultPhase=LifecyclePhase.GENERATE_SOURCES, threadSafe=true)
public class ApiComponentGeneratorMojo
extends AbstractApiMethodBaseMojo {
    @Parameter(required=true)
    protected ApiProxy[] apis;
    @Parameter
    protected FromJavadoc fromJavadoc = new FromJavadoc();
    @Parameter
    private String[] nullableOptions;
    @Parameter
    private List<ApiMethodAlias> aliases = Collections.emptyList();

    @Override
    public void executeInternal() throws MojoExecutionException {
        if (this.apis == null || this.apis.length == 0) {
            throw new MojoExecutionException("One or more API proxies are required");
        }
        if (this.apis.length == 1 && this.apis[0].getApiName() == null) {
            this.apis[0].setApiName("");
        }
        for (ApiProxy api : this.apis) {
            api.validate();
            AbstractApiMethodGeneratorMojo apiMethodGenerator = this.getApiMethodGenerator(api);
            if (apiMethodGenerator != null) {
                this.configureMethodGenerator(apiMethodGenerator, api);
                try {
                    apiMethodGenerator.setProjectClassLoader(this.getProjectClassLoader());
                    apiMethodGenerator.executeInternal();
                }
                catch (Exception e) {
                    String msg = "Error generating source for " + api.getProxyClass() + ": " + e.getMessage();
                    throw new MojoExecutionException(msg, e);
                }
            } else {
                String proxyClass = api.getProxyClass();
                boolean found = false;
                for (ApiProxy other : this.apis) {
                    if (other == api || !proxyClass.equals(other.getProxyClass())) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    throw new MojoExecutionException("Missing one of fromSignatureFile or fromJavadoc for " + proxyClass);
                }
            }
            if (!this.aliases.isEmpty() && api.getAliases().isEmpty()) {
                api.setAliases(this.aliases);
            }
            if (api.getNullableOptions() != null) continue;
            api.setNullableOptions(this.nullableOptions);
        }
        this.mergeTemplate(this.getApiContext(), this.getApiCollectionFile(), "/api-collection.vm");
        this.mergeTemplate(this.getApiContext(), this.getApiNameFile(), "/api-name-enum.vm");
    }

    private void configureMethodGenerator(AbstractApiMethodGeneratorMojo mojo, ApiProxy apiProxy) {
        mojo.componentName = this.componentName;
        mojo.scheme = this.scheme;
        mojo.outPackage = this.outPackage;
        mojo.componentPackage = this.componentPackage;
        mojo.project = this.project;
        mojo.generatedSrcDir = this.generatedSrcDir;
        mojo.generatedTestDir = this.generatedTestDir;
        mojo.addCompileSourceRoots = this.addCompileSourceRoots;
        mojo.substitutions = apiProxy.getSubstitutions().length != 0 ? apiProxy.getSubstitutions() : this.substitutions;
        mojo.excludeConfigNames = apiProxy.getExcludeConfigNames() != null ? apiProxy.getExcludeConfigNames() : this.excludeConfigNames;
        mojo.excludeConfigTypes = apiProxy.getExcludeConfigTypes() != null ? apiProxy.getExcludeConfigTypes() : this.excludeConfigTypes;
        mojo.extraOptions = apiProxy.getExtraOptions() != null ? apiProxy.getExtraOptions() : this.extraOptions;
        mojo.proxyClass = apiProxy.getProxyClass();
        mojo.classPrefix = apiProxy.getClassPrefix();
    }

    private AbstractApiMethodGeneratorMojo getApiMethodGenerator(ApiProxy api) {
        AbstractApiMethodGeneratorMojo apiMethodGenerator = null;
        File signatureFile = api.getFromSignatureFile();
        if (signatureFile != null) {
            FileApiMethodGeneratorMojo fileMojo = new FileApiMethodGeneratorMojo();
            fileMojo.signatureFile = signatureFile;
            apiMethodGenerator = fileMojo;
        } else {
            FromJavadoc apiFromJavadoc = api.getFromJavadoc();
            if (apiFromJavadoc != null) {
                JavadocApiMethodGeneratorMojo javadocMojo = new JavadocApiMethodGeneratorMojo();
                javadocMojo.excludePackages = apiFromJavadoc.getExcludePackages() != null ? apiFromJavadoc.getExcludePackages() : this.fromJavadoc.getExcludePackages();
                javadocMojo.excludeClasses = apiFromJavadoc.getExcludeClasses() != null ? apiFromJavadoc.getExcludeClasses() : this.fromJavadoc.getExcludeClasses();
                javadocMojo.includeMethods = apiFromJavadoc.getIncludeMethods() != null ? apiFromJavadoc.getIncludeMethods() : this.fromJavadoc.getIncludeMethods();
                javadocMojo.excludeMethods = apiFromJavadoc.getExcludeMethods() != null ? apiFromJavadoc.getExcludeMethods() : this.fromJavadoc.getExcludeMethods();
                javadocMojo.includeStaticMethods = apiFromJavadoc.getIncludeStaticMethods() != null ? apiFromJavadoc.getIncludeStaticMethods() : this.fromJavadoc.getIncludeStaticMethods();
                apiMethodGenerator = javadocMojo;
            }
        }
        return apiMethodGenerator;
    }

    private VelocityContext getApiContext() {
        VelocityContext context = new VelocityContext();
        context.put("componentName", (Object)this.componentName);
        context.put("componentPackage", (Object)this.componentPackage);
        context.put("apis", (Object)this.apis);
        context.put("helper", ((Object)((Object)this)).getClass());
        context.put("collectionName", (Object)this.getApiCollectionName());
        context.put("apiNameEnum", (Object)this.getApiNameEnum());
        return context;
    }

    private String getApiCollectionName() {
        return this.componentName + "ApiCollection";
    }

    private String getApiNameEnum() {
        return this.componentName + "ApiName";
    }

    private File getApiCollectionFile() {
        StringBuilder fileName = this.getFileBuilder();
        fileName.append(this.getApiCollectionName()).append(".java");
        return new File(this.generatedSrcDir, fileName.toString());
    }

    private File getApiNameFile() {
        StringBuilder fileName = this.getFileBuilder();
        fileName.append(this.getApiNameEnum()).append(".java");
        return new File(this.generatedSrcDir, fileName.toString());
    }

    private StringBuilder getFileBuilder() {
        StringBuilder fileName = new StringBuilder();
        fileName.append(this.outPackage.replace(".", Matcher.quoteReplacement(File.separator))).append(File.separator);
        return fileName;
    }

    public static String getApiMethod(String proxyClass, String classPrefix) {
        String proxyClassWithCanonicalName = ApiComponentGeneratorMojo.getProxyClassWithCanonicalName(proxyClass);
        String prefix = classPrefix != null ? classPrefix : "";
        return prefix + proxyClassWithCanonicalName.substring(proxyClassWithCanonicalName.lastIndexOf(46) + 1) + "ApiMethod";
    }

    public static String getEndpointConfig(String proxyClass, String classPrefix) {
        String proxyClassWithCanonicalName = ApiComponentGeneratorMojo.getProxyClassWithCanonicalName(proxyClass);
        String prefix = classPrefix != null ? classPrefix : "";
        return prefix + proxyClassWithCanonicalName.substring(proxyClassWithCanonicalName.lastIndexOf(46) + 1) + "EndpointConfiguration";
    }

    private static String getProxyClassWithCanonicalName(String proxyClass) {
        return proxyClass.replace("$", "");
    }

    public static String getEnumConstant(String enumValue) {
        if (enumValue == null || enumValue.isEmpty()) {
            return "DEFAULT";
        }
        StringBuilder builder = new StringBuilder();
        if (!Character.isJavaIdentifierStart(enumValue.charAt(0))) {
            builder.append('_');
        }
        for (char c : enumValue.toCharArray()) {
            char upperCase = Character.toUpperCase(c);
            if (!Character.isJavaIdentifierPart(upperCase)) {
                builder.append('_');
                continue;
            }
            builder.append(upperCase);
        }
        return builder.toString();
    }

    public static String getNullableOptionValues(String[] nullableOptions) {
        if (nullableOptions == null || nullableOptions.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        int nOptions = nullableOptions.length;
        int i = 0;
        for (String option : nullableOptions) {
            builder.append('\"').append(option).append('\"');
            if (++i >= nOptions) continue;
            builder.append(", ");
        }
        return builder.toString();
    }
}

