/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.apache.camel.tooling.util.JavadocHelper;
import org.apache.camel.util.StringHelper;
import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.ASTNode;
import org.jboss.forge.roaster.model.JavaDocTag;
import org.jboss.forge.roaster.model.Type;
import org.jboss.forge.roaster.model.impl.AbstractGenericCapableJavaSource;
import org.jboss.forge.roaster.model.impl.AbstractJavaSource;
import org.jboss.forge.roaster.model.source.JavaInterfaceSource;
import org.jboss.forge.roaster.model.source.MethodSource;
import org.jboss.forge.roaster.model.source.ParameterSource;
import org.jboss.forge.roaster.model.source.TypeVariableSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaSourceParser {
    private static final Logger LOG = LoggerFactory.getLogger(JavaSourceParser.class);
    private String errorMessage;
    private String classDoc;
    private List<String> methodSignatures = new ArrayList<String>();
    private final Map<String, String> methodDocs = new HashMap<String, String>();
    private Map<String, Map<String, String>> parameterTypes = new LinkedHashMap<String, Map<String, String>>();
    private Map<String, Map<String, String>> parameterDocs = new LinkedHashMap<String, Map<String, String>>();

    public synchronized void parse(InputStream in, String innerClass) throws Exception {
        AbstractGenericCapableJavaSource rootClazz;
        AbstractGenericCapableJavaSource clazz = rootClazz = (AbstractGenericCapableJavaSource)Roaster.parse((InputStream)in);
        if (innerClass != null && (clazz = JavaSourceParser.findInnerClass(rootClazz, innerClass)) == null) {
            this.errorMessage = "Cannot find inner class " + innerClass + " in class: " + rootClazz.getQualifiedName();
            return;
        }
        LOG.debug("Parsing class: {}", (Object)clazz.getQualifiedName());
        String rawClass = clazz.toUnformattedString();
        String doc = JavaSourceParser.getClassJavadocRaw((AbstractJavaSource)clazz, rawClass);
        this.classDoc = JavaSourceParser.sanitizeJavaDocValue(doc, true);
        if (this.classDoc == null || this.classDoc.isEmpty()) {
            rawClass = rootClazz.toUnformattedString();
            doc = JavaSourceParser.getClassJavadocRaw((AbstractJavaSource)rootClazz, rawClass);
            this.classDoc = JavaSourceParser.sanitizeJavaDocValue(doc, true);
        }
        if (this.classDoc != null && this.classDoc.indexOf(46) > 0) {
            this.classDoc = StringHelper.before((String)this.classDoc, (String)".");
        }
        List ml = clazz.getMethods();
        for (MethodSource ms : ml) {
            String result;
            boolean accept;
            String methodName = ms.getName();
            LOG.debug("Parsing method: {}", (Object)methodName);
            boolean isInterface = clazz instanceof JavaInterfaceSource;
            boolean bl = accept = isInterface || !ms.isConstructor() && ms.isPublic();
            if (!accept) continue;
            doc = JavaSourceParser.getMethodJavadocRaw(ms, rawClass);
            if ((doc = JavaSourceParser.sanitizeJavaDocValue(doc, true)) != null && doc.indexOf(46) > 0) {
                doc = StringHelper.before((String)doc, (String)".");
            }
            if (doc != null && !doc.isEmpty()) {
                this.methodDocs.put(ms.getName(), doc);
            }
            if ((result = JavaSourceParser.resolveParameterizedType(rootClazz, clazz, ms, null, ms.getReturnType())).isEmpty()) {
                result = "void";
            }
            LOG.trace("Parsed return type as: {}", (Object)result);
            List params = ms.getJavaDoc().getTags("@param");
            LinkedHashMap<String, String> docs = new LinkedHashMap<String, String>();
            LinkedHashMap<String, String> args = new LinkedHashMap<String, String>();
            StringBuilder sb = new StringBuilder();
            sb.append("public ").append(result).append(" ").append(ms.getName()).append("(");
            List list = ms.getParameters();
            for (int i = 0; i < list.size(); ++i) {
                ParameterSource ps = (ParameterSource)list.get(i);
                String name = ps.getName();
                String type = JavaSourceParser.resolveParameterizedType(rootClazz, clazz, ms, ps, ps.getType());
                LOG.trace("Parsing parameter #{} ({} {})", new Object[]{i, type, name});
                sb.append(type);
                sb.append(" ").append(name);
                if (i < list.size() - 1) {
                    sb.append(", ");
                }
                docs.put(name, JavaSourceParser.getJavadocValue(params, name));
                args.put(name, type);
            }
            sb.append(")");
            Map<String, String> existing = this.parameterDocs.get(ms.getName());
            if (existing != null) {
                existing.putAll(docs);
            } else {
                this.parameterDocs.put(ms.getName(), docs);
            }
            String signature = sb.toString();
            this.methodSignatures.add(signature);
            this.parameterTypes.put(signature, args);
        }
    }

    private static String resolveParameterizedType(AbstractGenericCapableJavaSource rootClazz, AbstractGenericCapableJavaSource clazz, MethodSource ms, ParameterSource ps, Type type) {
        String answer = JavaSourceParser.resolveType(rootClazz, clazz, ms, type);
        if (type.isParameterized()) {
            boolean fqn;
            List types = type.getTypeArguments();
            boolean bounds = false;
            boolean found = false;
            for (Type t2 : types) {
                if (!JavaSourceParser.hasTypeVariableBounds(ms, clazz, t2.getName())) continue;
                bounds = true;
                String tn = JavaSourceParser.resolveTypeVariable(ms, clazz, t2.getName());
                if (tn == null) continue;
                answer = answer.replace(t2.getName(), tn);
                found = true;
            }
            if (!(bounds || found || (fqn = types.stream().allMatch(t -> {
                if (t.getQualifiedName().startsWith("java")) {
                    return true;
                }
                boolean upperOnly = JavaSourceParser.isUpperCaseOnly(t.getName());
                return !upperOnly && t.getQualifiedName().indexOf(46) != -1;
            })))) {
                bounds = true;
                found = false;
            }
            if (bounds && !found) {
                answer = type.getQualifiedName();
            }
        } else if (ms.hasTypeVariable(answer) || clazz.hasTypeVariable(answer)) {
            answer = JavaSourceParser.resolveTypeVariable(ms, clazz, answer);
        }
        if (ps != null && ps.isVarArgs() || type.isArray()) {
            answer = answer + "[]";
        }
        answer = answer.replaceAll("java.lang.", "");
        return answer;
    }

    private static boolean hasTypeVariableBounds(MethodSource ms, AbstractGenericCapableJavaSource clazz, String type) {
        TypeVariableSource tv = ms.getTypeVariable(type);
        if (tv == null) {
            tv = clazz.getTypeVariable(type);
        }
        if (tv != null) {
            return !tv.getBounds().isEmpty();
        }
        return false;
    }

    private static String resolveTypeVariable(MethodSource ms, AbstractGenericCapableJavaSource clazz, String type) {
        TypeVariableSource tv = ms.getTypeVariable(type);
        if (tv == null) {
            tv = clazz.getTypeVariable(type);
        }
        if (tv != null) {
            List bounds = tv.getBounds();
            for (Type bt : bounds) {
                String bn = bt.getQualifiedName();
                if (type.equals(bn)) continue;
                return bn;
            }
        }
        return null;
    }

    private static AbstractGenericCapableJavaSource findInnerClass(AbstractGenericCapableJavaSource rootClazz, String innerClass) {
        String[] parts = innerClass.split("\\$");
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            AbstractGenericCapableJavaSource nested = (AbstractGenericCapableJavaSource)rootClazz.getNestedType(part);
            if (nested == null || i >= parts.length - 1) {
                return nested;
            }
            rootClazz = nested;
        }
        return null;
    }

    private static String resolveType(AbstractGenericCapableJavaSource rootClazz, AbstractGenericCapableJavaSource clazz, MethodSource ms, Type type) {
        String name = type.getName();
        TypeVariableSource tv = ms.getTypeVariable(name);
        if (tv == null) {
            tv = clazz.getTypeVariable(name);
        }
        if (tv != null) {
            return type.getName();
        }
        String answer = JavaSourceParser.resolveType((AbstractJavaSource)rootClazz, (AbstractJavaSource)clazz, name);
        List types = type.getTypeArguments();
        if (!types.isEmpty()) {
            if (type.isArray()) {
                answer = type.getQualifiedNameWithGenerics();
            } else {
                StringJoiner sj = new StringJoiner(", ");
                for (Type arg : types) {
                    sj.add(JavaSourceParser.resolveType(rootClazz, clazz, ms, arg));
                }
                answer = answer + "<" + sj.toString() + ">";
            }
        }
        return answer;
    }

    private static String resolveType(AbstractJavaSource rootClazz, AbstractJavaSource clazz, String type) {
        boolean inner;
        if ("void".equals(type)) {
            return "void";
        }
        boolean bl = inner = rootClazz.getNestedType(type) != null;
        if (inner) {
            return rootClazz.getQualifiedName() + "$" + type;
        }
        boolean bl2 = inner = clazz.getNestedType(type) != null;
        if (inner) {
            return clazz.getQualifiedName() + "$" + type;
        }
        int dot = type.indexOf(46);
        if (Character.isUpperCase(type.charAt(0)) && dot != -1) {
            String parent = type.substring(0, dot);
            String child = type.substring(dot + 1);
            boolean bl3 = inner = rootClazz.getNestedType(parent) != null;
            if (inner) {
                return rootClazz.getQualifiedName() + "$" + type.replace('.', '$');
            }
            boolean bl4 = inner = clazz.getNestedType(type) != null;
            if (inner) {
                return clazz.getQualifiedName() + "$" + type.replace('.', '$');
            }
            if (parent.equals(rootClazz.getName())) {
                boolean bl5 = inner = rootClazz.getNestedType(child) != null;
                if (inner) {
                    return rootClazz.getQualifiedName() + "$" + child.replace('.', '$');
                }
                boolean bl6 = inner = clazz.getNestedType(child) != null;
                if (inner) {
                    return clazz.getQualifiedName() + "$" + child.replace('.', '$');
                }
            }
            String resolvedType = rootClazz.resolveType(parent);
            return resolvedType + "$" + child;
        }
        String resolvedType = clazz.resolveType(type);
        if (resolvedType.equals(type)) {
            resolvedType = rootClazz.resolveType(type);
        }
        return resolvedType;
    }

    private static String getJavadocValue(List<JavaDocTag> params, String name) {
        for (JavaDocTag tag : params) {
            String key = tag.getValue();
            if (!key.startsWith(name)) continue;
            String desc = key.substring(name.length());
            desc = JavaSourceParser.sanitizeJavaDocValue(desc, false);
            return desc;
        }
        return "";
    }

    private static String getClassJavadocRaw(AbstractJavaSource clazz, String rawClass) {
        Object obj = clazz.getJavaDoc().getInternal();
        ASTNode node = (ASTNode)obj;
        int pos = node.getStartPosition();
        int len = node.getLength();
        if (pos > 0 && len > 0) {
            return rawClass.substring(pos, pos + len);
        }
        return null;
    }

    private static String getMethodJavadocRaw(MethodSource ms, String rawClass) {
        Object obj = ms.getJavaDoc().getInternal();
        ASTNode node = (ASTNode)obj;
        int pos = node.getStartPosition();
        int len = node.getLength();
        if (pos > 0 && len > 0) {
            return rawClass.substring(pos, pos + len);
        }
        return null;
    }

    private static String sanitizeJavaDocValue(String desc, boolean summary) {
        if (desc == null) {
            return null;
        }
        desc = desc.trim();
        while (desc.startsWith("\n") || desc.startsWith("}") || desc.startsWith("-") || desc.startsWith("/")) {
            desc = desc.substring(1);
            desc = desc.trim();
        }
        while (desc.endsWith("-") || desc.endsWith("/")) {
            desc = desc.substring(0, desc.length() - 1);
            desc = desc.trim();
        }
        if ((desc = JavadocHelper.sanitizeDescription((String)desc, (boolean)summary)) != null && desc.matches("https?:.*")) {
            return null;
        }
        if (desc != null && !desc.isEmpty()) {
            char ch = desc.charAt(0);
            if (Character.isAlphabetic(ch) && !Character.isUpperCase(ch)) {
                desc = Character.toUpperCase(ch) + desc.substring(1);
            }
            boolean removeDot = true;
            char[] arr = desc.toCharArray();
            for (int i = 0; i < arr.length; ++i) {
                ch = arr[i];
                boolean accept = Character.isAlphabetic(ch) || Character.isWhitespace(ch) || ch == '\'' || ch == '-' || ch == '_';
                boolean last = i == arr.length - 1;
                if (accept |= last && ch == '.') continue;
                removeDot = false;
                break;
            }
            if (removeDot && desc.endsWith(".")) {
                desc = desc.substring(0, desc.length() - 1);
            }
            desc = desc.trim();
        }
        return desc;
    }

    private static boolean isUpperCaseOnly(String name) {
        for (int i = 0; i < name.length(); ++i) {
            if (Character.isUpperCase(name.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public void reset() {
        this.methodSignatures.clear();
        this.parameterDocs.clear();
        this.parameterTypes.clear();
        this.methodDocs.clear();
        this.errorMessage = null;
        this.classDoc = null;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public List<String> getMethodSignatures() {
        return this.methodSignatures;
    }

    public Map<String, Map<String, String>> getParameterTypes() {
        return this.parameterTypes;
    }

    public Map<String, Map<String, String>> getParameterDocs() {
        return this.parameterDocs;
    }

    public String getClassDoc() {
        return this.classDoc;
    }

    public Map<String, String> getMethodDocs() {
        return this.methodDocs;
    }
}

