/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven;

import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import java.util.Arrays;
import org.apache.camel.maven.ApiMethodAlias;
import org.apache.camel.maven.ApiProxy;
import org.apache.camel.maven.ExtraOption;
import org.apache.camel.maven.FromJavasource;
import org.apache.camel.maven.SignatureModel;
import org.apache.camel.maven.Substitution;

public class HashHelper {
    private final Hasher hasher = Hashing.murmur3_128().newHasher();

    public HashHelper hash(String field, Object f) {
        this.hasher.putUnencodedChars((CharSequence)field);
        return this.hash(f);
    }

    public HashHelper hash(Object f) {
        if (f != null) {
            if (f.getClass().isArray()) {
                f = Arrays.asList((Object[])f);
            }
            if (f instanceof String) {
                this.hasher.putUnencodedChars((CharSequence)((String)((Object)f)));
            } else if (f instanceof Boolean) {
                this.hasher.putBoolean(((Boolean)((Object)f)).booleanValue());
            } else if (f instanceof Iterable) {
                for (Object a : (Iterable)f) {
                    this.hash(a);
                }
            } else if (f instanceof ApiMethodAlias) {
                ApiMethodAlias apiMethodAlias = (ApiMethodAlias)((Object)f);
                this.hash("ApiMethodAlias");
                this.hash("methodPattern", apiMethodAlias.getMethodPattern());
                this.hash("methodAlias", apiMethodAlias.getMethodAlias());
            } else if (f instanceof ApiProxy) {
                ApiProxy apiProxy = (ApiProxy)((Object)f);
                this.hash("ApiProxy");
                this.hash("apiName", apiProxy.getApiName());
                this.hash("apiDescription", apiProxy.getApiDescription());
                this.hash("consumerOnly", apiProxy.isConsumerOnly());
                this.hash("producerOnly", apiProxy.isProducerOnly());
                this.hash("fromJavasource", apiProxy.getFromJavasource());
                this.hash("substitutions", apiProxy.getSubstitutions());
                this.hash("excludeConfigNames", apiProxy.getExcludeConfigNames());
                this.hash("excludeConfigTypes", apiProxy.getExcludeConfigTypes());
                this.hash("extraOptions", apiProxy.getExtraOptions());
                this.hash("nullableOptions", apiProxy.getNullableOptions());
                this.hash("classPrefix", apiProxy.getClassPrefix());
                this.hash("aliases", apiProxy.getAliases());
            } else if (f instanceof ExtraOption) {
                ExtraOption extraOption = (ExtraOption)((Object)f);
                this.hash("ExtraOption");
                this.hash("type", extraOption.getType());
                this.hash("name", extraOption.getName());
                this.hash("description", extraOption.getDescription());
            } else if (f instanceof FromJavasource) {
                FromJavasource fromJavasource = (FromJavasource)((Object)f);
                this.hash("FromJavasource");
                this.hash("excludePackages", fromJavasource.getExcludePackages());
                this.hash("excludeClasses", fromJavasource.getExcludeClasses());
                this.hash("includeMethods", fromJavasource.getIncludeMethods());
                this.hash("excludeMethods", fromJavasource.getExcludeMethods());
                this.hash("includeStaticMethods", fromJavasource.getIncludeStaticMethods());
            } else if (f instanceof SignatureModel) {
                SignatureModel signatureModel = (SignatureModel)((Object)f);
                this.hash("SignatureModel");
                this.hash("apiName", signatureModel.getApiName());
                this.hash("apiDescription", signatureModel.getApiDescription());
                this.hash("methodDescription", signatureModel.getMethodDescription());
                this.hash("signature", signatureModel.getSignature());
                this.hash("parameterDescriptions", signatureModel.getMethodDescription());
                this.hash("parameterTypes", signatureModel.getParameterTypes());
            } else if (f instanceof Substitution) {
                Substitution substitution = (Substitution)((Object)f);
                this.hash("Substitution");
                this.hash("method", substitution.getMethod());
                this.hash("argName", substitution.getArgName());
                this.hash("argType", substitution.getArgType());
                this.hash("replacement", substitution.getReplacement());
                this.hash("replaceWithType", substitution.isReplaceWithType());
            } else {
                throw new UnsupportedOperationException();
            }
        }
        return this;
    }

    public String toString() {
        return this.hasher.hash().toString();
    }
}

