/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.camel.impl.engine.DefaultBeanIntrospection;
import org.apache.camel.maven.AbstractGeneratorMojo;
import org.apache.camel.spi.BeanIntrospection;
import org.apache.camel.support.component.ApiCollection;
import org.apache.camel.support.component.ApiMethod;
import org.apache.camel.support.component.ApiMethodHelper;
import org.apache.camel.support.component.ApiName;
import org.apache.commons.lang.ClassUtils;
import org.apache.maven.doxia.siterenderer.RenderingContext;
import org.apache.maven.doxia.siterenderer.sink.SiteRendererSink;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.reporting.MavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.apache.velocity.VelocityContext;
import org.codehaus.doxia.sink.Sink;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="document", requiresDependencyResolution=ResolutionScope.COMPILE, requiresProject=true, defaultPhase=LifecyclePhase.SITE, threadSafe=true)
public class DocumentGeneratorMojo
extends AbstractGeneratorMojo
implements MavenReport {
    @Parameter(property="org.apache.camel.reportOutputDirectory", defaultValue="${project.reporting.outputDirectory}/cameldocs")
    private File reportOutputDirectory;
    @Parameter(property="org.apache.camel.destDir", defaultValue="cameldocs")
    private String destDir;
    @Parameter(property="name")
    private String name;
    @Parameter(property="description")
    private String description;
    private ApiCollection collection;

    @Override
    public void executeInternal() throws MavenReportException {
        RenderingContext context = new RenderingContext(this.reportOutputDirectory, this.getOutputName() + ".html");
        SiteRendererSink sink = new SiteRendererSink(context);
        Locale locale = Locale.getDefault();
        this.generate((Sink)sink, locale);
    }

    private void loadApiCollection() throws MavenReportException {
        try {
            Class<?> collectionClass = this.getProjectClassLoader().loadClass(this.outPackage + "." + this.componentName + "ApiCollection");
            Method getCollection = collectionClass.getMethod("getCollection", new Class[0]);
            this.collection = (ApiCollection)getCollection.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new MavenReportException(e.getMessage(), (Exception)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private VelocityContext getDocumentContext() throws MavenReportException {
        Class<?> configClass;
        VelocityContext context = new VelocityContext();
        context.put("helper", (Object)this);
        context.put("groupId", (Object)this.project.getGroupId());
        context.put("artifactId", (Object)this.project.getArtifactId());
        context.put("version", (Object)this.project.getVersion());
        TreeSet apiNames = new TreeSet(this.collection.getApiNames());
        context.put("apiNames", apiNames);
        String suffix = apiNames.size() == 1 && apiNames.contains("") ? "://endpoint?[options]" : "://endpoint-prefix/endpoint?[options]";
        context.put("uriFormat", (Object)(this.scheme + suffix));
        TreeMap<String, ApiMethodHelper> apiHelpers = new TreeMap<String, ApiMethodHelper>();
        for (Map.Entry element : this.collection.getApiHelpers().entrySet()) {
            Map.Entry entry = element;
            apiHelpers.put(((ApiName)entry.getKey()).getName(), (ApiMethodHelper)entry.getValue());
        }
        context.put("apiHelpers", apiHelpers);
        TreeMap<String, Class> apiMethods = new TreeMap<String, Class>();
        TreeMap<String, void> apiConfigs = new TreeMap<String, void>();
        for (Object e : this.collection.getApiMethods().entrySet()) {
            void configClass2;
            Map.Entry entry = (Map.Entry)e;
            String name = ((ApiName)entry.getValue()).getName();
            Class apiMethod = (Class)entry.getKey();
            apiMethods.put(name, apiMethod);
            try {
                Class<?> configClass22 = this.getProjectClassLoader().loadClass(this.getEndpointConfigName(apiMethod));
            }
            catch (ClassNotFoundException e2) {
                throw new MavenReportException(e2.getMessage(), (Exception)e2);
            }
            apiConfigs.put(name, configClass2);
        }
        context.put("apiMethods", apiMethods);
        context.put("apiConfigs", apiConfigs);
        context.put("scheme", (Object)this.scheme);
        context.put("componentName", (Object)this.componentName);
        try {
            configClass = this.getProjectClassLoader().loadClass(this.getComponentConfig());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new MavenReportException(classNotFoundException.getMessage(), (Exception)classNotFoundException);
        }
        context.put("componentConfig", configClass);
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        do {
            BeanIntrospection.ClassInfo classInfo = new DefaultBeanIntrospection().cacheClass(configClass);
            for (BeanIntrospection.MethodInfo method : classInfo.methods) {
                if (!method.isSetter.booleanValue()) continue;
                treeMap.put(method.getterOrSetterShorthandName, DocumentGeneratorMojo.getCanonicalName(method.method.getParameterTypes()[0]));
            }
        } while ((configClass = configClass.getSuperclass()) != null && !configClass.equals(Object.class));
        context.put("componentConfigFields", treeMap);
        return context;
    }

    private String getComponentConfig() {
        StringBuilder builder = new StringBuilder(this.componentPackage);
        builder.append(".").append(this.componentName).append("Configuration");
        return builder.toString();
    }

    private String getEndpointConfigName(Class<? extends ApiMethod> apiMethod) {
        String simpleName = apiMethod.getSimpleName();
        StringBuilder builder = new StringBuilder(this.componentPackage);
        builder.append(".");
        builder.append(simpleName.substring(0, simpleName.indexOf("ApiMethod")));
        builder.append("EndpointConfiguration");
        return builder.toString();
    }

    private File getDocumentFile() {
        return new File(this.getReportOutputDirectory(), this.getDocumentName() + ".html");
    }

    private String getDocumentName() {
        return this.componentName + "Component";
    }

    public void generate(Sink sink, Locale locale) throws MavenReportException {
        this.loadApiCollection();
        try {
            this.mergeTemplate(this.getDocumentContext(), this.getDocumentFile(), "/api-document.vm");
        }
        catch (MojoExecutionException e) {
            throw new MavenReportException(e.getMessage(), (Exception)((Object)e));
        }
    }

    public String getOutputName() {
        return this.destDir + "/" + this.getDocumentName();
    }

    public String getCategoryName() {
        return "Project Reports";
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName(Locale locale) {
        if (StringUtils.isEmpty((String)this.name)) {
            return this.getBundle(locale).getString("report.cameldoc.name");
        }
        return this.name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription(Locale locale) {
        if (StringUtils.isEmpty((String)this.description)) {
            return this.getBundle(locale).getString("report.cameldoc.description");
        }
        return this.description;
    }

    public File getReportOutputDirectory() {
        return this.reportOutputDirectory;
    }

    public void setReportOutputDirectory(File reportOutputDirectory) {
        this.updateReportOutputDirectory(reportOutputDirectory);
    }

    private void updateReportOutputDirectory(File reportOutputDirectory) {
        this.reportOutputDirectory = this.destDir != null && reportOutputDirectory != null && !reportOutputDirectory.getAbsolutePath().endsWith(this.destDir) ? new File(reportOutputDirectory, this.destDir) : reportOutputDirectory;
    }

    public String getDestDir() {
        return this.destDir;
    }

    public void setDestDir(String destDir) {
        this.destDir = destDir;
        this.updateReportOutputDirectory(this.reportOutputDirectory);
    }

    public boolean isExternalReport() {
        return true;
    }

    public boolean canGenerateReport() {
        return true;
    }

    private ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("cameldoc-report", locale, ((Object)((Object)this)).getClass().getClassLoader());
    }

    /*
     * WARNING - void declaration
     */
    public static List<EndpointInfo> getEndpoints(Class<? extends ApiMethod> apiMethod, ApiMethodHelper<?> helper, Class<?> endpointConfig) {
        Set<String> resultTypes;
        HashSet<String> validOptions = new HashSet<String>();
        for (Field field : endpointConfig.getDeclaredFields()) {
            validOptions.add(field.getName());
        }
        TreeMap methodMap = new TreeMap();
        for (ApiMethod method : apiMethod.getEnumConstants()) {
            void var10_14;
            String methodName = method.getName();
            List list = (List)methodMap.get(methodName);
            if (list == null) {
                ArrayList arrayList = new ArrayList();
                methodMap.put(methodName, arrayList);
            }
            var10_14.add(method);
        }
        TreeMap<String, TreeSet<Object>> aliasMap = new TreeMap<String, TreeSet<Object>>();
        Map aliasToMethodMap = helper.getAliases();
        for (Map.Entry entry : aliasToMethodMap.entrySet()) {
            String alias = (String)entry.getKey();
            for (String method : (Set)entry.getValue()) {
                TreeSet<Object> aliases = (TreeSet<Object>)aliasMap.get(method);
                if (aliases == null) {
                    aliases = new TreeSet<Object>();
                    aliasMap.put(method, aliases);
                }
                aliases.add(alias);
            }
        }
        TreeMap optionMap = new TreeMap();
        TreeMap returnType = new TreeMap();
        for (Map.Entry entry : methodMap.entrySet()) {
            Object arg22;
            String name = (String)entry.getKey();
            List apiMethods = (List)entry.getValue();
            TreeMap<Object, Integer> optionCount = new TreeMap<Object, Integer>();
            resultTypes = new TreeSet();
            returnType.put(name, resultTypes);
            for (ApiMethod method : apiMethods) {
                for (Object arg22 : method.getArgNames()) {
                    if (!validOptions.contains(arg22)) continue;
                    Integer count = (Integer)optionCount.get(arg22);
                    count = count == null ? Integer.valueOf(1) : Integer.valueOf(count + 1);
                    optionCount.put(arg22, count);
                }
                Class resultType = method.getResultType();
                if (resultType.isPrimitive()) {
                    resultType = ClassUtils.primitiveToWrapper((Class)resultType);
                }
                ((TreeSet)resultTypes).add(DocumentGeneratorMojo.getCanonicalName(resultType));
            }
            TreeSet<String> options = new TreeSet<String>();
            optionMap.put(name, options);
            TreeSet<String> mandatory = new TreeSet<String>();
            int nMethods = apiMethods.size();
            arg22 = apiMethods.iterator();
            while (arg22.hasNext()) {
                ApiMethod method = (ApiMethod)arg22.next();
                TreeSet<String> optional = new TreeSet<String>();
                for (String arg3 : method.getArgNames()) {
                    if (!validOptions.contains(arg3)) continue;
                    Integer count = (Integer)optionCount.get(arg3);
                    if (count == nMethods) {
                        mandatory.add(arg3);
                        continue;
                    }
                    optional.add(arg3);
                }
                if (optional.isEmpty()) continue;
                options.add(((Object)optional).toString());
            }
            if (mandatory.isEmpty()) continue;
            String mandatoryOptions = ((Object)mandatory).toString();
            options.add(mandatoryOptions.substring(1, mandatoryOptions.length() - 1));
        }
        ArrayList<EndpointInfo> infos = new ArrayList<EndpointInfo>();
        for (Map.Entry methodEntry : methodMap.entrySet()) {
            String endpoint = (String)methodEntry.getKey();
            EndpointInfo info = new EndpointInfo();
            info.endpoint = endpoint;
            info.aliases = DocumentGeneratorMojo.convertSetToString((Set)aliasMap.get(endpoint));
            info.options = DocumentGeneratorMojo.convertSetToString((Set)optionMap.get(endpoint));
            resultTypes = (Set)returnType.get(endpoint);
            resultTypes.remove("void");
            info.resultTypes = DocumentGeneratorMojo.convertSetToString(resultTypes);
            infos.add(info);
        }
        return infos;
    }

    private static String convertSetToString(Set<String> values) {
        if (values != null && !values.isEmpty()) {
            String result = values.toString();
            return result.substring(1, result.length() - 1);
        }
        return "";
    }

    public static String getCanonicalName(Field field) {
        Type fieldType = field.getGenericType();
        if (fieldType instanceof ParameterizedType) {
            return DocumentGeneratorMojo.getCanonicalName((ParameterizedType)fieldType);
        }
        return DocumentGeneratorMojo.getCanonicalName(field.getType());
    }

    private static String getCanonicalName(ParameterizedType fieldType) {
        Type[] typeArguments = fieldType.getActualTypeArguments();
        int nArguments = typeArguments.length;
        if (nArguments > 0) {
            StringBuilder result = new StringBuilder(DocumentGeneratorMojo.getCanonicalName((Class)fieldType.getRawType()));
            result.append("&lt;");
            int i = 0;
            for (Type typeArg : typeArguments) {
                if (typeArg instanceof ParameterizedType) {
                    result.append(DocumentGeneratorMojo.getCanonicalName((ParameterizedType)typeArg));
                } else {
                    result.append(DocumentGeneratorMojo.getCanonicalName((Class)typeArg));
                }
                if (++i >= nArguments) continue;
                result.append(',');
            }
            result.append("&gt;");
            return result.toString();
        }
        return DocumentGeneratorMojo.getCanonicalName((Class)fieldType.getRawType());
    }

    public static class EndpointInfo {
        private String endpoint;
        private String aliases;
        private String options;
        private String resultTypes;

        public String getEndpoint() {
            return this.endpoint;
        }

        public String getAliases() {
            return this.aliases;
        }

        public String getOptions() {
            return this.options;
        }

        public String getResultTypes() {
            return this.resultTypes;
        }
    }
}

