/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.linq4j.tree;

import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joou.UByte;
import org.joou.UInteger;
import org.joou.ULong;
import org.joou.UShort;
import org.joou.Unsigned;

public enum UnsignedType {
    UBYTE,
    USHORT,
    UINT,
    ULONG;


    public static @Nullable UnsignedType of(Type type) {
        if (type == UByte.class) {
            return UBYTE;
        }
        if (type == UShort.class) {
            return USHORT;
        }
        if (type == UInteger.class) {
            return UINT;
        }
        if (type == ULong.class) {
            return ULONG;
        }
        return null;
    }

    public String toJavaTypeName() {
        switch (this) {
            case UBYTE: {
                return UByte.class.getSimpleName();
            }
            case USHORT: {
                return UShort.class.getSimpleName();
            }
            case UINT: {
                return UInteger.class.getSimpleName();
            }
            case ULONG: {
                return ULong.class.getSimpleName();
            }
        }
        throw new AssertionError((Object)("Unexpected unsigned type " + (Object)((Object)this)));
    }

    public String getConvertFunctionName() {
        return "to" + this.toJavaTypeName();
    }

    public static BigInteger toBigInteger(ULong value) {
        long l = value.longValue();
        if (l >= 0L) {
            return BigInteger.valueOf(l);
        }
        return BigInteger.valueOf(l & Long.MAX_VALUE).add(ULong.MAX_VALUE_LONG);
    }

    public static UByte toUByte(byte n) {
        return UnsignedType.toUByteNonNull(n, RoundingMode.DOWN);
    }

    public static UByte toUByte(short n) {
        return UnsignedType.toUByteNonNull(n, RoundingMode.DOWN);
    }

    public static UByte toUByte(int n) {
        return UnsignedType.toUByteNonNull(n, RoundingMode.DOWN);
    }

    public static UByte toUByte(long n) {
        return UnsignedType.toUByteNonNull(n, RoundingMode.DOWN);
    }

    public static UByte toUByte(float n) {
        return UnsignedType.toUByteNonNull(Float.valueOf(n), RoundingMode.DOWN);
    }

    public static UByte toUByte(double n) {
        return UnsignedType.toUByteNonNull(n, RoundingMode.DOWN);
    }

    private static UByte toUByteNonNull(Number n, RoundingMode mode) {
        if (n instanceof BigDecimal) {
            BigDecimal d = ((BigDecimal)n).setScale(0, mode);
            return Unsigned.ubyte((long)d.longValueExact());
        }
        if (n instanceof Byte || n instanceof Short || n instanceof Integer || n instanceof Long || n instanceof Float || n instanceof Double || n instanceof UByte || n instanceof UShort || n instanceof UInteger || n instanceof ULong) {
            return Unsigned.ubyte((long)n.longValue());
        }
        throw new IllegalArgumentException("Unexpected Number value " + n.getClass().getSimpleName());
    }

    public static @Nullable UByte toUByte(@Nullable Number n, RoundingMode mode) {
        if (n == null) {
            return null;
        }
        return UnsignedType.toUByteNonNull(n, mode);
    }

    public static @Nullable UByte toUByte(@Nullable String s, RoundingMode unused) {
        if (s == null) {
            return null;
        }
        return Unsigned.ubyte((String)s);
    }

    public static UShort toUShort(byte n) {
        return UnsignedType.toUShortNonNull(n, RoundingMode.DOWN);
    }

    public static UShort toUShort(short n) {
        return UnsignedType.toUShortNonNull(n, RoundingMode.DOWN);
    }

    public static UShort toUShort(int n) {
        return UnsignedType.toUShortNonNull(n, RoundingMode.DOWN);
    }

    public static UShort toUShort(long n) {
        return UnsignedType.toUShortNonNull(n, RoundingMode.DOWN);
    }

    public static UShort toUShort(float n) {
        return UnsignedType.toUShortNonNull(Float.valueOf(n), RoundingMode.DOWN);
    }

    public static UShort toUShort(double n) {
        return UnsignedType.toUShortNonNull(n, RoundingMode.DOWN);
    }

    private static UShort toUShortNonNull(Number n, RoundingMode mode) {
        if (n instanceof BigDecimal) {
            BigDecimal d = ((BigDecimal)n).setScale(0, mode);
            return Unsigned.ushort((int)d.intValueExact());
        }
        if (n instanceof Byte || n instanceof Short || n instanceof Integer || n instanceof Long || n instanceof Float || n instanceof Double || n instanceof UByte || n instanceof UShort || n instanceof UInteger || n instanceof ULong) {
            long value = n.longValue();
            if (value < 0L || value > 65535L) {
                throw new NumberFormatException("Value is out of range : " + n);
            }
            return Unsigned.ushort((int)n.intValue());
        }
        throw new IllegalArgumentException("Unexpected Number value " + n.getClass().getSimpleName());
    }

    public static @Nullable UShort toUShort(@Nullable Number n, RoundingMode mode) {
        if (n == null) {
            return null;
        }
        return UnsignedType.toUShortNonNull(n, mode);
    }

    public static @Nullable UShort toUShort(@Nullable String s, RoundingMode unused) {
        if (s == null) {
            return null;
        }
        return Unsigned.ushort((String)s);
    }

    public static UInteger toUInteger(byte n) {
        return UnsignedType.toUIntegerNonNull(n, RoundingMode.DOWN);
    }

    public static UInteger toUInteger(short n) {
        return UnsignedType.toUIntegerNonNull(n, RoundingMode.DOWN);
    }

    public static UInteger toUInteger(int n) {
        return UnsignedType.toUIntegerNonNull(n, RoundingMode.DOWN);
    }

    public static UInteger toUInteger(long n) {
        return UnsignedType.toUIntegerNonNull(n, RoundingMode.DOWN);
    }

    public static UInteger toUInteger(float n) {
        return UnsignedType.toUIntegerNonNull(Float.valueOf(n), RoundingMode.DOWN);
    }

    public static UInteger toUInteger(double n) {
        return UnsignedType.toUIntegerNonNull(n, RoundingMode.DOWN);
    }

    private static UInteger toUIntegerNonNull(Number n, RoundingMode mode) {
        if (n instanceof BigDecimal) {
            BigDecimal d = ((BigDecimal)n).setScale(0, mode);
            return Unsigned.uint((long)d.longValueExact());
        }
        if (n instanceof Byte || n instanceof Short || n instanceof Integer || n instanceof Long || n instanceof Float || n instanceof Double || n instanceof UByte || n instanceof UShort || n instanceof UInteger || n instanceof ULong) {
            return Unsigned.uint((long)n.longValue());
        }
        throw new IllegalArgumentException("Unexpected Number value " + n.getClass().getSimpleName());
    }

    public static @Nullable UInteger toUInteger(@Nullable Number n, RoundingMode mode) {
        if (n == null) {
            return null;
        }
        return UnsignedType.toUIntegerNonNull(n, mode);
    }

    public static @Nullable UInteger toUInteger(@Nullable String s, RoundingMode unused) {
        if (s == null) {
            return null;
        }
        return Unsigned.uint((String)s);
    }

    public static ULong toULong(byte n) {
        return UnsignedType.toULongNonNull(n, RoundingMode.DOWN);
    }

    public static ULong toULong(short n) {
        return UnsignedType.toULongNonNull(n, RoundingMode.DOWN);
    }

    public static ULong toULong(int n) {
        return UnsignedType.toULongNonNull(n, RoundingMode.DOWN);
    }

    public static ULong toULong(long n) {
        return UnsignedType.toULongNonNull(n, RoundingMode.DOWN);
    }

    public static ULong toULong(float n) {
        return UnsignedType.toULongNonNull(Float.valueOf(n), RoundingMode.DOWN);
    }

    public static ULong toULong(double n) {
        return UnsignedType.toULongNonNull(n, RoundingMode.DOWN);
    }

    private static ULong toULongNonNull(Number n, RoundingMode mode) {
        if (n instanceof BigDecimal) {
            BigDecimal d = ((BigDecimal)n).setScale(0, mode);
            return Unsigned.ulong((BigInteger)d.toBigIntegerExact());
        }
        if (n instanceof Byte || n instanceof Short || n instanceof Integer || n instanceof Long || n instanceof Float || n instanceof Double || n instanceof UByte || n instanceof UShort || n instanceof UInteger) {
            long value = n.longValue();
            if (value < 0L) {
                throw new NumberFormatException("Value is out of range : " + value);
            }
            return Unsigned.ulong((long)value);
        }
        if (n instanceof ULong) {
            return (ULong)n;
        }
        throw new IllegalArgumentException("Unexpected Number value " + n.getClass().getSimpleName());
    }

    public static @Nullable ULong toULong(@Nullable Number n, RoundingMode mode) {
        if (n == null) {
            return null;
        }
        return UnsignedType.toULongNonNull(n, mode);
    }

    public static @Nullable ULong toULong(@Nullable String s, RoundingMode unused) {
        if (s == null) {
            return null;
        }
        return Unsigned.ulong((String)s);
    }

    public static @Nullable UShort toUShort(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Number) {
            return UShort.valueOf((int)((Number)o).intValue());
        }
        throw new IllegalArgumentException("Cannot cast to UShort: " + o.getClass());
    }

    public static @Nullable UByte toUByte(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Number) {
            return UByte.valueOf((short)((Number)o).shortValue());
        }
        throw new IllegalArgumentException("Cannot cast to UByte: " + o.getClass());
    }

    public static @Nullable UInteger toUInteger(Object o) {
        if (o instanceof Number) {
            return UInteger.valueOf((long)((Number)o).longValue());
        }
        throw new IllegalArgumentException("Cannot cast to UInteger: " + o.getClass());
    }

    public static @Nullable ULong toULong(Object o) {
        if (o instanceof Number) {
            return ULong.valueOf((long)((Number)o).longValue());
        }
        throw new IllegalArgumentException("Cannot cast to ULong: " + o.getClass());
    }
}

