/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.innodb;

import com.alibaba.innodb.java.reader.TableReader;
import com.alibaba.innodb.java.reader.TableReaderFactory;
import com.alibaba.innodb.java.reader.comparator.ComparisonOperator;
import com.alibaba.innodb.java.reader.page.index.GenericRecord;
import com.alibaba.innodb.java.reader.schema.KeyMeta;
import com.alibaba.innodb.java.reader.schema.TableDef;
import com.alibaba.innodb.java.reader.service.impl.RecordIterator;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.calcite.adapter.innodb.IndexCondition;
import org.apache.calcite.adapter.innodb.InnodbEnumerator;
import org.apache.calcite.adapter.innodb.InnodbRel;
import org.apache.calcite.adapter.innodb.InnodbSchema;
import org.apache.calcite.adapter.innodb.InnodbTableScan;
import org.apache.calcite.adapter.innodb.QueryType;
import org.apache.calcite.adapter.java.AbstractQueryableTable;
import org.apache.calcite.linq4j.AbstractEnumerable;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.QueryProvider;
import org.apache.calcite.linq4j.Queryable;
import org.apache.calcite.linq4j.function.Function1;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeImpl;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.calcite.schema.QueryableTable;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.TranslatableTable;
import org.apache.calcite.schema.impl.AbstractTableQueryable;
import org.apache.calcite.sql.type.SqlTypeFactoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InnodbTable
extends AbstractQueryableTable
implements TranslatableTable {
    private static final Logger LOGGER = LoggerFactory.getLogger(InnodbTable.class);
    private final InnodbSchema schema;
    private final String tableName;
    private final Supplier<RelProtoDataType> protoRowTypeSupplier = Suppliers.memoize(this::supplyProto);
    private final Supplier<TableDef> tableDefSupplier = Suppliers.memoize(this::supplyTableDef);

    public InnodbTable(InnodbSchema schema, String tableName) {
        super(Object[].class);
        this.schema = schema;
        this.tableName = tableName;
    }

    public String toString() {
        return "InnodbTable {" + this.tableName + "}";
    }

    private RelProtoDataType supplyProto() {
        return this.schema.getRelDataType(this.tableName);
    }

    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        return (RelDataType)this.protoRowTypeSupplier.get().apply((Object)typeFactory);
    }

    public TableDef getTableDef() {
        return this.tableDefSupplier.get();
    }

    private TableDef supplyTableDef() {
        return this.schema.getTableDef(this.tableName);
    }

    public Set<String> getIndexesNameSet() {
        return ImmutableSet.builder().add((Object)"PRIMARY_KEY").addAll((Iterable)this.getTableDef().getSecondaryKeyMetaList().stream().map(KeyMeta::getName).collect(Collectors.toList())).build();
    }

    public Enumerable<Object> query(TableReaderFactory tableReaderFactory) {
        return this.query(tableReaderFactory, (List<Map.Entry<String, Class>>)ImmutableList.of(), (List<Map.Entry<String, String>>)ImmutableList.of(), IndexCondition.EMPTY_CONDITION, true);
    }

    public Enumerable<Object> query(TableReaderFactory tableReaderFactory, List<Map.Entry<String, Class>> fields, List<Map.Entry<String, String>> selectFields, IndexCondition condition, final Boolean ascOrder) {
        final QueryType queryType = condition.getQueryType();
        final List<Object> pointQueryKey = condition.getPointQueryKey();
        final ComparisonOperator rangeQueryLowerOp = condition.getRangeQueryLowerOp();
        final List<Object> rangeQueryLowerKey = condition.getRangeQueryLowerKey();
        final ComparisonOperator rangeQueryUpperOp = condition.getRangeQueryUpperOp();
        final List<Object> rangeQueryUpperKey = condition.getRangeQueryUpperKey();
        final String indexName = condition.getIndexName();
        SqlTypeFactoryImpl typeFactory = new SqlTypeFactoryImpl(RelDataTypeSystem.DEFAULT);
        RelDataTypeFactory.FieldInfoBuilder fieldInfo = typeFactory.builder();
        RelDataType rowType = this.getRowType((RelDataTypeFactory)typeFactory);
        Function1 addField = arg_0 -> InnodbTable.lambda$query$0(rowType, (RelDataTypeFactory.Builder)fieldInfo, arg_0);
        final ArrayList<String> selectedColumnNames = new ArrayList<String>(selectFields.size());
        if (selectFields.isEmpty()) {
            for (Map.Entry<String, Object> entry : fields) {
                addField.apply((Object)entry.getKey());
            }
        } else {
            for (Map.Entry<String, Object> entry : selectFields) {
                addField.apply((Object)entry.getKey());
                selectedColumnNames.add(entry.getKey());
            }
        }
        final RelProtoDataType resultRowType = RelDataTypeImpl.proto((RelDataType)fieldInfo.build());
        final TableReader tableReader = tableReaderFactory.createTableReader(this.tableName);
        tableReader.open();
        return new AbstractEnumerable<Object>((RelDataTypeFactory)typeFactory){
            final /* synthetic */ RelDataTypeFactory val$typeFactory;
            {
                this.val$typeFactory = relDataTypeFactory;
            }

            public Enumerator<Object> enumerator() {
                Object resultIterator;
                LOGGER.debug("Create query iterator, queryType={}, indexName={}, pointQueryKey={}, projection={}, rangeQueryKey={}{} AND {}{}, ascOrder={}", new Object[]{queryType, indexName, pointQueryKey, selectedColumnNames, rangeQueryLowerKey, rangeQueryLowerOp, rangeQueryUpperKey, rangeQueryUpperOp, ascOrder});
                switch (queryType) {
                    case PK_POINT_QUERY: {
                        resultIterator = RecordIterator.create((GenericRecord)tableReader.queryByPrimaryKey(pointQueryKey, selectedColumnNames));
                        break;
                    }
                    case PK_RANGE_QUERY: {
                        resultIterator = tableReader.getRangeQueryIterator(rangeQueryLowerKey, rangeQueryLowerOp, rangeQueryUpperKey, rangeQueryUpperOp, selectedColumnNames, ascOrder.booleanValue());
                        break;
                    }
                    case SK_POINT_QUERY: {
                        resultIterator = tableReader.getRecordIteratorBySk(indexName, pointQueryKey, ComparisonOperator.GTE, pointQueryKey, ComparisonOperator.LTE, selectedColumnNames, ascOrder.booleanValue());
                        break;
                    }
                    case SK_RANGE_QUERY: 
                    case SK_FULL_SCAN: {
                        resultIterator = tableReader.getRecordIteratorBySk(indexName, rangeQueryLowerKey, rangeQueryLowerOp, rangeQueryUpperKey, rangeQueryUpperOp, selectedColumnNames, ascOrder.booleanValue());
                        break;
                    }
                    case PK_FULL_SCAN: {
                        resultIterator = tableReader.getQueryAllIterator(selectedColumnNames, ascOrder.booleanValue());
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)"query type is invalid");
                    }
                }
                RelDataType rowType = (RelDataType)resultRowType.apply((Object)this.val$typeFactory);
                return new InnodbEnumerator((Iterator)resultIterator, rowType){

                    @Override
                    public void close() {
                        super.close();
                        tableReader.close();
                    }
                };
            }
        };
    }

    public <T> Queryable<T> asQueryable(QueryProvider queryProvider, SchemaPlus schema, String tableName) {
        return new InnodbQueryable(queryProvider, schema, this, tableName);
    }

    public RelNode toRel(RelOptTable.ToRelContext context, RelOptTable relOptTable) {
        RelOptCluster cluster = context.getCluster();
        return new InnodbTableScan(cluster, cluster.traitSetOf((RelTrait)InnodbRel.CONVENTION), relOptTable, this, null, context.getTableHints());
    }

    private static /* synthetic */ Void lambda$query$0(RelDataType rowType, RelDataTypeFactory.Builder fieldInfo, String fieldName) {
        RelDataTypeField field = Objects.requireNonNull(rowType.getField(fieldName, true, false));
        RelDataType relDataType = field.getType();
        fieldInfo.add(fieldName, relDataType).nullable(relDataType.isNullable());
        return null;
    }

    public static class InnodbQueryable<T>
    extends AbstractTableQueryable<T> {
        public InnodbQueryable(QueryProvider queryProvider, SchemaPlus schema, InnodbTable table, String tableName) {
            super(queryProvider, schema, (QueryableTable)table, tableName);
        }

        public Enumerator<T> enumerator() {
            Enumerable<Object> enumerable = this.getTable().query(this.getTableReaderFactory());
            return enumerable.enumerator();
        }

        private InnodbTable getTable() {
            return (InnodbTable)this.table;
        }

        private TableReaderFactory getTableReaderFactory() {
            InnodbSchema innodbSchema = (InnodbSchema)((Object)Objects.requireNonNull(this.schema.unwrap(InnodbSchema.class)));
            return innodbSchema.tableReaderFactory;
        }

        public Enumerable<Object> query(List<Map.Entry<String, Class>> fields, List<Map.Entry<String, String>> selectFields, IndexCondition condition, Boolean ascOrder) {
            return this.getTable().query(this.getTableReaderFactory(), fields, selectFields, condition, ascOrder);
        }
    }
}

