/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.innodb;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.adapter.innodb.InnodbRel;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexNode;
import org.checkerframework.checker.nullness.qual.Nullable;

public class InnodbSort
extends Sort
implements InnodbRel {
    InnodbSort(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, RelCollation collation) {
        super(cluster, traitSet, input, collation, null, null);
        assert (this.getConvention() == InnodbRel.CONVENTION);
        assert (this.getConvention() == input.getConvention());
    }

    public @Nullable RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        RelOptCost cost = Objects.requireNonNull(super.computeSelfCost(planner, mq));
        if (!this.collation.getFieldCollations().isEmpty()) {
            return cost.multiplyBy(0.05);
        }
        return cost;
    }

    public Sort copy(RelTraitSet traitSet, RelNode input, RelCollation newCollation, RexNode offset, RexNode fetch) {
        return new InnodbSort(this.getCluster(), traitSet, input, this.collation);
    }

    @Override
    public void implement(InnodbRel.Implementor implementor) {
        implementor.visitChild(0, this.getInput());
        List sortCollations = this.collation.getFieldCollations();
        boolean allDesc = sortCollations.stream().allMatch(r -> r.direction.isDescending());
        boolean allNonDesc = sortCollations.stream().noneMatch(r -> r.direction.isDescending());
        Preconditions.checkState((allDesc || allNonDesc ? 1 : 0) != 0, (Object)("ordering should be in a series of ascending or descending collations " + sortCollations));
        implementor.setAscOrder(!allDesc);
    }
}

