/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.innodb;

import com.alibaba.innodb.java.reader.comparator.ComparisonOperator;
import com.alibaba.innodb.java.reader.schema.KeyMeta;
import com.alibaba.innodb.java.reader.schema.TableDef;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.calcite.adapter.innodb.IndexCondition;
import org.apache.calcite.adapter.innodb.InnodbRules;
import org.apache.calcite.adapter.innodb.QueryType;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.DateString;
import org.apache.calcite.util.TimeString;
import org.apache.calcite.util.TimestampString;
import org.checkerframework.checker.nullness.qual.Nullable;

class InnodbFilterTranslator {
    private final RexBuilder rexBuilder;
    private final List<String> fieldNames;
    private final KeyMeta pkMeta;
    private final List<KeyMeta> skMetaList;
    private final @Nullable String forceIndexName;

    InnodbFilterTranslator(RexBuilder rexBuilder, RelDataType rowType, TableDef tableDef, @Nullable String forceIndexName) {
        this.rexBuilder = rexBuilder;
        this.fieldNames = InnodbRules.innodbFieldNames(rowType);
        this.pkMeta = tableDef.getPrimaryKeyMeta();
        this.skMetaList = tableDef.getSecondaryKeyMetaList();
        this.forceIndexName = forceIndexName;
    }

    public IndexCondition translateMatch(RexNode condition) {
        List disjunctions = RelOptUtil.disjunctions((RexNode)condition);
        if (disjunctions.size() == 1) {
            return this.translateAnd((RexNode)disjunctions.get(0));
        }
        throw new AssertionError((Object)("cannot translate " + condition));
    }

    private IndexCondition translateAnd(RexNode condition) {
        RexNode condition2 = RexUtil.expandSearch((RexBuilder)this.rexBuilder, null, (RexNode)condition);
        List rexNodeList = RelOptUtil.conjunctions((RexNode)condition2);
        ArrayList<IndexCondition> indexConditions = new ArrayList<IndexCondition>();
        if (this.pkMeta != null) {
            IndexCondition pkPushDownCond = this.findPushDownCondition(rexNodeList, this.pkMeta);
            indexConditions.add(pkPushDownCond);
        }
        if (!this.skMetaList.isEmpty()) {
            for (KeyMeta skMeta : this.skMetaList) {
                indexConditions.add(this.findPushDownCondition(rexNodeList, skMeta));
            }
        }
        Stream<IndexCondition> pushDownConditions = indexConditions.stream().filter(IndexCondition::canPushDown).filter(this::nonForceIndexOrMatchForceIndexName).sorted(new IndexConditionComparator());
        return pushDownConditions.findFirst().orElse(IndexCondition.EMPTY_CONDITION);
    }

    private IndexCondition findPushDownCondition(List<RexNode> rexNodeList, KeyMeta keyMeta) {
        List<InternalRexNode> matchedRexNodeList = this.analyzePrefixMatches(rexNodeList, keyMeta);
        if (matchedRexNodeList.isEmpty()) {
            return IndexCondition.EMPTY_CONDITION;
        }
        HashMultimap keyOrdToNodesMap = HashMultimap.create();
        for (InternalRexNode node : matchedRexNodeList) {
            keyOrdToNodesMap.put((Object)node.ordinalInKey, (Object)node);
        }
        Collection leftMostKeyNodes = keyOrdToNodesMap.get((Object)0);
        if (leftMostKeyNodes == null || leftMostKeyNodes.isEmpty()) {
            return IndexCondition.EMPTY_CONDITION;
        }
        List indexColumnNames = keyMeta.getKeyColumnNames();
        ArrayList<RexNode> pushDownRexNodeList = new ArrayList<RexNode>();
        ArrayList<RexNode> remainderRexNodeList = new ArrayList<RexNode>(rexNodeList);
        IndexCondition condition = IndexCondition.create(this.fieldNames, keyMeta.getName(), indexColumnNames, pushDownRexNodeList, remainderRexNodeList);
        if ((condition = InnodbFilterTranslator.handlePointQuery(condition, keyMeta, leftMostKeyNodes, (Multimap<Integer, InternalRexNode>)keyOrdToNodesMap, pushDownRexNodeList, remainderRexNodeList)).canPushDown()) {
            return condition;
        }
        condition = InnodbFilterTranslator.handleRangeQuery(condition, keyMeta, leftMostKeyNodes, pushDownRexNodeList, remainderRexNodeList, ">=", ">");
        condition = InnodbFilterTranslator.handleRangeQuery(condition, keyMeta, leftMostKeyNodes, pushDownRexNodeList, remainderRexNodeList, "<=", "<");
        return condition;
    }

    private List<InternalRexNode> analyzePrefixMatches(List<RexNode> rexNodeList, KeyMeta keyMeta) {
        return rexNodeList.stream().map(rexNode -> this.translateMatch2((RexNode)rexNode, keyMeta)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private static IndexCondition handlePointQuery(IndexCondition condition, KeyMeta keyMeta, Collection<InternalRexNode> leftMostKeyNodes, Multimap<Integer, InternalRexNode> keyOrdToNodesMap, List<RexNode> pushDownRexNodeList, List<RexNode> remainderRexNodeList) {
        Optional<InternalRexNode> leftMostEqOpNode = InnodbFilterTranslator.findFirstOp(leftMostKeyNodes, "=");
        if (leftMostEqOpNode.isPresent()) {
            InternalRexNode node = leftMostEqOpNode.get();
            ArrayList matchNodes = Lists.newArrayList((Object[])new InternalRexNode[]{node});
            InnodbFilterTranslator.findSubsequentMatches(matchNodes, keyMeta.getNumOfColumns(), keyOrdToNodesMap, "=");
            List<Object> key = InnodbFilterTranslator.createKey(matchNodes);
            pushDownRexNodeList.add(node.node);
            remainderRexNodeList.remove(node.node);
            if (matchNodes.size() != keyMeta.getNumOfColumns()) {
                return condition.withQueryType(QueryType.getRangeQuery(keyMeta.isSecondaryKey())).withRangeQueryLowerOp(ComparisonOperator.GTE).withRangeQueryLowerKey(key).withRangeQueryUpperOp(ComparisonOperator.LTE).withRangeQueryUpperKey(key).withPushDownConditions(pushDownRexNodeList).withRemainderConditions(remainderRexNodeList);
            }
            for (InternalRexNode n : matchNodes) {
                pushDownRexNodeList.add(n.node);
                remainderRexNodeList.remove(n.node);
            }
            return condition.withQueryType(QueryType.getPointQuery(keyMeta.isSecondaryKey())).withPointQueryKey(key).withPushDownConditions(pushDownRexNodeList).withRemainderConditions(remainderRexNodeList);
        }
        return condition;
    }

    private static IndexCondition handleRangeQuery(IndexCondition condition, KeyMeta keyMeta, Collection<InternalRexNode> leftMostKeyNodes, List<RexNode> pushDownRexNodeList, List<RexNode> remainderRexNodeList, String ... opList) {
        Optional<InternalRexNode> node = InnodbFilterTranslator.findFirstOp(leftMostKeyNodes, opList);
        if (node.isPresent()) {
            pushDownRexNodeList.add(node.get().node);
            remainderRexNodeList.remove(node.get().node);
            List<Object> key = InnodbFilterTranslator.createKey(Lists.newArrayList((Object[])new InternalRexNode[]{node.get()}));
            ComparisonOperator op = ComparisonOperator.parse((String)node.get().op);
            if (ComparisonOperator.isLowerBoundOp((String[])opList)) {
                return condition.withQueryType(QueryType.getRangeQuery(keyMeta.isSecondaryKey())).withRangeQueryLowerOp(op).withRangeQueryLowerKey(key).withPushDownConditions(pushDownRexNodeList).withRemainderConditions(remainderRexNodeList);
            }
            if (ComparisonOperator.isUpperBoundOp((String[])opList)) {
                return condition.withQueryType(QueryType.getRangeQuery(keyMeta.isSecondaryKey())).withRangeQueryUpperOp(op).withRangeQueryUpperKey(key).withPushDownConditions(pushDownRexNodeList).withRemainderConditions(remainderRexNodeList);
            }
            throw new AssertionError((Object)("comparison operation is invalid " + op));
        }
        return condition;
    }

    private Optional<InternalRexNode> translateMatch2(RexNode node, KeyMeta keyMeta) {
        switch (node.getKind()) {
            case EQUALS: {
                return this.translateBinary("=", "=", (RexCall)node, keyMeta);
            }
            case LESS_THAN: {
                return this.translateBinary("<", ">", (RexCall)node, keyMeta);
            }
            case LESS_THAN_OR_EQUAL: {
                return this.translateBinary("<=", ">=", (RexCall)node, keyMeta);
            }
            case GREATER_THAN: {
                return this.translateBinary(">", "<", (RexCall)node, keyMeta);
            }
            case GREATER_THAN_OR_EQUAL: {
                return this.translateBinary(">=", "<=", (RexCall)node, keyMeta);
            }
        }
        return Optional.empty();
    }

    private Optional<InternalRexNode> translateBinary(String op, String rop, RexCall call, KeyMeta keyMeta) {
        RexNode right;
        RexNode left = (RexNode)call.operands.get(0);
        Optional<InternalRexNode> expression = this.translateBinary2(op, left, right = (RexNode)call.operands.get(1), (RexNode)call, keyMeta);
        if (expression.isPresent()) {
            return expression;
        }
        expression = this.translateBinary2(rop, right, left, (RexNode)call, keyMeta);
        return expression;
    }

    private Optional<InternalRexNode> translateBinary2(String op, RexNode left, RexNode right, RexNode originNode, KeyMeta keyMeta) {
        RexLiteral rightLiteral;
        if (right.isA(SqlKind.LITERAL)) {
            rightLiteral = (RexLiteral)right;
        } else if (right.isA(SqlKind.CAST) && InnodbFilterTranslator.isSqlTypeMatch((RexCall)right, SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE)) {
            rightLiteral = (RexLiteral)((RexCall)right).operands.get(0);
        } else {
            return Optional.empty();
        }
        switch (left.getKind()) {
            case INPUT_REF: {
                RexInputRef left1 = (RexInputRef)left;
                String name = this.fieldNames.get(left1.getIndex());
                if (!keyMeta.getKeyColumnNames().contains(name)) {
                    return Optional.empty();
                }
                return InnodbFilterTranslator.translateOp2(op, name, rightLiteral, originNode, keyMeta);
            }
            case CAST: {
                return this.translateBinary2(op, (RexNode)((RexCall)left).operands.get(0), right, originNode, keyMeta);
            }
        }
        return Optional.empty();
    }

    private static Optional<InternalRexNode> translateOp2(String op, String name, RexLiteral right, RexNode originNode, KeyMeta keyMeta) {
        String value = InnodbFilterTranslator.literalValue(right);
        InternalRexNode node = new InternalRexNode();
        node.node = originNode;
        node.ordinalInKey = keyMeta.getKeyColumnNames().indexOf(name);
        if (keyMeta.getVarLen(name).isPresent() && (Integer)keyMeta.getVarLen(name).get() < value.length()) {
            return Optional.empty();
        }
        node.fieldName = name;
        node.op = op;
        node.right = value;
        return Optional.of(node);
    }

    private static String literalValue(RexLiteral literal) {
        switch (literal.getTypeName()) {
            case DATE: {
                return String.valueOf(literal.getValueAs(DateString.class));
            }
            case TIMESTAMP: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return String.valueOf(literal.getValueAs(TimestampString.class));
            }
            case TIME: 
            case TIME_WITH_LOCAL_TIME_ZONE: {
                return String.valueOf(literal.getValueAs(TimeString.class));
            }
            case DECIMAL: {
                return String.valueOf(literal.getValue());
            }
        }
        return String.valueOf(literal.getValue2());
    }

    private static void findSubsequentMatches(List<InternalRexNode> nodes, int numOfKeyColumns, Multimap<Integer, InternalRexNode> keyOrdToNodesMap, String op) {
        Optional<InternalRexNode> eqOpNode;
        for (int i = nodes.size(); i < numOfKeyColumns && (eqOpNode = InnodbFilterTranslator.findFirstOp(keyOrdToNodesMap.get((Object)i), op)).isPresent(); ++i) {
            nodes.add(eqOpNode.get());
        }
    }

    private static List<Object> createKey(List<InternalRexNode> nodes) {
        return nodes.stream().map(n -> n.right).collect(Collectors.toList());
    }

    private static Optional<InternalRexNode> findFirstOp(Collection<InternalRexNode> nodes, String ... opList) {
        if (nodes.isEmpty()) {
            return Optional.empty();
        }
        for (InternalRexNode node : nodes) {
            for (String op : opList) {
                if (!op.equals(node.op)) continue;
                return Optional.of(node);
            }
        }
        return Optional.empty();
    }

    private boolean nonForceIndexOrMatchForceIndexName(IndexCondition indexCondition) {
        return Optional.ofNullable(this.forceIndexName).map(indexCondition::nameMatch).orElse(true);
    }

    private static boolean isSqlTypeMatch(RexCall rexCall, SqlTypeName sqlTypeName) {
        return Objects.requireNonNull(rexCall, (String)"rexCall").type.getSqlTypeName() == Objects.requireNonNull(sqlTypeName, "sqlTypeName");
    }

    static class IndexConditionComparator
    implements Comparator<IndexCondition> {
        IndexConditionComparator() {
        }

        @Override
        public int compare(IndexCondition o1, IndexCondition o2) {
            return Integer.compare(o1.getQueryType().priority(), o2.getQueryType().priority());
        }
    }

    private static class InternalRexNode {
        RexNode node;
        int ordinalInKey;
        String fieldName;
        String op;
        Object right;

        private InternalRexNode() {
        }
    }
}

