/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.innodb;

import com.alibaba.innodb.java.reader.schema.TableDef;
import java.util.Objects;
import org.apache.calcite.adapter.innodb.IndexCondition;
import org.apache.calcite.adapter.innodb.InnodbRel;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexNode;
import org.checkerframework.checker.nullness.qual.Nullable;

public class InnodbFilter
extends Filter
implements InnodbRel {
    private final TableDef tableDef;
    public final IndexCondition indexCondition;
    private final @Nullable String forceIndexName;

    private InnodbFilter(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, RexNode condition, IndexCondition indexCondition, TableDef tableDef, @Nullable String forceIndexName) {
        super(cluster, traitSet, input, condition);
        this.tableDef = Objects.requireNonNull(tableDef, "tableDef");
        this.indexCondition = Objects.requireNonNull(indexCondition, "indexCondition");
        this.forceIndexName = forceIndexName;
        assert (this.getConvention() == InnodbRel.CONVENTION);
        assert (this.getConvention() == input.getConvention());
    }

    public static InnodbFilter create(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, RexNode condition, IndexCondition indexCondition, TableDef tableDef, @Nullable String forceIndexName) {
        return new InnodbFilter(cluster, traitSet, input, condition, indexCondition, tableDef, forceIndexName);
    }

    public @Nullable RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        RelOptCost cost = Objects.requireNonNull(super.computeSelfCost(planner, mq));
        return cost.multiplyBy(0.1);
    }

    public InnodbFilter copy(RelTraitSet traitSet, RelNode input, RexNode condition) {
        return new InnodbFilter(this.getCluster(), traitSet, input, condition, this.indexCondition, this.tableDef, this.forceIndexName);
    }

    @Override
    public void implement(InnodbRel.Implementor implementor) {
        implementor.visitChild(0, this.getInput());
        implementor.setIndexCondition(this.indexCondition);
    }

    public RelWriter explainTerms(RelWriter pw) {
        pw.input("input", this.getInput());
        pw.itemIf("condition", (Object)this.indexCondition, this.indexCondition.canPushDown());
        return pw;
    }

    public RelCollation getImplicitCollation() {
        return this.indexCondition.getImplicitCollation();
    }
}

