/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.innodb;

import com.alibaba.innodb.java.reader.page.index.GenericRecord;
import com.alibaba.innodb.java.reader.util.Utils;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import org.apache.calcite.avatica.util.ByteString;
import org.apache.calcite.avatica.util.DateTimeUtils;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.sql.type.SqlTypeName;
import org.checkerframework.checker.nullness.qual.Nullable;

class InnodbEnumerator
implements Enumerator<Object> {
    private final Iterator<GenericRecord> iterator;
    private @Nullable GenericRecord current;
    private final List<RelDataTypeField> fieldTypes;

    InnodbEnumerator(Iterator<GenericRecord> resultIterator, RelDataType rowType) {
        this.iterator = resultIterator;
        this.current = null;
        this.fieldTypes = rowType.getFieldList();
    }

    public Object current() {
        if (this.fieldTypes.size() == 1) {
            return this.currentRowField(this.fieldTypes.get(0));
        }
        Object[] row = new Object[this.fieldTypes.size()];
        for (int i = 0; i < this.fieldTypes.size(); ++i) {
            row[i] = this.currentRowField(this.fieldTypes.get(i));
        }
        return row;
    }

    private @Nullable Object currentRowField(RelDataTypeField relDataTypeField) {
        if (this.current == null) {
            throw new IllegalStateException();
        }
        Object o = this.current.get(relDataTypeField.getName());
        return InnodbEnumerator.convertToEnumeratorObject(o, relDataTypeField.getType());
    }

    private static @Nullable Object convertToEnumeratorObject(@Nullable Object obj, RelDataType relDataType) {
        if (obj == null) {
            return null;
        }
        SqlTypeName sqlTypeName = relDataType.getSqlTypeName();
        switch (sqlTypeName) {
            case BINARY: 
            case VARBINARY: {
                return new ByteString((byte[])obj);
            }
            case TIMESTAMP: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                Timestamp timestamp = Utils.convertDateTime((String)((String)obj), (int)relDataType.getPrecision());
                return InnodbEnumerator.shift(timestamp).getTime();
            }
            case TIME: {
                Time time = Utils.convertTime((String)((String)obj), (int)relDataType.getPrecision());
                return InnodbEnumerator.shift(time).getTime();
            }
            case DATE: {
                Date date = Date.valueOf(LocalDate.parse((String)obj));
                return DateTimeUtils.dateStringToUnixDate((String)date.toString());
            }
        }
        return obj;
    }

    public boolean moveNext() {
        if (this.iterator.hasNext()) {
            this.current = this.iterator.next();
            return true;
        }
        return false;
    }

    public void reset() {
        throw new UnsupportedOperationException();
    }

    public void close() {
    }

    private static Timestamp shift(Timestamp v) {
        long time = v.getTime();
        int offset = TimeZone.getDefault().getOffset(time);
        return new Timestamp(time + (long)offset);
    }

    private static Time shift(Time v) {
        long time = v.getTime();
        int offset = TimeZone.getDefault().getOffset(time);
        return new Time((time + (long)offset) % 86400000L);
    }
}

