/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.guice;

import com.google.inject.Inject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import javax.validation.ConstraintViolationException;
import javax.validation.Validator;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.bval.guice.Validate;
import org.apache.bval.guice.ValidatorProvider;
import org.apache.bval.jsr303.extensions.MethodValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ValidateMethodInterceptor
implements MethodInterceptor {
    @Inject
    private ValidatorProvider validatorProvider;

    public void setValidatorProvider(ValidatorProvider validatorProvider) {
        this.validatorProvider = validatorProvider;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Validate validate = invocation.getMethod().getAnnotation(Validate.class);
        Validator validator = this.validatorProvider.get();
        MethodValidator methodValidator = (MethodValidator)validator.unwrap(MethodValidator.class);
        HashSet constraintViolations = new HashSet();
        Class<?> clazz = invocation.getMethod().getDeclaringClass();
        Method method = invocation.getMethod();
        Object[] arguments = invocation.getArguments();
        Class[] groups = validate.groups();
        constraintViolations.addAll(methodValidator.validateParameters(clazz, method, arguments, groups));
        if (!constraintViolations.isEmpty()) {
            throw ValidateMethodInterceptor.getException(new ConstraintViolationException("Validation error when calling method '" + method + "' with arguments " + Arrays.deepToString(arguments), constraintViolations), validate.rethrowExceptionsAs());
        }
        Object returnedValue = invocation.proceed();
        if (validate.validateReturnedValue()) {
            constraintViolations.addAll(methodValidator.validateReturnedValue(clazz, method, returnedValue, groups));
            if (!constraintViolations.isEmpty()) {
                throw ValidateMethodInterceptor.getException(new ConstraintViolationException("Method '" + method + "' returned a not valid value " + returnedValue, constraintViolations), validate.rethrowExceptionsAs());
            }
        }
        return returnedValue;
    }

    private static Throwable getException(ConstraintViolationException exception, Class<? extends Throwable> exceptionWrapperClass) {
        if (exceptionWrapperClass == ConstraintViolationException.class) {
            return exception;
        }
        Throwable rethrowEx = null;
        try {
            Constructor<? extends Throwable> constructor = exceptionWrapperClass.getConstructor(Throwable.class);
            rethrowEx = constructor.newInstance(exception);
        }
        catch (Exception e) {
            rethrowEx = new RuntimeException("Impossible to re-throw '" + exceptionWrapperClass + "', it needs the constructor with <Throwable> argument.", e);
        }
        return rethrowEx;
    }
}

