/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.demo;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.entity.Group;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.entity.EntityAsserts;
import org.apache.brooklyn.core.entity.StartableApplication;
import org.apache.brooklyn.core.mgmt.rebind.RebindOptions;
import org.apache.brooklyn.core.mgmt.rebind.RebindTestFixture;
import org.apache.brooklyn.demo.WebClusterDatabaseExampleApp;
import org.apache.brooklyn.enricher.stock.Propagator;
import org.apache.brooklyn.entity.database.mysql.MySqlNode;
import org.apache.brooklyn.entity.group.DynamicCluster;
import org.apache.brooklyn.entity.java.JavaEntityMethods;
import org.apache.brooklyn.entity.proxy.nginx.NginxController;
import org.apache.brooklyn.entity.webapp.ControlledDynamicWebAppCluster;
import org.apache.brooklyn.entity.webapp.DynamicWebAppCluster;
import org.apache.brooklyn.entity.webapp.tomcat.Tomcat8Server;
import org.apache.brooklyn.policy.autoscaling.AutoScalerPolicy;
import org.apache.brooklyn.policy.enricher.HttpLatencyDetector;
import org.apache.brooklyn.test.Asserts;
import org.apache.brooklyn.test.HttpTestUtils;
import org.apache.brooklyn.test.WebAppMonitor;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class RebindWebClusterDatabaseExampleAppIntegrationTest
extends RebindTestFixture<StartableApplication> {
    private static final Logger LOG = LoggerFactory.getLogger(RebindWebClusterDatabaseExampleAppIntegrationTest.class);
    private Location origLoc;
    private List<WebAppMonitor> webAppMonitors = new CopyOnWriteArrayList<WebAppMonitor>();
    private ExecutorService executor;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        super.setUp();
        this.origLoc = this.origManagementContext.getLocationRegistry().resolve("localhost");
        this.executor = Executors.newCachedThreadPool();
        this.webAppMonitors.clear();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        for (WebAppMonitor monitor : this.webAppMonitors) {
            monitor.terminate();
        }
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
        super.tearDown();
    }

    protected StartableApplication createApp() {
        StartableApplication result = (StartableApplication)this.origManagementContext.getEntityManager().createEntity((EntitySpec)EntitySpec.create(StartableApplication.class).impl(WebClusterDatabaseExampleApp.class).configure((ConfigKey)DynamicCluster.INITIAL_SIZE, (Object)2));
        return result;
    }

    private WebAppMonitor newWebAppMonitor(String url, int expectedResponseCode) {
        WebAppMonitor monitor = new WebAppMonitor(url).expectedResponseCode(expectedResponseCode).logFailures(LOG);
        this.webAppMonitors.add(monitor);
        this.executor.execute((Runnable)monitor);
        return monitor;
    }

    @Test(groups={"Integration"})
    public void testRestoresSimpleApp() throws Exception {
        this.origApp.start((Collection)ImmutableList.of((Object)this.origLoc));
        this.assertAppFunctional(this.origApp);
        String clusterUrl = (String)Preconditions.checkNotNull((Object)this.origApp.getAttribute(WebClusterDatabaseExampleApp.ROOT_URL), (Object)"cluster url");
        WebAppMonitor monitor = this.newWebAppMonitor(clusterUrl, 200);
        this.newApp = this.rebind(RebindOptions.create().terminateOrigManagementContext(true));
        this.assertAppFunctional(this.newApp);
        monitor.assertNoFailures("hitting nginx url");
        monitor.terminate();
    }

    private void assertAppFunctional(StartableApplication app) throws Exception {
        Assert.assertNotNull((Object)app.getConfig(WebClusterDatabaseExampleApp.WAR_PATH));
        Assert.assertEquals((Object)app.getConfig(WebClusterDatabaseExampleApp.USE_HTTPS), (Object)Boolean.FALSE);
        Assert.assertNotNull((Object)app.getConfig(WebClusterDatabaseExampleApp.DB_SETUP_SQL_URL));
        MySqlNode mysql = (MySqlNode)Iterables.find((Iterable)app.getChildren(), (Predicate)Predicates.instanceOf(MySqlNode.class));
        ControlledDynamicWebAppCluster web = (ControlledDynamicWebAppCluster)Iterables.find((Iterable)app.getChildren(), (Predicate)Predicates.instanceOf(ControlledDynamicWebAppCluster.class));
        final NginxController nginx = (NginxController)Iterables.find((Iterable)web.getChildren(), (Predicate)Predicates.instanceOf(NginxController.class));
        DynamicWebAppCluster webCluster = (DynamicWebAppCluster)Iterables.find((Iterable)web.getChildren(), (Predicate)Predicates.instanceOf(DynamicWebAppCluster.class));
        Collection appservers = web.getMembers();
        Assert.assertEquals((int)appservers.size(), (int)2);
        String clusterUrl = (String)Preconditions.checkNotNull((Object)app.getAttribute(WebClusterDatabaseExampleApp.ROOT_URL), (Object)"cluster url");
        String dbUrl = (String)Preconditions.checkNotNull((Object)mysql.getAttribute(MySqlNode.DATASTORE_URL), (Object)"database url");
        final String expectedJdbcUrl = String.format("jdbc:%s%s?user=%s\\&password=%s", dbUrl, "visitors", "brooklyn", "br00k11n");
        HttpTestUtils.assertHttpStatusCodeEventuallyEquals((String)clusterUrl, (int)200);
        for (Entity appserver : appservers) {
            String appserverUrl = (String)Preconditions.checkNotNull((Object)appserver.getAttribute(Tomcat8Server.ROOT_URL), (Object)("appserver url of " + appserver));
            HttpTestUtils.assertHttpStatusCodeEventuallyEquals((String)appserverUrl, (int)200);
            Assert.assertEquals((String)expectedJdbcUrl, (String)((String)appserver.getConfig(JavaEntityMethods.javaSysProp((String)"brooklyn.example.db.url"))), (String)("of " + appserver));
        }
        WebAppMonitor monitor = this.newWebAppMonitor(clusterUrl, 200);
        AutoScalerPolicy autoScalerPolicy = (AutoScalerPolicy)Iterables.find((Iterable)webCluster.policies(), (Predicate)Predicates.instanceOf(AutoScalerPolicy.class));
        autoScalerPolicy.config().set(AutoScalerPolicy.MIN_POOL_SIZE, (Object)3);
        EntityAsserts.assertGroupSizeEqualsEventually((Group)web, (int)3);
        final Collection webMembersAfterGrow = web.getMembers();
        for (final Entity appserver : webMembersAfterGrow) {
            Asserts.succeedsEventually((Map)MutableMap.of((Object)"timeout", (Object)Duration.TWO_MINUTES), (Runnable)new Runnable(){

                @Override
                public void run() {
                    String appserverUrl = (String)Preconditions.checkNotNull((Object)appserver.getAttribute(Tomcat8Server.ROOT_URL), (Object)("appserver url of " + appserver));
                    HttpTestUtils.assertHttpStatusCodeEquals((String)appserverUrl, (int[])new int[]{200});
                    Assert.assertEquals((String)expectedJdbcUrl, (String)((String)appserver.getConfig(JavaEntityMethods.javaSysProp((String)"brooklyn.example.db.url"))), (String)("of " + appserver));
                    Asserts.assertEqualsIgnoringOrder(((Map)nginx.getAttribute(NginxController.SERVER_POOL_TARGETS)).keySet(), (Iterable)webMembersAfterGrow);
                }
            });
        }
        Iterables.find((Iterable)web.enrichers(), (Predicate)Predicates.instanceOf(HttpLatencyDetector.class));
        Iterable propagatorEnrichers = Iterables.filter((Iterable)web.enrichers(), (Predicate)Predicates.instanceOf(Propagator.class));
        Assert.assertEquals((int)Iterables.size((Iterable)propagatorEnrichers), (int)3, (String)("propagatorEnrichers=" + propagatorEnrichers));
        EntityAsserts.assertAttributeEqualsEventually((Entity)app, (AttributeSensor)WebClusterDatabaseExampleApp.APPSERVERS_COUNT, (Object)3);
        EntityAsserts.assertAttributeChangesEventually((Entity)web, (AttributeSensor)DynamicWebAppCluster.REQUESTS_PER_SECOND_IN_WINDOW);
        EntityAsserts.assertAttributeChangesEventually((Entity)app, (AttributeSensor)DynamicWebAppCluster.REQUESTS_PER_SECOND_IN_WINDOW);
        EntityAsserts.assertAttributeChangesEventually((Entity)web, (AttributeSensor)HttpLatencyDetector.REQUEST_LATENCY_IN_SECONDS_MOST_RECENT);
        EntityAsserts.assertAttributeChangesEventually((Entity)web, (AttributeSensor)HttpLatencyDetector.REQUEST_LATENCY_IN_SECONDS_IN_WINDOW);
        autoScalerPolicy.config().set(AutoScalerPolicy.MIN_POOL_SIZE, (Object)2);
        EntityAsserts.assertGroupSizeEqualsEventually((Group)web, (int)2);
        final Entity removedAppserver = (Entity)Iterables.getOnlyElement((Iterable)Sets.difference((Set)ImmutableSet.copyOf((Collection)webMembersAfterGrow), (Set)ImmutableSet.copyOf((Collection)web.getMembers())));
        Asserts.succeedsEventually((Runnable)new Runnable(){

            @Override
            public void run() {
                Assert.assertFalse((boolean)Entities.isManaged((Entity)removedAppserver));
            }
        });
        monitor.assertNoFailures("hitting nginx url");
        monitor.terminate();
    }
}

